/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.logconsole.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.logconsole.ILogConsoleStream;
import org.eclipse.dltk.logconsole.LogConsoleType;
import org.eclipse.dltk.logconsole.impl.AbstractLogConsole;
import org.eclipse.dltk.logconsole.ui.LogConsoleImpl;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class DefaultLogConsole
extends AbstractLogConsole {
    private final List<LogItem> items = new ArrayList<LogItem>();
    private int writePos = 0;
    private final Job writeJob = new Job(""){

        protected IStatus run(IProgressMonitor monitor) {
            this.execute();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() {
            List list = DefaultLogConsole.this.items;
            synchronized (list) {
                if (DefaultLogConsole.this.consoleImpl == null) {
                    return;
                }
                if (DefaultLogConsole.this.writePos < DefaultLogConsole.this.items.size()) {
                    int i = DefaultLogConsole.this.writePos;
                    while (i < DefaultLogConsole.this.items.size()) {
                        LogItem item = (LogItem)DefaultLogConsole.this.items.get(i);
                        DefaultLogConsole.this.consoleImpl.println(item.stream, item.message);
                        ++i;
                    }
                    DefaultLogConsole.this.writePos = DefaultLogConsole.this.items.size();
                }
            }
        }
    };
    private LogConsoleImpl consoleImpl = null;

    public DefaultLogConsole(LogConsoleType consoleType, Object identifier) {
        super(consoleType, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(ILogConsoleStream stream, Object message) {
        if (message == null) {
            return;
        }
        LogItem item = new LogItem(stream, message.toString());
        List<LogItem> list = this.items;
        synchronized (list) {
            this.items.add(item);
            if (this.consoleImpl != null) {
                this.writeJob.schedule(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        List<LogItem> list = this.items;
        synchronized (list) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            if (this.consoleImpl == null) {
                this.consoleImpl = new LogConsoleImpl(this);
                consoleManager.addConsoles(new IConsole[]{this.consoleImpl});
            }
            consoleManager.showConsoleView((IConsole)this.consoleImpl);
        }
    }

    protected void consoleInitialized() {
        this.writeJob.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consoleDisposed() {
        List<LogItem> list = this.items;
        synchronized (list) {
            this.consoleImpl = null;
            this.writePos = 0;
        }
    }

    private static class LogItem {
        final ILogConsoleStream stream;
        final String message;

        public LogItem(ILogConsoleStream stream, String message) {
            this.stream = stream;
            this.message = message;
        }
    }
}

