/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstStatement
extends Statement
implements IVariableStatement {
    private Keyword constKeyword;
    private final List<VariableDeclaration> consts = new ArrayList<VariableDeclaration>();
    private int semic = -1;

    public ConstStatement(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.constKeyword != null) {
                this.constKeyword.traverse(visitor);
            }
            for (ASTNode aSTNode : this.consts) {
                aSTNode.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    @Override
    public List<VariableDeclaration> getVariables() {
        return this.consts;
    }

    @Override
    public void addVariable(VariableDeclaration declaration) {
        this.consts.add(declaration);
    }

    public Keyword getConstKeyword() {
        return this.constKeyword;
    }

    public void setConstKeyword(Keyword keyword) {
        this.constKeyword = keyword;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.semic > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("const");
        buffer.append(" ");
        int i = 0;
        while (i < this.consts.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.consts.get(i).toSourceString(indentationString));
            ++i;
        }
        buffer.append(";\n");
        return buffer.toString();
    }
}

