/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.internal.core.builder.LocalScriptBuilder;
import org.eclipse.dltk.utils.NatureExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilderManager
extends NatureExtensionManager<IScriptBuilder> {
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.core.builder";
    private static ScriptBuilderManager manager = null;
    private Map<String, List<String>> disabled = new HashMap<String, List<String>>();
    protected final Map<Object, Integer> priorities = new IdentityHashMap<Object, Integer>();

    private ScriptBuilderManager() {
        super(LANGUAGE_EXTPOINT, IScriptBuilder.class, "#");
    }

    private static synchronized ScriptBuilderManager getManager() {
        if (manager == null) {
            manager = new ScriptBuilderManager();
        }
        return manager;
    }

    @Override
    protected void registerConfigurationElements(IConfigurationElement[] elements, String categoryAttr) {
        super.registerConfigurationElements(elements, categoryAttr);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            String natureId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("disable".equals(element.getName()) && (natureId = element.getAttribute(categoryAttr)) != null && natureId.length() != 0 && (className = element.getAttribute("className")) != null && className.length() != 0) {
                List<String> disable = this.disabled.get(natureId);
                if (disable == null) {
                    disable = new ArrayList<String>();
                    this.disabled.put(natureId, disable);
                }
                if (!disable.contains(className)) {
                    disable.add(className);
                }
            }
            ++n2;
        }
    }

    @Override
    protected boolean isValidElement(IConfigurationElement element) {
        return "builder".equals(element.getName());
    }

    static int priorityOf(IConfigurationElement element) {
        String priority = element.getAttribute("priority");
        if (priority != null) {
            try {
                return Integer.parseInt(priority);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    @Override
    protected void initializeDescriptors(List<Object> descriptors) {
        Collections.sort(descriptors, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IConfigurationElement e1 = (IConfigurationElement)o1;
                IConfigurationElement e2 = (IConfigurationElement)o2;
                return ScriptBuilderManager.priorityOf(e2) - ScriptBuilderManager.priorityOf(e1);
            }
        });
    }

    protected IScriptBuilder[] filter(IScriptBuilder[] objects, String natureId) {
        List<String> disable;
        if (objects != null && (disable = this.disabled.get(natureId)) != null) {
            ArrayList<IScriptBuilder> output = new ArrayList<IScriptBuilder>();
            IScriptBuilder[] iScriptBuilderArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptBuilder object = iScriptBuilderArray[n2];
                if (!disable.contains(object.getClass().getName())) {
                    output.add(object);
                }
                ++n2;
            }
            if (!output.isEmpty()) {
                return output.toArray((IScriptBuilder[])this.createArray(output.size()));
            }
            return null;
        }
        return objects;
    }

    @Override
    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        Object instance = super.createInstanceByDescriptor(descriptor);
        this.priorities.put(instance, ScriptBuilderManager.priorityOf((IConfigurationElement)descriptor));
        return instance;
    }

    protected IScriptBuilder[] merge(IScriptBuilder[] all, IScriptBuilder[] nature) {
        IScriptBuilder[] result = super.merge(all, nature);
        Arrays.sort(result, new Comparator<IScriptBuilder>(){

            int priority(IScriptBuilder builder) {
                Integer value = ScriptBuilderManager.this.priorities.get(builder);
                return value != null ? value : 0;
            }

            @Override
            public int compare(IScriptBuilder o1, IScriptBuilder o2) {
                return this.priority(o2) - this.priority(o1);
            }
        });
        return result;
    }

    public static IScriptBuilder[] getScriptBuilders(String natureId) {
        return (IScriptBuilder[])ScriptBuilderManager.getManager().getInstances(natureId);
    }

    public static IScriptBuilder[] getAllScriptBuilders() {
        return (IScriptBuilder[])ScriptBuilderManager.getManager().getAllInstances();
    }

    public static void build(List<IFile> files, IProgressMonitor monitor) {
        HashMap<IProject, LinkedHashSet<IFile>> byProject = new HashMap<IProject, LinkedHashSet<IFile>>();
        for (IFile file : files) {
            LinkedHashSet<IFile> projectFiles = (LinkedHashSet<IFile>)byProject.get(file.getProject());
            if (projectFiles == null) {
                projectFiles = new LinkedHashSet<IFile>();
                byProject.put(file.getProject(), projectFiles);
            }
            projectFiles.add(file);
        }
        LocalScriptBuilder builder = new LocalScriptBuilder();
        for (Map.Entry entry : byProject.entrySet()) {
            builder.build((IProject)entry.getKey(), new ArrayList<IFile>((Collection)entry.getValue()), monitor);
        }
    }
}

