/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model.impl;

import java.util.Collection;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.impl.ElementImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeImpl
extends ElementImpl
implements Type {
    protected EList<Member> members;
    protected static final TypeKind KIND_EDEFAULT = TypeKind.UNKNOWN;
    protected TypeKind kind = KIND_EDEFAULT;
    protected Type superType;
    protected Constructor constructor;
    protected EList<Type> traits;

    protected TypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypeInfoModelPackage.Literals.TYPE;
    }

    @Override
    public EList<Member> getMembers() {
        if (this.members == null) {
            this.members = new EObjectContainmentWithInverseEList(Member.class, (InternalEObject)this, 6, 9);
        }
        return this.members;
    }

    @Override
    public TypeKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(TypeKind newKind) {
        TypeKind oldKind = this.kind;
        TypeKind typeKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public Type getSuperType() {
        if (this.superType != null && ((EObject)this.superType).eIsProxy()) {
            InternalEObject oldSuperType = (InternalEObject)this.superType;
            this.superType = (Type)this.eResolveProxy(oldSuperType);
            if (this.superType != oldSuperType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldSuperType, (Object)this.superType));
            }
        }
        return this.superType;
    }

    public Type basicGetSuperType() {
        return this.superType;
    }

    @Override
    public void setSuperType(Type newSuperType) {
        Type oldSuperType = this.superType;
        this.superType = newSuperType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldSuperType, (Object)this.superType));
        }
    }

    @Override
    public Constructor getConstructor() {
        return this.constructor;
    }

    public NotificationChain basicSetConstructor(Constructor newConstructor, NotificationChain msgs) {
        Constructor oldConstructor = this.constructor;
        this.constructor = newConstructor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldConstructor, (Object)newConstructor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setConstructor(Constructor newConstructor) {
        if (newConstructor != this.constructor) {
            NotificationChain msgs = null;
            if (this.constructor != null) {
                msgs = ((InternalEObject)this.constructor).eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newConstructor != null) {
                msgs = ((InternalEObject)newConstructor).eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetConstructor(newConstructor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newConstructor, (Object)newConstructor));
        }
    }

    @Override
    public EList<Type> getTraits() {
        if (this.traits == null) {
            this.traits = new EObjectResolvingEList(Type.class, (InternalEObject)this, 10);
        }
        return this.traits;
    }

    @Override
    public boolean isProxy() {
        return this.eIsProxy();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getMembers()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getMembers()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return this.basicSetConstructor(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getMembers();
            }
            case 7: {
                return this.getKind();
            }
            case 8: {
                if (resolve) {
                    return this.getSuperType();
                }
                return this.basicGetSuperType();
            }
            case 9: {
                return this.getConstructor();
            }
            case 10: {
                return this.getTraits();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getMembers().clear();
                this.getMembers().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setKind((TypeKind)((Object)newValue));
                return;
            }
            case 8: {
                this.setSuperType((Type)newValue);
                return;
            }
            case 9: {
                this.setConstructor((Constructor)newValue);
                return;
            }
            case 10: {
                this.getTraits().clear();
                this.getTraits().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getMembers().clear();
                return;
            }
            case 7: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 8: {
                this.setSuperType(null);
                return;
            }
            case 9: {
                this.setConstructor(null);
                return;
            }
            case 10: {
                this.getTraits().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.members != null && !this.members.isEmpty();
            }
            case 7: {
                return this.kind != KIND_EDEFAULT;
            }
            case 8: {
                return this.superType != null;
            }
            case 9: {
                return this.constructor != null;
            }
            case 10: {
                return this.traits != null && !this.traits.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return String.valueOf(this.eClass().getName()) + "(eProxyURI=" + this.eProxyURI() + ')';
        }
        StringBuffer result = new StringBuffer(this.eClass().getName());
        result.append('<');
        result.append(this.name);
        result.append('>');
        return result.toString();
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return TypeUtil.resolve(proxy, (EObject)this);
    }
}

