/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.parser.JSDocValidatorFactory;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinference.ValueReferenceUtil;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.JSType2;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class TypeInfoValidator
implements IBuildParticipant {
    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        TypeInferencer2 inferencer = this.createTypeInferencer();
        inferencer.setModelElement((IModelElement)context.getSourceModule());
        Reporter reporter = JavaScriptValidations.createReporter(context);
        ValidationVisitor visitor = new ValidationVisitor(inferencer, reporter);
        inferencer.setVisitor(visitor);
        JSDocValidatorFactory.TypeChecker typeChecker = new JSDocValidatorFactory.TypeChecker(inferencer, (JSProblemReporter)reporter);
        visitor.setJSDocTypeChecker(typeChecker);
        inferencer.doInferencing(script);
        typeChecker.validate();
    }

    protected TypeInferencer2 createTypeInferencer() {
        return new TypeInferencer2();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallExpressionValidator
    implements ExpressionValidator {
        private final CallExpression node;
        private final IValueReference reference;
        private final ValidationVisitor visitor;
        private final IValueReference[] arguments;
        private final List<Method> methods;

        public CallExpressionValidator(CallExpression node, IValueReference reference, IValueReference[] arguments, List<Method> methods, ValidationVisitor visitor) {
            this.node = node;
            this.reference = reference;
            this.arguments = arguments;
            this.methods = methods;
            this.visitor = visitor;
        }

        @Override
        public void call() {
            this.visitor.validateCallExpression(this.node, this.reference, this.arguments, this.methods);
        }
    }

    private static interface ExpressionValidator {
        public void call();
    }

    private static class NewExpressionValidator
    implements ExpressionValidator {
        private final NewExpression node;
        private final IValueReference reference;
        final IValueCollection collection;
        private final ValidationVisitor validator;

        public NewExpressionValidator(NewExpression node, IValueReference reference, IValueCollection collection, ValidationVisitor validator) {
            this.node = node;
            this.reference = reference;
            this.collection = collection;
            this.validator = validator;
        }

        public void call() {
            this.validator.checkExpressionType(this.collection, (ASTNode)this.node.getObjectClass(), this.reference);
        }
    }

    private static class NotExistingIdentiferValidator
    implements ExpressionValidator {
        private final Expression identifer;
        private final IValueReference reference;
        private final ValidationVisitor visitor;

        public NotExistingIdentiferValidator(Expression identifer, IValueReference reference, ValidationVisitor visitor) {
            this.identifer = identifer;
            this.reference = reference;
            this.visitor = visitor;
        }

        public void call() {
            this.visitor.validate(this.identifer, this.reference);
        }
    }

    private static class PropertyExpressionHolder
    implements ExpressionValidator {
        private final PropertyExpression node;
        private final IValueReference reference;
        private final ValidationVisitor visitor;
        private final boolean exists;

        public PropertyExpressionHolder(PropertyExpression node, IValueReference reference, ValidationVisitor visitor, boolean exists) {
            this.node = node;
            this.reference = reference;
            this.visitor = visitor;
            this.exists = exists;
        }

        public void call() {
            this.visitor.validateProperty(this.node, this.reference, this.exists);
        }
    }

    private static class ReturnNode {
        final ReturnStatement node;
        final IValueReference returnValueReference;

        public ReturnNode(ReturnStatement node, IValueReference returnValueReference) {
            this.node = node;
            this.returnValueReference = returnValueReference;
        }
    }

    private static class StackedExpressionValidator
    implements ExpressionValidator {
        private final List<ExpressionValidator> stacked = new ArrayList<ExpressionValidator>();
        private final Reporter reporter;

        public StackedExpressionValidator(Reporter reporter) {
            this.reporter = reporter;
        }

        public void call() {
            for (ExpressionValidator validator : this.stacked) {
                int count = this.reporter.getProblemCount();
                validator.call();
                if (this.reporter.getProblemCount() != count) break;
            }
        }

        public void push(ExpressionValidator expressionValidator) {
            this.stacked.add(expressionValidator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestReturnStatement
    implements ExpressionValidator {
        private final List<ReturnNode> lst;
        private final Reporter reporter;
        private final IModelBuilder.IMethod jsMethod;

        public TestReturnStatement(IModelBuilder.IMethod jsMethod, List<ReturnNode> lst, Reporter reporter) {
            this.jsMethod = jsMethod;
            this.lst = lst;
            this.reporter = reporter;
        }

        @Override
        public void call() {
            JSType2 firstType = null;
            for (ReturnNode element : this.lst) {
                if (element.returnValueReference == null) continue;
                JSType methodType = this.jsMethod.getType();
                if (methodType != null && methodType.getKind() == TypeKind.RECORD) {
                    String failedPropertyTypeString = ValidationVisitor.testObjectPropertyType(element.returnValueReference, methodType);
                    if (failedPropertyTypeString != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchWithActualReturnType, (Object[])new String[]{this.jsMethod.getName(), TypeUtil.getName(methodType), failedPropertyTypeString}), element.node.sourceStart(), element.node.sourceEnd());
                    }
                    return;
                }
                JSType2 type = JSTypeSet.normalize(JavaScriptValidations.typeOf(element.returnValueReference));
                if (type != null && methodType != null && !JSTypeSet.normalize(methodType).isAssignableFrom(type)) {
                    ReturnStatement node = element.node;
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchWithActualReturnType, (Object[])new String[]{this.jsMethod.getName(), TypeUtil.getName(methodType), TypeUtil.getName(type)}), node.sourceStart(), node.sourceEnd());
                }
                if (firstType != null || type == null) continue;
                firstType = type;
            }
            if (firstType != null) {
                int i = 1;
                while (i < this.lst.size()) {
                    ReturnNode next = this.lst.get(i);
                    JSType2 nextType = JSTypeSet.normalize(JavaScriptValidations.typeOf(next.returnValueReference));
                    if (nextType != null && !nextType.isAssignableFrom(firstType) && !firstType.isAssignableFrom(nextType)) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.RETURN_INCONSISTENT, NLS.bind((String)ValidationMessages.ReturnTypeInconsistentWithPreviousReturn, (Object[])new String[]{TypeUtil.getName(nextType), TypeUtil.getName(firstType)}), next.node.sourceStart(), next.node.sourceEnd());
                    }
                    ++i;
                }
            }
        }
    }

    private static class TypeValidator
    implements ExpressionValidator {
        final ValidationVisitor validator;
        final IValueReference reference;
        final ASTNode node;

        public TypeValidator(ValidationVisitor validator, IValueReference reference, ASTNode node) {
            this.validator = validator;
            this.reference = reference;
            this.node = node;
        }

        public void call() {
            this.validator.checkExpressionType(null, this.node, this.reference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationVisitor
    extends TypeInferencerVisitor {
        private final Reporter reporter;
        private final List<ExpressionValidator> expressionValidators = new ArrayList<ExpressionValidator>();
        private final Map<ASTNode, VisitorMode> modes = new IdentityHashMap<ASTNode, VisitorMode>();
        private final Stack<ASTNode> visitStack = new Stack();
        private StackedExpressionValidator stackedExpressionValidator;
        private final Stack<FunctionScope> functionScopes = new Stack();

        public ValidationVisitor(ITypeInferenceContext context, Reporter reporter) {
            super(context);
            this.reporter = reporter;
            this.setProblemReporter((JSProblemReporter)reporter);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IValueReference visit(ASTNode node) {
            block4: {
                rootNode = this.visitStack.isEmpty();
                this.visitStack.push(node);
                try {
                    var4_3 = super.visit(node);
                    return var4_3;
                }
                finally {
                    if (!rootNode) break block4;
                    var8_4 = this.expressionValidators.toArray(new ExpressionValidator[this.expressionValidators.size()]);
                    var7_6 = var8_4.length;
                    var6_8 = 0;
                    ** while (var6_8 < var7_6)
                }
lbl-1000:
                // 1 sources

                {
                    call = var8_4[var6_8];
                    call.call();
                    ++var6_8;
                    continue;
                }
            }
            this.visitStack.pop();
            return var4_3;
        }

        private VisitorMode currentMode() {
            VisitorMode mode = this.modes.get(this.visitStack.peek());
            return mode != null ? mode : VisitorMode.NORMAL;
        }

        @Override
        public IValueReference visitNewExpression(NewExpression node) {
            boolean started = false;
            if (!(node.getObjectClass() instanceof FunctionStatement)) {
                started = this.startExpressionValidator();
            }
            try {
                IValueReference reference = super.visitNewExpression(node);
                this.pushExpressionValidator(new NewExpressionValidator(node, reference, this.peekContext(), this));
                IValueReference iValueReference = reference;
                return iValueReference;
            }
            finally {
                if (started) {
                    this.stopExpressionValidator();
                }
            }
        }

        public void enterFunctionScope() {
            this.functionScopes.push(new FunctionScope());
        }

        public void leaveFunctionScope(IModelBuilder.IMethod method) {
            FunctionScope scope = this.functionScopes.pop();
            if (method != null) {
                if (!scope.returnNodes.isEmpty()) {
                    this.pushExpressionValidator(new TestReturnStatement(method, scope.returnNodes, this.reporter));
                } else if (!scope.throwsException && method.getType() != null) {
                    ReferenceLocation location = method.getLocation();
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchNoReturnType, (Object[])new String[]{method.getName(), TypeUtil.getName(method.getType())}), location.getNameStart(), location.getNameEnd());
                }
            }
        }

        @Override
        public IValueReference visitFunctionStatement(FunctionStatement node) {
            this.validateHidesByFunction(node);
            this.enterFunctionScope();
            IValueReference reference = super.visitFunctionStatement(node);
            IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("PARAMETERS");
            this.leaveFunctionScope(method);
            return reference;
        }

        private void validateHidesByFunction(FunctionStatement node) {
            List args = node.getArguments();
            IValueCollection peekContext = this.peekContext();
            for (Argument argument : args) {
                IValueReference child = peekContext.getChild(argument.getArgumentName());
                if (!child.exists()) continue;
                if (child.getKind() == ReferenceKind.PROPERTY) {
                    Property property = (Property)child.getAttribute("ELEMENT");
                    if (property.isHideAllowed()) continue;
                    if (property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesPropertyOfType, (Object[])new String[]{argument.getArgumentName(), property.getDeclaringType().getName()}), argument.sourceStart(), argument.sourceEnd());
                        continue;
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesProperty, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                if (Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) continue;
                if (child.getKind() == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.ParameterHidesFunction, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesVariable, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
            }
            if (node.isDeclaration()) {
                IValueReference child;
                IValueCollection parentScope = ValidationVisitor.getParentScope(peekContext);
                if (parentScope == null) {
                    child = peekContext.getChild(node.getName().getName());
                    if (this.getSource().equals(child.getLocation().getSource())) {
                        return;
                    }
                } else {
                    child = parentScope.getChild(node.getName().getName());
                }
                if (child.exists()) {
                    if (child.getKind() == ReferenceKind.PROPERTY) {
                        Property property = (Property)child.getAttribute("ELEMENT");
                        if (!property.isHideAllowed()) {
                            if (property.getDeclaringType() != null) {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesPropertyOfType, (Object[])new String[]{node.getName().getName(), property.getDeclaringType().getName()}), node.getName().sourceStart(), node.getName().sourceEnd());
                            } else {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesProperty, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                            }
                        }
                    } else if (!Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) {
                        if (child.getKind() == ReferenceKind.FUNCTION) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.FunctionHidesFunction, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesVariable, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        }
                    }
                }
            }
        }

        @Override
        public IValueReference visitReturnStatement(ReturnStatement node) {
            IValueReference returnValueReference = super.visitReturnStatement(node);
            if ((returnValueReference != null || node.getValue() instanceof NullExpression) && !this.functionScopes.isEmpty()) {
                FunctionScope scope = this.functionScopes.peek();
                scope.returnNodes.add(new ReturnNode(node, returnValueReference));
            }
            return returnValueReference;
        }

        @Override
        public IValueReference visitThrowStatement(ThrowStatement node) {
            if (!this.functionScopes.isEmpty()) {
                FunctionScope scope = this.functionScopes.peek();
                scope.throwsException = true;
            }
            return super.visitThrowStatement(node);
        }

        @Override
        public IValueReference visitCallExpression(CallExpression node) {
            Expression expression = node.getExpression();
            this.modes.put((ASTNode)expression, VisitorMode.CALL);
            boolean started = this.startExpressionValidator();
            try {
                IValueReference reference = this.visit((ASTNode)expression);
                this.modes.remove(expression);
                if (reference == null) {
                    return null;
                }
                List callArgs = node.getArguments();
                IValueReference[] arguments = new IValueReference[callArgs.size()];
                List<Method> methods = JavaScriptValidations.extractElements(reference, Method.class);
                this.pushExpressionValidator(new CallExpressionValidator(node, reference, arguments, methods, this));
                if (started) {
                    this.stopExpressionValidator();
                    started = false;
                }
                int i = 0;
                int size = callArgs.size();
                while (i < size) {
                    arguments[i] = this.visit((ASTNode)callArgs.get(i));
                    ++i;
                }
                IValueReference iValueReference = reference.getChild("()");
                return iValueReference;
            }
            finally {
                if (started) {
                    this.stopExpressionValidator();
                }
            }
        }

        private void pushExpressionValidator(ExpressionValidator expressionValidator) {
            if (this.stackedExpressionValidator != null) {
                this.stackedExpressionValidator.push(expressionValidator);
            } else {
                this.expressionValidators.add(expressionValidator);
            }
        }

        private void stopExpressionValidator() {
            if (this.stackedExpressionValidator != null) {
                this.expressionValidators.add(this.stackedExpressionValidator);
                this.stackedExpressionValidator = null;
            }
        }

        private boolean startExpressionValidator() {
            if (this.stackedExpressionValidator == null) {
                this.stackedExpressionValidator = new StackedExpressionValidator(this.reporter);
                return true;
            }
            return false;
        }

        protected void validateCallExpression(CallExpression node, IValueReference reference, IValueReference[] arguments, List<Method> methods) {
            Expression expression = node.getExpression();
            Expression methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
            if (methods == null || methods.size() == 0) {
                methods = JavaScriptValidations.extractElements(reference, Method.class);
            }
            if (methods != null) {
                JSType type;
                List callArgs = node.getArguments();
                Method method = JavaScriptValidations.selectMethod(methods, arguments);
                if (method == null) {
                    JSType type2 = JavaScriptValidations.typeOf(reference.getParent());
                    if (type2 != null && type2.getKind() == TypeKind.JAVA) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_JAVA_PARAMETERS, NLS.bind((String)ValidationMessages.MethodNotSelected, (Object[])new String[]{reference.getName(), type2.getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                    return;
                }
                if (!this.validateParameterCount(method, callArgs)) {
                    this.reportMethodParameterError((ASTNode)methodNode, arguments, method);
                    return;
                }
                if (method.isDeprecated()) {
                    this.reportDeprecatedMethod((ASTNode)methodNode, reference, method);
                }
                if (JavaScriptValidations.isStatic(reference.getParent()) && !method.isStatic()) {
                    type = JavaScriptValidations.typeOf(reference.getParent());
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INSTANCE_METHOD, NLS.bind((String)ValidationMessages.StaticReferenceToNoneStaticMethod, (Object)reference.getName(), (Object)TypeUtil.getName(type)), methodNode.sourceStart(), methodNode.sourceEnd());
                } else if (reference.getParent() != null && !JavaScriptValidations.isStatic(reference.getParent()) && method.isStatic()) {
                    type = JavaScriptValidations.typeOf(reference.getParent());
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.STATIC_METHOD, NLS.bind((String)ValidationMessages.ReferenceToStaticMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                }
                EList<Parameter> parameters = method.getParameters();
                if (!this.validateParameters(parameters, arguments)) {
                    Identifier identifier;
                    String name = method.getName();
                    if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                        name = identifier.getName();
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArgTypes(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
                }
            } else {
                Object attribute = reference.getAttribute("PARAMETERS", true);
                if (attribute instanceof JSMethod) {
                    List<IModelBuilder.IParameter> parameters;
                    JSMethod method = (JSMethod)attribute;
                    if (method.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                    if (this.testVisibility(expression, reference, method)) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PRIVATE_FUNCTION, NLS.bind((String)ValidationMessages.PrivateFunction, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                    if (!this.validateParameters(parameters = method.getParameters(), arguments)) {
                        Identifier identifier;
                        String name = method.getName();
                        if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                            name = identifier.getName();
                        }
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArgTypes(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else if (!this.isArrayLookup((ASTNode)expression) && !this.isUntypedParameter(reference)) {
                    JSType type = JavaScriptValidations.typeOf(reference.getParent());
                    if (type != null) {
                        if (type.getKind() == TypeKind.JAVA) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        } else if (JavaScriptValidations.isStatic(reference.getParent()) && this.hasInstanceMethod(type, reference.getName())) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INSTANCE_METHOD, NLS.bind((String)ValidationMessages.StaticReferenceToNoneStaticMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        } else if (!reference.exists()) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodInScript, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        }
                    } else {
                        JSType referenceType = JavaScriptValidations.typeOf(reference);
                        if (referenceType instanceof TypeRef) {
                            Type t = ((TypeRef)referenceType).getTarget();
                            while (t != null) {
                                if (t.getName().equals("Function")) {
                                    return;
                                }
                                t = t.getSuperType();
                            }
                        }
                        if (expression instanceof NewExpression) {
                            if (reference.getKind() == ReferenceKind.TYPE) {
                                return;
                            }
                            JSType newType = JavaScriptValidations.typeOf(reference);
                            if (newType != null) {
                                return;
                            }
                        }
                        IValueReference parent = reference;
                        while (parent != null) {
                            if (parent.getName() == "[]") {
                                return;
                            }
                            parent = parent.getParent();
                        }
                        if (expression instanceof NewExpression) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNKNOWN_TYPE, NLS.bind((String)ValidationMessages.UnknownType, (Object)((NewExpression)expression).getObjectClass().toSourceString("")), methodNode.sourceStart(), methodNode.sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodInScript, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        }
                    }
                }
            }
        }

        private boolean isUntypedParameter(IValueReference reference) {
            return reference.getKind() == ReferenceKind.ARGUMENT && reference.getDeclaredType() == null;
        }

        private boolean isThisCall(Expression expression) {
            return expression instanceof PropertyExpression && ((PropertyExpression)expression).getObject() instanceof ThisExpression && ((PropertyExpression)expression).getProperty() instanceof Identifier;
        }

        private boolean hasInstanceMethod(JSType type, String name) {
            return ElementValue.findMember(type, name, MemberPredicate.NON_STATIC) != null;
        }

        private boolean isArrayLookup(ASTNode expression) {
            ASTNode walker = expression;
            while (walker != null) {
                if (walker instanceof GetArrayItemExpression) {
                    return true;
                }
                if (walker instanceof PropertyExpression && ((PropertyExpression)walker).getObject() instanceof GetArrayItemExpression) {
                    return true;
                }
                if (walker instanceof JSNode) {
                    walker = ((JSNode)walker).getParent();
                    continue;
                }
                return false;
            }
            return false;
        }

        private void reportDeprecatedMethod(ASTNode methodNode, IValueReference reference, Method method) {
            if (method.getDeclaringType() != null) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedMethod, (Object)reference.getName(), (Object)method.getDeclaringType().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedTopLevelMethod, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private void reportMethodParameterError(ASTNode methodNode, IValueReference[] arguments, Method method) {
            if (method.getDeclaringType() != null) {
                JavaScriptProblems problemId = JavaScriptProblems.WRONG_PARAMETERS;
                if (method.getDeclaringType().getKind() == TypeKind.JAVA) {
                    problemId = JavaScriptProblems.WRONG_JAVA_PARAMETERS;
                }
                this.reporter.reportProblem((IProblemIdentifier)problemId, NLS.bind((String)ValidationMessages.MethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), method.getDeclaringType().getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)ValidationMessages.TopLevelMethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private boolean validateParameters(List<IModelBuilder.IParameter> parameters, IValueReference[] arguments) {
            int i;
            if (!(arguments.length <= parameters.size() || parameters.size() > 0 && parameters.get(parameters.size() - 1).isVarargs())) {
                return false;
            }
            int testTypesSize = parameters.size();
            if (parameters.size() > arguments.length) {
                i = arguments.length;
                while (i < parameters.size()) {
                    IModelBuilder.IParameter p = parameters.get(i);
                    if (!p.isOptional() && !p.isVarargs()) {
                        return false;
                    }
                    ++i;
                }
                testTypesSize = arguments.length;
            } else if (parameters.size() < arguments.length) {
                testTypesSize = parameters.size() - 1;
            }
            i = 0;
            while (i < testTypesSize) {
                IValueReference argument = arguments[i];
                IModelBuilder.IParameter parameter = parameters.get(i);
                if (parameter.getType() instanceof RecordType && argument.getDeclaredType() instanceof RecordType) {
                    if (!this.testArgumentType(parameter.getType(), argument)) {
                        return false;
                    }
                } else if (parameter.getType() instanceof RecordType && argument != null) {
                    Set<String> argumentsChildren = argument.getDirectChildren();
                    for (Member member : ((RecordType)parameter.getType()).getMembers()) {
                        if (argumentsChildren.contains(member.getName())) {
                            if (member.getType() == null) continue;
                            IValueReference child = argument.getChild(member.getName());
                            if (this.testArgumentType(member.getType(), child)) continue;
                            return false;
                        }
                        if (member.getAttribute("OPTIONAL") != null) continue;
                        return false;
                    }
                } else {
                    JSType paramType = parameter.getType();
                    if (!this.testArgumentType(paramType, argument)) {
                        return false;
                    }
                }
                ++i;
            }
            if (parameters.size() < arguments.length) {
                int varargsParameter = parameters.size() - 1;
                JSType paramType = parameters.get(varargsParameter).getType();
                int i2 = varargsParameter;
                while (i2 < arguments.length) {
                    IValueReference argument = arguments[i2];
                    if (!this.testArgumentType(paramType, argument)) {
                        return false;
                    }
                    ++i2;
                }
            }
            return true;
        }

        private boolean validateParameters(EList<Parameter> parameters, IValueReference[] arguments) {
            int i;
            if (arguments.length > parameters.size() && (parameters.size() <= 0 || ((Parameter)parameters.get(parameters.size() - 1)).getKind() != ParameterKind.VARARGS)) {
                return false;
            }
            int testTypesSize = parameters.size();
            if (parameters.size() > arguments.length) {
                i = arguments.length;
                while (i < parameters.size()) {
                    ParameterKind pkind = ((Parameter)parameters.get(i)).getKind();
                    if (pkind != ParameterKind.OPTIONAL && pkind != ParameterKind.VARARGS) {
                        return false;
                    }
                    ++i;
                }
                testTypesSize = arguments.length;
            } else if (parameters.size() < arguments.length) {
                testTypesSize = parameters.size() - 1;
            }
            i = 0;
            while (i < testTypesSize) {
                IValueReference argument = arguments[i];
                Parameter parameter = (Parameter)parameters.get(i);
                if (parameter.getType() instanceof RecordType && argument != null) {
                    Set<String> argumentsChildren = argument.getDirectChildren();
                    for (Member member : ((RecordType)parameter.getType()).getMembers()) {
                        if (argumentsChildren.contains(member.getName())) {
                            if (member.getType() == null) continue;
                            IValueReference child = argument.getChild(member.getName());
                            if (this.testArgumentType(member.getType(), child)) continue;
                            return false;
                        }
                        if (member.getAttribute("OPTIONAL") != null) continue;
                        return false;
                    }
                } else {
                    JSType paramType = parameter.getType();
                    if (!this.testArgumentType(paramType, argument)) {
                        return false;
                    }
                }
                ++i;
            }
            if (parameters.size() < arguments.length) {
                int varargsParameter = parameters.size() - 1;
                JSType paramType = ((Parameter)parameters.get(varargsParameter)).getType();
                int i2 = varargsParameter;
                while (i2 < arguments.length) {
                    IValueReference argument = arguments[i2];
                    if (!this.testArgumentType(paramType, argument)) {
                        return false;
                    }
                    ++i2;
                }
            }
            return true;
        }

        private boolean testArgumentType(JSType paramType, IValueReference argument) {
            if (argument != null && paramType != null) {
                if (paramType.getKind() == TypeKind.RECORD) {
                    return ValidationVisitor.testObjectPropertyType(argument, paramType) == null;
                }
                JSType argumentType = argument.getDeclaredType();
                if (argumentType == null && !argument.getTypes().isEmpty()) {
                    argumentType = argument.getTypes().getFirst();
                }
                if (argumentType != null) {
                    return JSTypeSet.normalize(this.context.resolveTypeRef(paramType)).isAssignableFrom(JSTypeSet.normalize(this.context.resolveTypeRef(argumentType)));
                }
            }
            return true;
        }

        private static String testObjectPropertyType(IValueReference reference, JSType type) {
            Type realType;
            if (type.getKind() == TypeKind.RECORD && (realType = TypeUtil.extractType(type)) != null) {
                EList<Member> members = realType.getMembers();
                for (Member member : members) {
                    IValueReference child = reference.getChild(member.getName());
                    JSType referenceType = JavaScriptValidations.typeOf(child);
                    if (child.exists() && referenceType != null && member.getType() != null && JSTypeSet.normalize(member.getType()).isAssignableFrom(JSTypeSet.normalize(referenceType))) continue;
                    Set<String> children = reference.getDirectChildren();
                    if (children.size() == 0) {
                        return "{}";
                    }
                    StringBuilder typeString = new StringBuilder();
                    typeString.append('{');
                    for (String childName : children) {
                        typeString.append(childName);
                        typeString.append(':');
                        JSType childType = JavaScriptValidations.typeOf(reference.getChild(childName));
                        String typeName = TypeUtil.getName(childType);
                        typeString.append(typeName == null ? "Object" : typeName);
                        typeString.append(',');
                    }
                    typeString.setLength(typeString.length() - 1);
                    typeString.append('}');
                    return typeString.toString();
                }
            }
            return null;
        }

        private String describeParamTypes(EList<Parameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getKind() == ParameterKind.OPTIONAL) {
                    sb.append('[');
                }
                if (parameter.getType() != null) {
                    sb.append(parameter.getType().getName());
                } else {
                    sb.append('?');
                }
                if (parameter.getKind() == ParameterKind.OPTIONAL) {
                    sb.append(']');
                }
                if (parameter.getKind() != ParameterKind.VARARGS) continue;
                sb.append("...");
            }
            return sb.toString();
        }

        private String describeParamTypes(List<IModelBuilder.IParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (IModelBuilder.IParameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getType() instanceof RecordType) {
                    sb.append('{');
                    for (Member member : ((RecordType)parameter.getType()).getMembers()) {
                        if (sb.length() > 1) {
                            sb.append(", ");
                        }
                        if (member.getAttribute("OPTIONAL") != null) {
                            sb.append('[');
                        }
                        sb.append(member.getName());
                        if (member.getType() != null) {
                            sb.append(':');
                            sb.append(member.getType().getName());
                        }
                        if (member.getAttribute("OPTIONAL") == null) continue;
                        sb.append(']');
                    }
                    sb.append('}');
                    continue;
                }
                if (parameter.getType() != null) {
                    if (parameter.isOptional()) {
                        sb.append("[");
                    }
                    if (parameter.isVarargs()) {
                        sb.append("...");
                    }
                    sb.append(parameter.getType().getName());
                    if (!parameter.isOptional()) continue;
                    sb.append("]");
                    continue;
                }
                sb.append('?');
            }
            return sb.toString();
        }

        private String describeArgTypes(IValueReference[] arguments) {
            return this.describeArgTypes(arguments, Collections.<IModelBuilder.IParameter>emptyList());
        }

        private String describeArgTypes(IValueReference[] arguments, List<IModelBuilder.IParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < arguments.length) {
                IModelBuilder.IParameter parameter;
                IValueReference argument = arguments[i];
                IModelBuilder.IParameter iParameter = parameter = parameters.size() > i ? parameters.get(i) : null;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (argument == null) {
                    sb.append("null");
                } else if (parameter != null && parameter.getType() instanceof RecordType) {
                    Set<String> directChildren = argument.getDirectChildren();
                    sb.append('{');
                    for (String childName : directChildren) {
                        if (sb.length() > 1) {
                            sb.append(", ");
                        }
                        sb.append(childName);
                        JSType type = JavaScriptValidations.typeOf(argument.getChild(childName));
                        if (type == null) continue;
                        sb.append(':');
                        sb.append(type.getName());
                    }
                    sb.append('}');
                } else if (parameter != null && parameter.getType() != null && parameter.getType().getKind() == TypeKind.RECORD) {
                    sb.append(ValidationVisitor.testObjectPropertyType(argument, parameter.getType()));
                } else if (argument.getDeclaredType() != null) {
                    sb.append(argument.getDeclaredType().getName());
                } else {
                    JSTypeSet types = argument.getTypes();
                    if (types.size() == 1) {
                        sb.append(types.getFirst().getName());
                    } else {
                        sb.append('?');
                    }
                }
                ++i;
            }
            return sb.toString();
        }

        private String describeArgTypes(IValueReference[] arguments, EList<Parameter> parameters) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < arguments.length) {
                Parameter parameter;
                IValueReference argument = arguments[i];
                Parameter parameter2 = parameter = parameters.size() > i ? (Parameter)parameters.get(i) : null;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (argument == null) {
                    sb.append("null");
                } else if (parameter != null && parameter.getType() instanceof RecordType) {
                    Set<String> directChildren = argument.getDirectChildren();
                    sb.append('{');
                    for (String childName : directChildren) {
                        if (sb.length() > 1) {
                            sb.append(", ");
                        }
                        sb.append(childName);
                        JSType type = JavaScriptValidations.typeOf(argument.getChild(childName));
                        if (type == null) continue;
                        sb.append(':');
                        sb.append(type.getName());
                    }
                    sb.append('}');
                } else if (parameter != null && parameter.getType() != null && parameter.getType().getKind() == TypeKind.RECORD) {
                    sb.append(ValidationVisitor.testObjectPropertyType(argument, parameter.getType()));
                } else if (argument.getDeclaredType() != null) {
                    sb.append(argument.getDeclaredType().getName());
                } else {
                    JSTypeSet types = argument.getTypes();
                    if (types.size() == 1) {
                        sb.append(types.getFirst().getName());
                    } else {
                        sb.append('?');
                    }
                }
                ++i;
            }
            return sb.toString();
        }

        private <E extends Member> E extractElement(IValueReference reference, Class<E> elementType, Boolean staticModifierValue) {
            List<Member> elements = JavaScriptValidations.extractElements(reference, elementType);
            if (staticModifierValue != null && elements != null && elements.size() > 1) {
                for (Member e : elements) {
                    if (e.isStatic() != staticModifierValue.booleanValue()) continue;
                    return (E)e;
                }
            }
            return (E)(elements != null ? elements.get(0) : null);
        }

        private boolean validateParameterCount(Method method, List<ASTNode> callArgs) {
            EList<Parameter> params = method.getParameters();
            if (params.size() == callArgs.size()) {
                return true;
            }
            if (params.size() < callArgs.size() && !params.isEmpty() && ((Parameter)params.get(params.size() - 1)).getKind() == ParameterKind.VARARGS) {
                return true;
            }
            return params.size() > callArgs.size() && (((Parameter)params.get(callArgs.size())).getKind() == ParameterKind.OPTIONAL || ((Parameter)params.get(callArgs.size())).getKind() == ParameterKind.VARARGS);
        }

        @Override
        public IValueReference visitPropertyExpression(PropertyExpression node) {
            boolean started = this.startExpressionValidator();
            try {
                IValueReference result = super.visitPropertyExpression(node);
                if (result != null) {
                    if (this.currentMode() != VisitorMode.CALL) {
                        this.pushExpressionValidator(new PropertyExpressionHolder(node, result, this, result.exists()));
                    }
                    IValueReference iValueReference = result;
                    return iValueReference;
                }
                return null;
            }
            finally {
                if (started) {
                    this.stopExpressionValidator();
                }
            }
        }

        @Override
        protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
            if (left != null) {
                if (left.getAttribute("CONSTANT") != null) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.REASSIGNMENT_OF_CONSTANT, ValidationMessages.ReassignmentOfConstant, node.sourceStart(), node.sourceEnd());
                } else {
                    this.validate(node.getLeftExpression(), left);
                }
            }
            return super.visitAssign(left, right, node);
        }

        protected boolean validate(Expression expr, IValueReference reference) {
            IValueReference parent = reference.getParent();
            if (parent == null) {
                if (expr instanceof Identifier && !reference.exists()) {
                    if (expr.getParent() instanceof BinaryOperation && ((BinaryOperation)expr.getParent()).getOperation() == 21 && ((BinaryOperation)expr.getParent()).getRightExpression() == expr) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNKNOWN_TYPE, NLS.bind((String)ValidationMessages.UnknownType, (Object)reference.getName()), expr.sourceStart(), expr.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDECLARED_VARIABLE, NLS.bind((String)ValidationMessages.UndeclaredVariable, (Object)reference.getName()), expr.sourceStart(), expr.sourceEnd());
                    }
                    return false;
                }
                this.testPrivate(expr, reference);
            } else if (expr instanceof PropertyExpression && this.validate(((PropertyExpression)expr).getObject(), parent)) {
                JSType type = JavaScriptValidations.typeOf(parent);
                if (type != null && type.getKind() == TypeKind.JAVA && !reference.exists()) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)reference.getName(), (Object)type.getName()), expr.sourceStart(), expr.sourceEnd());
                    return false;
                }
            } else if (expr instanceof GetArrayItemExpression && !this.validate(((GetArrayItemExpression)expr).getArray(), parent)) {
                return false;
            }
            return true;
        }

        public void testPrivate(Expression expr, IValueReference reference) {
            if (reference.getAttribute("PRIVATE") == Boolean.TRUE) {
                Object attribute = reference.getAttribute("VARIABLE");
                if (attribute instanceof IModelBuilder.IVariable) {
                    IModelBuilder.IVariable variable = (IModelBuilder.IVariable)attribute;
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PRIVATE_VARIABLE, NLS.bind((String)ValidationMessages.PrivateVariable, (Object)variable.getName()), expr.sourceStart(), expr.sourceEnd());
                } else {
                    attribute = reference.getAttribute("PARAMETERS");
                    if (attribute instanceof IModelBuilder.IMethod) {
                        IModelBuilder.IMethod method = (IModelBuilder.IMethod)attribute;
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PRIVATE_FUNCTION, NLS.bind((String)ValidationMessages.PrivateFunction, (Object)method.getName()), expr.sourceStart(), expr.sourceEnd());
                    }
                }
            }
        }

        @Override
        public IValueReference visitIdentifier(Identifier node) {
            IValueReference result = super.visitIdentifier(node);
            Property property = this.extractElement(result, Property.class, null);
            if (property != null && property.isDeprecated()) {
                this.reportDeprecatedProperty(property, null, (ASTNode)node);
            } else if (!(result.exists() || node.getParent() instanceof CallExpression && ((CallExpression)node.getParent()).getExpression() == node)) {
                this.pushExpressionValidator(new NotExistingIdentiferValidator((Expression)node, result, this));
            } else {
                this.testPrivate((Expression)node, result);
            }
            return result;
        }

        private static IValueCollection getParentScope(IValueCollection collection) {
            IValueCollection c = collection;
            while (c != null && !c.isScope()) {
                c = c.getParent();
            }
            if (c != null && (c = c.getParent()) != null) {
                return c;
            }
            return null;
        }

        @Override
        protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
            this.validateHidesByVariable(context, declaration);
            return super.createVariable(context, declaration);
        }

        private void validateHidesByVariable(IValueCollection context, VariableDeclaration declaration) {
            IValueReference child;
            Identifier identifier = declaration.getIdentifier();
            IValueCollection parentScope = ValidationVisitor.getParentScope(context);
            if (parentScope == null) {
                child = context.getChild(identifier.getName());
                if (this.getSource().equals(child.getLocation().getSource())) {
                    return;
                }
            } else {
                child = parentScope.getChild(identifier.getName());
            }
            if (child.exists()) {
                if (child.getKind() == ReferenceKind.ARGUMENT) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PARAMETER, NLS.bind((String)ValidationMessages.VariableHidesParameter, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (child.getKind() == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.VariableHidesFunction, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (child.getKind() == ReferenceKind.PROPERTY) {
                    Property property = (Property)child.getAttribute("ELEMENT");
                    if (property != null && property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesPropertyOfType, (Object)declaration.getVariableName(), (Object)property.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesProperty, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else if (child.getKind() == ReferenceKind.METHOD) {
                    Method method = (Method)child.getAttribute("ELEMENT");
                    if (method != null && method.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethodOfType, (Object)declaration.getVariableName(), (Object)method.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethod, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DUPLICATE_VAR_DECLARATION, NLS.bind((String)ValidationMessages.VariableHidesVariable, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                }
            }
        }

        protected void validateProperty(PropertyExpression propertyExpression, IValueReference result, boolean exists) {
            Expression propName = propertyExpression.getProperty();
            Member member = this.extractElement(result, Member.class, JavaScriptValidations.isStatic(result.getParent()));
            if (member != null) {
                if (member.isDeprecated()) {
                    Property parentProperty = this.extractElement(result.getParent(), Property.class, null);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof Property) {
                            this.reportDeprecatedProperty((Property)member, parentProperty, (ASTNode)propName);
                        } else if (member instanceof Method) {
                            this.reportDeprecatedMethod((ASTNode)propName, result, (Method)member);
                        }
                    } else if (member instanceof Property) {
                        this.reportDeprecatedProperty((Property)member, member.getDeclaringType(), (ASTNode)propName);
                    } else if (member instanceof Method) {
                        this.reportDeprecatedMethod((ASTNode)propName, result, (Method)member);
                    }
                } else if (!member.isVisible()) {
                    Property parentProperty = this.extractElement(result.getParent(), Property.class, null);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof Property) {
                            this.reportHiddenProperty((Property)member, parentProperty, (ASTNode)propName);
                        }
                    } else if (member instanceof Property) {
                        this.reportHiddenProperty((Property)member, member.getDeclaringType(), (ASTNode)propName);
                    }
                } else if (JavaScriptValidations.isStatic(result.getParent()) && !member.isStatic()) {
                    JSType type = this.context.resolveTypeRef(JavaScriptValidations.typeOf(result.getParent()));
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INSTANCE_PROPERTY, NLS.bind((String)ValidationMessages.StaticReferenceToNoneStaticProperty, (Object)result.getName(), (Object)TypeUtil.getName(type)), propName.sourceStart(), propName.sourceEnd());
                } else if (!JavaScriptValidations.isStatic(result.getParent()) && member.isStatic()) {
                    JSType type = JavaScriptValidations.typeOf(result.getParent());
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.STATIC_PROPERTY, NLS.bind((String)ValidationMessages.ReferenceToStaticProperty, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
                }
            } else if (!(exists || result.exists() || this.isArrayLookup((ASTNode)propertyExpression))) {
                JSType type = this.context.resolveTypeRef(JavaScriptValidations.typeOf(result.getParent()));
                if (type != null && type.getKind() == TypeKind.JAVA) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
                } else if (type != null && this.shouldBeDefined(propertyExpression) && (type.getKind() == TypeKind.JAVASCRIPT || type.getKind() == TypeKind.PREDEFINED || type.getKind() == TypeKind.EXTERNAL_JS)) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScriptType, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
                } else if (this.shouldBeDefined(propertyExpression)) {
                    String parentPath = PropertyExpressionUtils.getPath((Expression)propertyExpression.getObject());
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScript, (Object)result.getName(), (Object)(parentPath != null ? parentPath : "javascript")), propName.sourceStart(), propName.sourceEnd());
                }
            } else {
                IModelBuilder.IVariable variable = (IModelBuilder.IVariable)result.getAttribute("VARIABLE");
                if (variable != null) {
                    if (variable.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_VARIABLE, NLS.bind((String)ValidationMessages.DeprecatedVariable, (Object)variable.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    if (this.testVisibility((Expression)propertyExpression, result, variable)) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PRIVATE_VARIABLE, NLS.bind((String)ValidationMessages.PrivateVariable, (Object)variable.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    return;
                }
                IModelBuilder.IMethod method = (IModelBuilder.IMethod)result.getAttribute("PARAMETERS");
                if (method != null) {
                    if (method.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)method.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    if (this.testVisibility((Expression)propertyExpression, result, method)) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PRIVATE_FUNCTION, NLS.bind((String)ValidationMessages.PrivateFunction, (Object)method.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    return;
                }
            }
        }

        public boolean testVisibility(Expression expression, IValueReference result, IModelBuilder.IMember method) {
            return (method.isPrivate() || method.isProtected() && result.getParent() != null && result.getParent().getAttribute("SUPER_SCOPE") == null) && (result.getParent() != null || result.getAttribute("PRIVATE") == Boolean.TRUE) && !this.isThisCall(expression);
        }

        private boolean shouldBeDefined(PropertyExpression propertyExpression) {
            BinaryOperation bo;
            if (propertyExpression.getParent() instanceof BinaryOperation && (bo = (BinaryOperation)propertyExpression.getParent()).getRightExpression() == propertyExpression) {
                return bo.getOperation() != 100 && bo.getOperation() != 101;
            }
            if (propertyExpression.getParent() instanceof VariableDeclaration) {
                return true;
            }
            if (propertyExpression.getParent() instanceof CallExpression) {
                return true;
            }
            return propertyExpression.getParent() instanceof PropertyExpression;
        }

        private void reportDeprecatedProperty(Property property, Element owner, ASTNode node) {
            String msg = owner instanceof Type ? NLS.bind((String)ValidationMessages.DeprecatedProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof Property ? NLS.bind((String)ValidationMessages.DeprecatedPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.DeprecatedPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private void reportHiddenProperty(Property property, Element owner, ASTNode node) {
            String msg = owner instanceof Type ? NLS.bind((String)ValidationMessages.HiddenProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof Property ? NLS.bind((String)ValidationMessages.HiddenPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.HiddenPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.HIDDEN_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        protected void checkExpressionType(IValueCollection collection, ASTNode node, IValueReference reference) {
            JSTypeSet types = reference.getTypes();
            if (types.size() > 0) {
                this.checkType(node, types.getFirst(), collection);
            } else if (reference.getDeclaredType() == null) {
                String lazyName = ValueReferenceUtil.getLazyName(reference);
                if (lazyName != null) {
                    this.reportUnknownType(node, lazyName);
                }
            } else {
                this.checkType(node, reference.getDeclaredType(), collection);
            }
        }

        @Override
        public void setType(ASTNode node, IValueReference value, JSType type, boolean lazy) {
            super.setType(node, value, type, lazy);
            if (type != null) {
                if (lazy) {
                    this.pushExpressionValidator(new TypeValidator(this, value, node));
                } else {
                    this.checkType(node, type, null);
                }
            }
        }

        public void checkType(ASTNode node, JSType type, IValueCollection collection) {
            if (type != null) {
                Assert.isTrue(((type = this.context.resolveTypeRef(type)).getKind() != TypeKind.UNRESOLVED ? 1 : 0) != 0);
                if (type.getKind() == TypeKind.UNKNOWN) {
                    if (!(type instanceof TypeRef) || collection == null || !collection.getChild(((TypeRef)type).getName()).exists()) {
                        this.reportUnknownType(node, TypeUtil.getName(type));
                    }
                } else if (type instanceof ArrayType) {
                    this.checkType(node, ((ArrayType)type).getItemType(), collection);
                } else if (type instanceof MapType) {
                    this.checkType(node, ((MapType)type).getValueType(), collection);
                    this.checkType(node, ((MapType)type).getKeyType(), collection);
                } else if (type instanceof UnionType) {
                    for (JSType part : ((UnionType)type).getTargets()) {
                        this.checkType(node, part, collection);
                    }
                } else if (type instanceof FunctionType) {
                    FunctionType funcType = (FunctionType)type;
                    if (funcType.getReturnType() != null) {
                        this.checkType(node, funcType.getReturnType(), collection);
                    }
                    for (Parameter parameter : funcType.getParameters()) {
                        this.checkType(node, parameter.getType(), collection);
                    }
                } else {
                    Type t = TypeUtil.extractType(type);
                    if (t != null && t.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)TypeUtil.getName(type)), node.sourceStart(), node.sourceEnd());
                    }
                }
            } else {
                this.reportUnknownType(node, TypeUtil.getName(type));
            }
        }

        public void reportUnknownType(ASTNode node, String name) {
            this.reportUnknownType(JavaScriptProblems.UNKNOWN_TYPE, node, name);
        }

        public void reportUnknownType(IProblemIdentifier identifier, ASTNode node, String name) {
            this.reporter.reportProblem(identifier, NLS.bind((String)ValidationMessages.UnknownType, (Object)name), node.sourceStart(), node.sourceEnd());
        }

        public static class FunctionScope {
            final List<ReturnNode> returnNodes = new ArrayList<ReturnNode>();
            boolean throwsException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VisitorMode {
        NORMAL,
        CALL;

    }
}

