/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.corext;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.ISourceRange;

public class SourceRange
implements ISourceRange {
    private final int fOffset;
    private final int fLength;

    public SourceRange(int offset, int length) {
        this.fLength = length;
        this.fOffset = offset;
    }

    public SourceRange(ASTNode node) {
        this(node.sourceStart(), node.sourceEnd() - node.sourceStart());
    }

    public SourceRange(IProblem problem) {
        this(problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart() + 1);
    }

    public SourceRange(ISourceRange range) {
        this(range.getOffset(), range.getLength());
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getEndExclusive() {
        return this.getOffset() + this.getLength();
    }

    public int getEndInclusive() {
        return this.getEndExclusive() - 1;
    }

    public String toString() {
        return "<offset: " + this.fOffset + " length: " + this.fLength + "/>";
    }

    public static ISourceRange[] reverseSortByOffset(ISourceRange[] ranges) {
        Comparator<ISourceRange> comparator = new Comparator<ISourceRange>(){

            @Override
            public int compare(ISourceRange o1, ISourceRange o2) {
                return o2.getOffset() - o1.getOffset();
            }
        };
        Arrays.sort(ranges, comparator);
        return ranges;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISourceRange)) {
            return false;
        }
        return ((ISourceRange)obj).getOffset() == this.fOffset && ((ISourceRange)obj).getLength() == this.fLength;
    }

    public int hashCode() {
        return this.fLength ^ this.fOffset;
    }

    public boolean covers(ASTNode node) {
        return this.covers(new SourceRange(node));
    }

    public boolean covers(SourceRange range) {
        return this.getOffset() <= range.getOffset() && this.getEndInclusive() >= range.getEndInclusive();
    }

    public static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }
}

