/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parser.visitors;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionList;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.python.parser.ast.PythonImportFromStatement;
import org.eclipse.dltk.python.parser.ast.PythonImportStatement;
import org.eclipse.dltk.python.parser.ast.expressions.Assignment;
import org.eclipse.dltk.python.parser.ast.expressions.ExtendedVariableReference;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportAsExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonLambdaExpression;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonSourceElementRequestor
extends SourceElementRequestVisitor {
    private static String ANONYMOUS_LAMBDA_FORM_MARKER = "<anonymous>";
    private List fNotAddedFields = new ArrayList();
    private String lastLambdaFormName = ANONYMOUS_LAMBDA_FORM_MARKER;
    private Map fTypeVariables = new HashMap();

    public PythonSourceElementRequestor(ISourceElementRequestor requestor) {
        super((IElementRequestor)requestor);
    }

    protected String makeLanguageDependentValue(Expression value) {
        String outValue = "";
        if (value instanceof ExtendedVariableReference) {
            StringWriter stringWriter = new StringWriter();
            CorePrinter printer = new CorePrinter((Writer)stringWriter);
            value.printNode(printer);
            printer.flush();
            return stringWriter.getBuffer().toString();
        }
        return outValue;
    }

    private void onVisitLambdaAssignnment(String ref, PythonLambdaExpression lambdaExpression) {
        List args = lambdaExpression.getArguments();
        String[] parameters = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameters[a] = arg.getName();
            ++a;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameters;
        mi.name = ref;
        mi.modifiers = 0;
        mi.nameSourceStart = lambdaExpression.sourceStart();
        mi.nameSourceEnd = lambdaExpression.sourceEnd() - 1;
        mi.declarationStart = lambdaExpression.sourceStart();
        this.fRequestor.enterMethod(mi);
        this.fRequestor.exitMethod(lambdaExpression.sourceEnd());
    }

    private void onVisitStaticVariableAssignment(SimpleReference var, Statement val) {
        if (this.canAddVariables((ASTNode)this.fNodes.peek(), var.getName())) {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = var.getName();
            info.nameSourceEnd = var.sourceEnd() - 1;
            info.nameSourceStart = var.sourceStart();
            info.declarationStart = var.sourceStart();
            this.fRequestor.enterField(info);
            if (val != null) {
                this.fRequestor.exitField(val.sourceEnd() - 1);
            } else {
                this.fRequestor.exitField(var.sourceEnd() - 1);
            }
        }
    }

    private void onVisitInstanceVariableAssignment(ExtendedVariableReference extendedVariable, Statement right) {
        List varParts = extendedVariable.getExpressions();
        if (extendedVariable.isDot(0)) {
            Expression first = (Expression)varParts.get(0);
            Expression second = (Expression)varParts.get(1);
            if (first instanceof VariableReference && second instanceof VariableReference) {
                Argument firstArgument;
                String argumentName;
                String varName = ((VariableReference)first).getName();
                MethodDeclaration currentMethod = this.getCurrentMethod();
                List arguments = currentMethod.getArguments();
                if (arguments != null && arguments.size() > 0 && (argumentName = (firstArgument = (Argument)arguments.get(0)).getName()).equals(varName)) {
                    List decorators;
                    VariableReference var = (VariableReference)second;
                    int initialValueStart = 0;
                    int initialValueEnd = 0;
                    if (right != null) {
                        initialValueStart = right.sourceStart();
                        initialValueEnd = right.sourceEnd();
                    }
                    PositionInformation pos = new PositionInformation(var.sourceStart(), var.sourceEnd(), initialValueStart, initialValueEnd);
                    String initialString = this.makeValue((ASTNode)right);
                    ASTNode method = (ASTNode)this.fNodes.pop();
                    ASTNode toClass = (ASTNode)this.fNodes.peek();
                    this.fNodes.push(method);
                    if (toClass instanceof TypeDeclaration && ((decorators = ((MethodDeclaration)method).getDecorators()) == null || decorators != null && decorators.size() == 0)) {
                        TypeField field = new TypeField(var.getName(), initialString, pos, (Expression)extendedVariable, toClass, method);
                        this.fNotAddedFields.add(field);
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onVisitTestListAssignment(ExpressionList left, Statement right) {
        block2: {
            iter = left.getChilds().iterator();
            if (!(right instanceof ExpressionList)) ** GOTO lbl12
            exprs = (ExpressionList)right;
            j = exprs.getChilds().iterator();
            while (iter.hasNext() && j.hasNext()) {
                expr = (Expression)iter.next();
                this.processAssignment((Statement)expr, (Statement)((Expression)j.next()));
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                expr = (Expression)iter.next();
                this.processAssignment((Statement)expr, right);
lbl12:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
    }

    private void processAssignment(Statement left, Statement right) {
        if (left instanceof Assignment) {
            Assignment assignment = (Assignment)left;
            this.processAssignment(assignment.getLeft(), right);
            this.processAssignment(assignment.getRight(), right);
        } else if (left instanceof SimpleReference && right instanceof PythonLambdaExpression) {
            this.onVisitLambdaAssignnment(((SimpleReference)left).getName(), (PythonLambdaExpression)right);
        } else if (left instanceof VariableReference && !this.fInMethod) {
            this.onVisitStaticVariableAssignment((SimpleReference)((VariableReference)left), right);
        } else if (left instanceof ExtendedVariableReference && this.fInClass && this.fInMethod) {
            this.onVisitInstanceVariableAssignment((ExtendedVariableReference)left, right);
        } else if (left instanceof ExpressionList) {
            this.onVisitTestListAssignment((ExpressionList)left, right);
        }
    }

    public boolean visit(Expression expression) throws Exception {
        if (expression instanceof Assignment) {
            Assignment assignment = (Assignment)expression;
            Statement left = assignment.getLeft();
            Statement right = assignment.getRight();
            if (left == null) {
                return true;
            }
            this.processAssignment(left, right);
            return false;
        }
        if (expression instanceof ExtendedVariableReference) {
            ExtendedVariableReference ref = (ExtendedVariableReference)expression;
            int expressionCount = ref.getExpressionCount();
            int i = 0;
            while (i < expressionCount) {
                Expression e = ref.getExpression(i);
                if (ref.isCall(i) && e instanceof VariableReference) {
                    this.fRequestor.acceptMethodReference(((VariableReference)e).getName(), 0, e.sourceStart(), e.sourceEnd());
                } else if (e instanceof VariableReference) {
                    this.fRequestor.acceptFieldReference(((VariableReference)e).getName(), e.sourceStart());
                }
                ++i;
            }
        } else if (expression instanceof VariableReference) {
            this.fRequestor.acceptFieldReference(((VariableReference)expression).getName(), expression.sourceStart());
        }
        return true;
    }

    public boolean endvisit(Expression expression) throws Exception {
        return true;
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
        TypeField typeField;
        if (this.fNotAddedFields.size() >= 1 && (typeField = (TypeField)this.fNotAddedFields.get(0)) != null && typeField.getDeclaredIn().equals((Object)method)) {
            Iterator i = this.fNotAddedFields.iterator();
            while (i.hasNext()) {
                TypeField field = (TypeField)i.next();
                if (!this.canAddVariables(field.getToNode(), field.getName())) continue;
                PositionInformation pos = field.getPos();
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.modifiers = 128;
                info.name = field.getName();
                info.nameSourceEnd = pos.nameEnd - 1;
                info.nameSourceStart = pos.nameStart;
                info.declarationStart = pos.sourceStart;
                this.fRequestor.enterField(info);
                this.fRequestor.exitField(pos.sourceEnd);
            }
            this.fNotAddedFields.clear();
        }
    }

    public boolean visit(Statement statement) throws Exception {
        if (statement instanceof PythonImportStatement) {
            PythonImportStatement importStatement = (PythonImportStatement)statement;
            List exprs = importStatement.getImports();
            Iterator i = exprs.iterator();
            while (i.hasNext()) {
                PythonImportExpression importName;
                String name;
                Expression ex = (Expression)i.next();
                if (ex instanceof PythonImportAsExpression || !(ex instanceof PythonImportExpression) || (name = (importName = (PythonImportExpression)ex).getName()).indexOf(".") == -1) continue;
                String sname = name;
                while (sname.indexOf(".") != -1) {
                    sname = sname.substring(0, sname.lastIndexOf("."));
                }
            }
        } else {
            boolean cfr_ignored_0 = statement instanceof PythonImportFromStatement;
        }
        return true;
    }

    private boolean canAddVariables(ASTNode type, String name) {
        if (this.fTypeVariables.containsKey(type)) {
            List variables = (List)this.fTypeVariables.get(type);
            if (variables.contains(name)) {
                return false;
            }
            variables.add(name);
            return true;
        }
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(name);
        this.fTypeVariables.put(type, variables);
        return true;
    }

    public boolean endvisit(Statement s) throws Exception {
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
            ++a;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        ((ISourceElementRequestor)this.fRequestor).enterMethodRemoveSame(mi);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        return true;
    }

    private static class TypeField {
        private String fName;
        private String fInitValue;
        private PositionInformation fPos;
        private Expression fExpression;
        private ASTNode fToNode;
        private ASTNode declaredIn;

        TypeField(String name, String initValue, PositionInformation pos, Expression expression, ASTNode toNode, ASTNode declaredIn) {
            this.fName = name;
            this.fInitValue = initValue;
            this.fPos = pos;
            this.fExpression = expression;
            this.fToNode = toNode;
            this.declaredIn = declaredIn;
        }

        String getName() {
            return this.fName;
        }

        String getInitValue() {
            return this.fInitValue;
        }

        PositionInformation getPos() {
            return this.fPos;
        }

        Expression getExpression() {
            return this.fExpression;
        }

        ASTNode getToNode() {
            return this.fToNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeField) {
                TypeField second = (TypeField)obj;
                return second.fName.equals(this.fName) && second.fToNode.equals((Object)this.fToNode);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.fName;
        }

        public ASTNode getDeclaredIn() {
            return this.declaredIn;
        }
    }
}

