/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ruby.internal.ui.text.RubyWhitespaceDetector;
import org.eclipse.dltk.ruby.internal.ui.text.rules.BeginOfLineRule;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.TodoTagRule;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class RubyDocScanner
extends AbstractScriptScanner {
    private static final String[] fgTokenProperties = new String[]{"DLTK_doc", "DLTK_doc.topic", "DLTK_comment_task_tag"};

    public RubyDocScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token topic = this.getToken("DLTK_doc.topic");
        Token other = this.getToken("DLTK_doc");
        Token todo = this.getToken("DLTK_comment_task_tag");
        rules.add(new WhitespaceRule((IWhitespaceDetector)new RubyWhitespaceDetector()));
        rules.add(new BeginOfLineRule((IToken)topic, '='));
        rules.add(this.createTodoTagRule((IToken)todo));
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }

    private TodoTagRule createTodoTagRule(IToken token) {
        TodoTaskPreferencesOnPreferenceStore prefs = new TodoTaskPreferencesOnPreferenceStore(this.getPreferenceStore());
        return new TodoTagRule(token, prefs.getTagNames(), prefs.isCaseSensitive());
    }
}

