/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class HistoryListAction
extends Action {
    private TypeHierarchyViewPart fView;

    public HistoryListAction(TypeHierarchyViewPart view) {
        this.fView = view;
        this.setText(TypeHierarchyMessages.HistoryListAction_label);
    }

    public void run() {
        IModelElement[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(DLTKUIPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInputElement(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private IModelElement fResult;

        private HistoryListDialog(Shell shell, IModelElement[] elements) {
            super(shell);
            this.setTitle(TypeHierarchyMessages.HistoryListDialog_title);
            String[] buttonLabels = new String[]{TypeHierarchyMessages.HistoryListDialog_remove_button};
            IListAdapter adapter = new IListAdapter(){

                public void customButtonPressed(ListDialogField field, int index) {
                    HistoryListDialog.this.doCustomButtonPressed();
                }

                public void selectionChanged(ListDialogField field) {
                    HistoryListDialog.this.doSelectionChanged();
                }

                public void doubleClicked(ListDialogField field) {
                    HistoryListDialog.this.doDoubleClicked();
                }
            };
            ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(1088);
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
            this.fHistoryList.setLabelText(TypeHierarchyMessages.HistoryListDialog_label);
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection((Object)elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(parent.getFont());
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (IModelElement)selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public IModelElement getResult() {
            return this.fResult;
        }

        public IModelElement[] getRemaining() {
            List elems = this.fHistoryList.getElements();
            return elems.toArray(new IModelElement[elems.size()]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }
    }
}

