/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.dltk.internal.ui.search.WorkingSetsComparator;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class LRUWorkingSetsList {
    private final ArrayList fLRUList;
    private final int fSize;
    private final WorkingSetsComparator fComparator = new WorkingSetsComparator();

    public LRUWorkingSetsList(int size) {
        this.fSize = size;
        this.fLRUList = new ArrayList(size);
    }

    public void add(IWorkingSet[] workingSets) {
        this.removeDeletedWorkingSets();
        IWorkingSet[] existingWorkingSets = this.find(this.fLRUList, workingSets);
        if (existingWorkingSets != null) {
            this.fLRUList.remove(existingWorkingSets);
        } else if (this.fLRUList.size() == this.fSize) {
            this.fLRUList.remove(this.fSize - 1);
        }
        this.fLRUList.add(0, workingSets);
    }

    public Iterator iterator() {
        this.removeDeletedWorkingSets();
        return this.fLRUList.iterator();
    }

    public Iterator sortedIterator() {
        this.removeDeletedWorkingSets();
        ArrayList sortedList = new ArrayList(this.fLRUList);
        Collections.sort(sortedList, this.fComparator);
        return sortedList.iterator();
    }

    private void removeDeletedWorkingSets() {
        block0: for (IWorkingSet[] workingSets : new ArrayList(this.fLRUList)) {
            int i = 0;
            while (i < workingSets.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSets[i].getName()) == null) {
                    this.fLRUList.remove(workingSets);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private IWorkingSet[] find(ArrayList list, IWorkingSet[] workingSets) {
        HashSet workingSetList = new HashSet(Arrays.asList(workingSets));
        for (IWorkingSet[] lruWorkingSets : list) {
            HashSet lruWorkingSetList = new HashSet(Arrays.asList(lruWorkingSets));
            if (!lruWorkingSetList.equals(workingSetList)) continue;
            return lruWorkingSets;
        }
        return null;
    }
}

