/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IFileHierarchyInfo;
import org.eclipse.dltk.core.IFileHierarchyResolver;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class HierarchyResolver {
    private HierarchyBuilder hierarchyBuilder;
    private SearchEngine engine;

    public HierarchyResolver(HierarchyBuilder hierarchy) {
        this.hierarchyBuilder = hierarchy;
        this.engine = new SearchEngine();
    }

    public void resolve(boolean computeSubtypes) throws CoreException {
        IType focusType = this.hierarchyBuilder.getType();
        this.hierarchyBuilder.hierarchy.initialize(0);
        if (computeSubtypes) {
            this.computeSubtypes(focusType);
        }
        this.computeSupertypes(focusType);
    }

    protected void computeSubtypes(IType focusType) throws CoreException {
        final HashMap superTypeToExtender = new HashMap();
        final HandleFactory handleFactory = new HandleFactory();
        final String delimiter = this.getDelimiterReplacementString(focusType);
        TypeNameRequestor typesCollector = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, char[][] superTypes, String path) {
                if (superTypes != null) {
                    int i = 0;
                    while (i < superTypes.length) {
                        Openable openable;
                        String s = new String(superTypes[i]);
                        LinkedList<String> extenders = (LinkedList<String>)superTypeToExtender.get(s);
                        if (extenders == null) {
                            extenders = new LinkedList<String>();
                            superTypeToExtender.put(s, extenders);
                        }
                        ModelElement parent = openable = handleFactory.createOpenable(path, ((HierarchyResolver)HierarchyResolver.this).hierarchyBuilder.hierarchy.scope);
                        if (enclosingTypeNames != null) {
                            int j = 0;
                            while (j < enclosingTypeNames.length) {
                                parent = new FakeType(parent, new String(enclosingTypeNames[j]));
                                ++j;
                            }
                        }
                        FakeType type = new FakeType(parent, new String(simpleTypeName), modifiers);
                        extenders.add(new String(type.getTypeQualifiedName(delimiter)));
                        ++i;
                    }
                }
            }
        };
        this.engine.searchAllTypeNames(null, 0, "*".toCharArray(), 2, 0, this.hierarchyBuilder.hierarchy.scope, typesCollector, 3, this.hierarchyBuilder.hierarchy.progressMonitor);
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveDown(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSubtypesFor(focusType, superTypeToExtender, new HashMap(), hierarchyInfo, new HashSet(), delimiter);
    }

    protected void computeSubtypesFor(IType focusType, Map superTypeToExtender, Map subTypesCache, IFileHierarchyInfo hierarchyInfo, Set processedTypes, String delimiter) throws CoreException {
        List extenders = (List)superTypeToExtender.get(focusType.getTypeQualifiedName(delimiter));
        if (extenders != null) {
            IType subType;
            IType[] subTypes = this.searchTypes(extenders.toArray(new String[extenders.size()]), subTypesCache, hierarchyInfo);
            int i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                this.hierarchyBuilder.hierarchy.addSubtype(focusType, subType);
                ++i;
            }
            i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                if (processedTypes.add(subType)) {
                    this.computeSubtypesFor(subType, superTypeToExtender, subTypesCache, hierarchyInfo, processedTypes, delimiter);
                }
                ++i;
            }
        }
    }

    protected void computeSupertypes(IType focusType) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveUp(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSupertypesFor(focusType, new HashMap(), hierarchyInfo, new HashSet());
    }

    protected void computeSupertypesFor(IType focusType, Map superTypesCache, IFileHierarchyInfo hierarchyInfo, Set processedTypes) throws CoreException {
        processedTypes.add(focusType);
        String[] superClasses = focusType.getSuperClasses();
        if (superClasses != null && superClasses.length > 0) {
            IType superclass;
            IType[] searchTypes = this.searchTypes(superClasses, superTypesCache, hierarchyInfo);
            int i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                this.hierarchyBuilder.hierarchy.cacheSuperclass(focusType, superclass);
                ++i;
            }
            i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                if (!processedTypes.contains(superclass)) {
                    this.computeSupertypesFor(superclass, superTypesCache, hierarchyInfo, processedTypes);
                }
                ++i;
            }
        } else if (!this.hierarchyBuilder.hierarchy.contains(focusType)) {
            this.hierarchyBuilder.hierarchy.addRootClass(focusType);
        }
    }

    protected IType[] searchTypes(String[] typeNames, Map cache, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        LinkedList result = new LinkedList();
        int i = 0;
        while (i < typeNames.length) {
            String typeName = typeNames[i];
            result.addAll(Arrays.asList(this.searchTypes(typeName, cache, hierarchyInfo)));
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    protected IType[] searchTypes(String type, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        return this.searchTypes(type, null, hierarchyInfo);
    }

    protected IType[] searchTypes(final String typeName, Map cache, final IFileHierarchyInfo hierarchyInfo) throws CoreException {
        if (cache != null && cache.containsKey(typeName)) {
            return (IType[])cache.get(typeName);
        }
        final LinkedList result = new LinkedList();
        final LinkedList filteredTypes = new LinkedList();
        final HandleFactory handleFactory = new HandleFactory();
        TypeNameRequestor typesCollector = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, char[][] superTypes, String path) {
                String delimiter;
                FakeType type;
                String qualifiedName;
                Openable openable;
                ModelElement parent = openable = handleFactory.createOpenable(path, ((HierarchyResolver)HierarchyResolver.this).hierarchyBuilder.hierarchy.scope);
                ISourceModule sourceModule = (ISourceModule)((Object)openable);
                if (enclosingTypeNames != null) {
                    int j = 0;
                    while (j < enclosingTypeNames.length) {
                        parent = new FakeType(parent, new String(enclosingTypeNames[j]));
                        ++j;
                    }
                }
                if (!typeName.equalsIgnoreCase(qualifiedName = (type = new FakeType(parent, new String(simpleTypeName), modifiers)).getTypeQualifiedName(delimiter = HierarchyResolver.this.getDelimiterReplacementString(type)))) {
                    return;
                }
                if (hierarchyInfo != null && !hierarchyInfo.exists(sourceModule)) {
                    filteredTypes.add(type);
                    return;
                }
                result.add(type);
            }
        };
        this.engine.searchAllTypeNames(null, 0, typeName.toCharArray(), 2, 0, this.hierarchyBuilder.hierarchy.scope, typesCollector, 3, this.hierarchyBuilder.hierarchy.progressMonitor);
        if (result.isEmpty()) {
            result.addAll(filteredTypes);
        }
        IType[] types = result.toArray(new IType[result.size()]);
        if (cache != null) {
            cache.put(typeName, types);
        }
        return types;
    }

    public void resolve(Openable[] openables, HashSet localTypes) {
        block2: {
            try {
                this.resolve(true);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private static IFileHierarchyResolver createFileHierarchyResolver(IType type) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = null;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null) {
            fileHierarchyResolver = DLTKLanguageManager.getFileHierarchyResolver(toolkit.getNatureId());
        }
        return fileHierarchyResolver;
    }

    private static ISearchPatternProcessor getSearchPatternProcessor(IType type) {
        ISearchFactory factory;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null && (factory = DLTKLanguageManager.getSearchFactory(toolkit.getNatureId())) != null) {
            return factory.createSearchPatternProcessor();
        }
        return null;
    }

    protected String getDelimiterReplacementString(IType type) {
        ISearchPatternProcessor searchPatternProcessor = HierarchyResolver.getSearchPatternProcessor(type);
        if (searchPatternProcessor != null) {
            return searchPatternProcessor.getDelimiterReplacementString();
        }
        return "::";
    }
}

