/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.AbstractDataSaver;
import org.eclipse.dltk.core.caching.IStructureConstants;

public class StructureModelCollector
extends AbstractDataSaver
implements ISourceElementRequestor,
IStructureConstants {
    private ISourceElementRequestor baseRequestor;

    public StructureModelCollector(ISourceElementRequestor requestor) {
        super(new ByteArrayOutputStream());
        this.baseRequestor = requestor;
    }

    private void writeString(char[] fieldName) throws IOException {
        if (fieldName == null) {
            this.writeString((String)null);
        } else {
            this.writeString(new String(fieldName));
        }
    }

    private void writeString(char[][] typeName) throws IOException {
        if (typeName == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt(typeName.length);
            int i = 0;
            while (i < typeName.length) {
                this.writeString(typeName[i]);
                ++i;
            }
        }
    }

    private void writeString(String[] strs) throws IOException {
        if (strs == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt(strs.length);
            int i = 0;
            while (i < strs.length) {
                this.writeString(strs[i]);
                ++i;
            }
        }
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.baseRequestor.acceptFieldReference(fieldName, sourcePosition);
        try {
            this.out.writeInt(0);
            this.writeString(fieldName);
            this.out.writeInt(sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        this.baseRequestor.acceptMethodReference(methodName, argCount, sourcePosition, sourceEndPosition);
        try {
            this.out.writeInt(1);
            this.writeString(methodName);
            this.out.writeInt(argCount);
            this.out.writeInt(sourcePosition);
            this.out.writeInt(sourceEndPosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.baseRequestor.acceptPackage(declarationStart, declarationEnd, name);
        try {
            this.out.writeInt(2);
            this.writeString(name);
            this.out.writeInt(declarationStart);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        this.baseRequestor.acceptTypeReference(typeName, sourceStart, sourceEnd);
        try {
            this.out.writeInt(3);
            this.writeString(typeName);
            this.out.writeInt(sourceStart);
            this.out.writeInt(sourceEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference(char[] typeName, int sourcePosition) {
        this.baseRequestor.acceptTypeReference(typeName, sourcePosition);
        try {
            this.out.writeInt(4);
            this.writeString(typeName);
            this.out.writeInt(sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterField(ISourceElementRequestor.FieldInfo info) {
        this.baseRequestor.enterField(info);
        try {
            this.out.writeInt(5);
            this.writeFieldInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFieldInfo(ISourceElementRequestor.FieldInfo info) throws IOException {
        this.writeElementInfo(info);
    }

    private void writeMethodInfo(ISourceElementRequestor.MethodInfo info) throws IOException {
        this.writeElementInfo(info);
        this.writeString(info.parameterNames);
        this.writeString(info.parameterInitializers);
        this.writeString(info.exceptionTypes);
        this.out.writeBoolean(info.isConstructor);
    }

    private void writeTypeInfo(ISourceElementRequestor.TypeInfo info) throws IOException {
        this.writeElementInfo(info);
        this.writeString(info.superclasses);
    }

    private void writeElementInfo(ISourceElementRequestor.ElementInfo info) throws IOException {
        this.writeString(info.name);
        this.out.writeInt(info.modifiers);
        this.out.writeInt(info.nameSourceStart);
        this.out.writeInt(info.nameSourceEnd);
        this.out.writeInt(info.declarationStart);
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
        boolean result = this.baseRequestor.enterFieldCheckDuplicates(info);
        try {
            this.out.writeInt(6);
            this.writeFieldInfo(info);
            this.out.writeBoolean(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        boolean result = this.baseRequestor.enterFieldWithParentType(info, parentName, delimiter);
        try {
            this.out.writeInt(7);
            this.writeFieldInfo(info);
            this.writeString(parentName);
            this.writeString(delimiter);
            this.out.writeBoolean(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo info) {
        this.baseRequestor.enterMethod(info);
        try {
            this.out.writeInt(8);
            this.writeMethodInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
        this.baseRequestor.enterMethodRemoveSame(info);
        try {
            this.out.writeInt(9);
            this.writeMethodInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        boolean result = this.baseRequestor.enterMethodWithParentType(info, parentName, delimiter);
        try {
            this.out.writeInt(10);
            this.writeMethodInfo(info);
            this.writeString(parentName);
            this.writeString(delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterModule() {
        this.baseRequestor.enterModule();
        try {
            this.out.writeInt(11);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterModuleRoot() {
        this.baseRequestor.enterModuleRoot();
        try {
            this.out.writeInt(12);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterType(ISourceElementRequestor.TypeInfo info) {
        this.baseRequestor.enterType(info);
        try {
            this.out.writeInt(13);
            this.writeTypeInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        boolean result = this.baseRequestor.enterTypeAppend(fullName, delimiter);
        try {
            this.out.writeInt(14);
            this.writeString(fullName);
            this.writeString(delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void exitField(int declarationEnd) {
        this.baseRequestor.exitField(declarationEnd);
        try {
            this.out.writeInt(15);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitMethod(int declarationEnd) {
        this.baseRequestor.exitMethod(declarationEnd);
        try {
            this.out.writeInt(16);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModule(int declarationEnd) {
        this.baseRequestor.exitModule(declarationEnd);
        try {
            this.out.writeInt(17);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModuleRoot() {
        this.baseRequestor.exitModuleRoot();
        try {
            this.out.writeInt(18);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitType(int declarationEnd) {
        this.baseRequestor.exitType(declarationEnd);
        try {
            this.out.writeInt(19);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getBytes() {
        block2: {
            try {
                this.stream.flush();
                this.storeStringIndex();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return ((ByteArrayOutputStream)this.stream).toByteArray();
    }
}

