/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IInterpreterContainerExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.core.packages.PackagesManager;

public class TclPackagesInterpreterContainerExtension
implements IInterpreterContainerExtension {
    private static final IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public void processEntres(IScriptProject project, List buildpathEntries) {
        IInterpreterInstall install;
        IPath[] locations;
        block12: {
            locations = null;
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
                ArrayList<IPath> locs = new ArrayList<IPath>();
                Iterator iterator = buildpathEntries.iterator();
                while (iterator.hasNext()) {
                    IBuildpathEntry entry = (IBuildpathEntry)iterator.next();
                    if (entry.getEntryKind() == 1 && entry.isExternal()) {
                        locs.add(entry.getPath());
                    }
                    locations = locs.toArray(new IPath[locs.size()]);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block12;
                e.printStackTrace();
            }
        }
        if (install != null) {
            Set packages = InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project);
            if (packages.size() == 0) {
                return;
            }
            IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)project);
            HashSet<IPath> allPaths = new HashSet<IPath>();
            IPath[] libs = PackagesManager.getInstance().getPathsForPackagesWithDeps(install, packages);
            int i = 0;
            while (i < libs.length) {
                IPath fullPath = EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)libs[i]);
                allPaths.add(fullPath);
                ++i;
            }
            HashSet<IPath> rawEntries = new HashSet<IPath>(allPaths.size());
            Iterator iterator = allPaths.iterator();
            while (iterator.hasNext()) {
                IPath entryPath = (IPath)iterator.next();
                if (entryPath.isEmpty() || rawEntries.contains(entryPath)) continue;
                IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                ArrayList<IPath> excluded = new ArrayList<IPath>();
                Iterator iterator2 = allPaths.iterator();
                while (iterator2.hasNext()) {
                    IPath pattern;
                    IPath otherPath = (IPath)iterator2.next();
                    if (otherPath.isEmpty() || !entryPath.isPrefixOf(otherPath) || otherPath.equals((Object)entryPath) || excluded.contains(pattern = otherPath.removeFirstSegments(entryPath.segmentCount()).append("*"))) continue;
                    excluded.add(pattern);
                }
                boolean inInterpreter = false;
                if (locations != null) {
                    int i2 = 0;
                    while (i2 < locations.length) {
                        IPath path = locations[i2];
                        if (path.isPrefixOf(entryPath)) {
                            inInterpreter = true;
                            break;
                        }
                        ++i2;
                    }
                }
                if (inInterpreter) continue;
                buildpathEntries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
                rawEntries.add(entryPath);
            }
        }
    }
}

