/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblem;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.jface.preference.IPreferenceStore;

public final class TclCheckerHelper {
    private static final String REGEX = "((?:\\w:)?[^:]+):(\\d+)\\s+\\((\\w+)\\)\\s+(.*)";
    private static final String W1_OPTION = "-W1";
    private static final String W2_OPTION = "-W2";
    private static final String W3_OPTION = "-W3";
    private static final Object PCX_OPTION = "-pcx";
    private static final Object NO_PCX_OPTION = "-nopcx";
    private static final String SUPPRESS_OPTION = "-suppress";
    private static final Pattern pattern = Pattern.compile("((?:\\w:)?[^:]+):(\\d+)\\s+\\((\\w+)\\)\\s+(.*)");

    public static String[] makeTclCheckerCmdLine(IPreferenceStore store, String path, IEnvironment environment) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        TclCheckerHelper.passOriginalArguments(store, cmdLine, environment);
        cmdLine.add(path);
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    public static boolean passOriginalArguments(IPreferenceStore store, List cmdLine, IEnvironment environment) {
        Map paths = TclCheckerHelper.getPaths(store);
        String path = (String)paths.get(environment);
        if (path == null || path.length() == 0) {
            return false;
        }
        IFileHandle validatorFile = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)new Path(path));
        cmdLine.add(validatorFile.toOSString());
        int mode = store.getInt("tclchecker.mode");
        if (mode == 0) {
            cmdLine.add(W1_OPTION);
        } else if (mode == 1) {
            cmdLine.add(W2_OPTION);
        } else if (mode == 2) {
            cmdLine.add(W3_OPTION);
        }
        List problems = TclCheckerProblemDescription.getProblemIdentifiers();
        Iterator it = problems.iterator();
        while (it.hasNext()) {
            String warningName = (String)it.next();
            if (!store.getBoolean(warningName)) continue;
            cmdLine.add(SUPPRESS_OPTION);
            cmdLine.add(warningName);
        }
        boolean noPcx = store.getBoolean("tclchecker.no_pcx");
        if (noPcx) {
            cmdLine.add(NO_PCX_OPTION);
        } else {
            Map pcxPaths = TclCheckerHelper.getPcxPaths(store);
            if (pcxPaths.containsKey(environment)) {
                List pcxPath = (List)pcxPaths.get(environment);
                Iterator iterator = pcxPath.iterator();
                while (iterator.hasNext()) {
                    String pcx = (String)iterator.next();
                    cmdLine.add(PCX_OPTION);
                    cmdLine.add(pcx);
                }
            }
        }
        return true;
    }

    public static TclCheckerProblem parseProblem(String problem) {
        Matcher matcher = pattern.matcher(problem);
        if (!matcher.find()) {
            return null;
        }
        String file = matcher.group(1);
        int lineNumber = Integer.parseInt(matcher.group(2));
        String messageID = matcher.group(3);
        String message = matcher.group(4);
        return new TclCheckerProblem(file, lineNumber, messageID, message);
    }

    public static Map getPcxPaths(IPreferenceStore store) {
        HashMap<IEnvironment, List> results = new HashMap<IEnvironment, List>();
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int i = 0;
        while (i < environments.length) {
            results.put(environments[i], TclCheckerHelper.getPcxPathsFrom(store, "tclchecker.pcx.path." + environments[i].getId()));
            ++i;
        }
        return results;
    }

    private static List getPcxPathsFrom(IPreferenceStore store, String key) {
        String path;
        String pcxPathsValue = store.getString(key);
        ArrayList<String> values = new ArrayList<String>();
        int start = 0;
        int i = 0;
        while (i < pcxPathsValue.length()) {
            if (pcxPathsValue.charAt(i) == File.pathSeparatorChar && start < i) {
                String path2 = pcxPathsValue.substring(start, i);
                if (path2.length() > 0) {
                    values.add(path2);
                }
                start = i + 1;
            }
            ++i;
        }
        if (start < pcxPathsValue.length() && (path = pcxPathsValue.substring(start, pcxPathsValue.length())).length() > 0) {
            values.add(path);
        }
        return values;
    }

    public static void setPcxPaths(IPreferenceStore store, Map paths) {
        Iterator iterator = paths.keySet().iterator();
        while (iterator.hasNext()) {
            IEnvironment environment = (IEnvironment)iterator.next();
            TclCheckerHelper.setPcxPathsTo(store, "tclchecker.pcx.path." + environment.getId(), (List)paths.get(environment));
        }
    }

    private static void setPcxPathsTo(IPreferenceStore store, String key, List paths) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            if (!first) {
                buffer.append(File.pathSeparator);
            } else {
                first = false;
            }
            buffer.append(path);
        }
        store.setValue(key, buffer.toString());
    }

    public static Map getPaths(IPreferenceStore store) {
        String prefix = "tclchecker.path";
        Map results = TclCheckerHelper.getEnvironmentValues(store, prefix);
        return results;
    }

    public static void setPaths(IPreferenceStore store, Map paths) {
        String prefix = "tclchecker.path";
        TclCheckerHelper.setEnvironmentValues(store, paths, prefix);
    }

    public static boolean canExecuteTclChecker(IPreferenceStore store, IEnvironment environment) {
        IFileHandle file;
        String path;
        Map paths = TclCheckerHelper.getPaths(store);
        return paths.containsKey(environment) && (path = (String)paths.get(environment)).length() != 0 && (file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)new Path(path))).exists();
    }

    public static Map getNoPCX(IPreferenceStore store) {
        return TclCheckerHelper.getEnvironmentValues(store, "tclchecker.no_pcx");
    }

    public static void setNoPCX(IPreferenceStore store, Map paths) {
        TclCheckerHelper.setEnvironmentValues(store, paths, "tclchecker.no_pcx");
    }

    private static Map getEnvironmentValues(IPreferenceStore store, String prefix) {
        HashMap<IEnvironment, String> results = new HashMap<IEnvironment, String>();
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int i = 0;
        while (i < environments.length) {
            results.put(environments[i], store.getString(String.valueOf(prefix) + "." + environments[i].getId()));
            ++i;
        }
        return results;
    }

    private static void setEnvironmentValues(IPreferenceStore store, Map paths, String prefix) {
        Iterator iterator = paths.keySet().iterator();
        while (iterator.hasNext()) {
            IEnvironment environment = (IEnvironment)iterator.next();
            store.setValue(String.valueOf(prefix) + "." + environment.getId(), (String)paths.get(environment));
        }
    }
}

