/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.dbgp.DbgpServer;
import org.eclipse.dltk.dbgp.IDbgpServerListener;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;

public class DbgpService
implements IDbgpService,
Preferences.IPropertyChangeListener,
IDbgpTerminationListener,
IDbgpServerListener {
    private static final int FROM_PORT = 10000;
    private static final int TO_PORT = 50000;
    private static final int SERVER_SOCKET_TIMEOUT = 500;
    private static final int CLIENT_SOCKET_TIMEOUT = 10000000;
    private DbgpServer server;
    private Map acceptors = Collections.synchronizedMap(new HashMap());
    private int serverPort;

    private int getPreferencePort() {
        return DLTKDebugPlugin.getDefault().getPluginPreferences().getInt("dbgp_port");
    }

    protected void restartServer(int port) {
        if (this.server != null) {
            this.server.removeTerminationListener(this);
            this.server.setListener(null);
            this.server.requestTermination();
            try {
                this.server.waitTerminated();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.serverPort = port;
        this.server = new DbgpServer(port, 500, 10000000);
        this.server.addTerminationListener(this);
        this.server.setListener(this);
        this.server.start();
    }

    public DbgpService() {
        DLTKDebugPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        int port = this.getPreferencePort();
        if (port == -1) {
            port = DbgpServer.findAvailablePort(10000, 50000);
        }
        this.restartServer(port);
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.removeTerminationListener(this);
            this.server.setListener(null);
            this.server.requestTermination();
            try {
                this.server.waitTerminated();
            }
            catch (InterruptedException e) {
                DLTKDebugPlugin.log(e);
            }
        }
    }

    public int getPort() {
        return this.serverPort;
    }

    public void registerAcceptor(String id, IDbgpThreadAcceptor acceptor) {
        this.acceptors.put(id, acceptor);
    }

    public IDbgpThreadAcceptor unregisterAcceptor(String id) {
        return (IDbgpThreadAcceptor)this.acceptors.remove(id);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        int port;
        String property = event.getProperty();
        if ("dbgp_port".equals(property) && (port = this.getPreferencePort()) != -1) {
            this.restartServer(port);
        }
    }

    public void objectTerminated(Object object, Exception e) {
        if (e != null) {
            DLTKDebugPlugin.log(e);
            this.restartServer(this.serverPort);
        }
    }

    public boolean available() {
        return true;
    }

    public void clientConnected(IDbgpSession session) {
        String id = session.getInfo().getIdeKey();
        IDbgpThreadAcceptor acceptor = (IDbgpThreadAcceptor)this.acceptors.get(id);
        if (acceptor != null) {
            acceptor.acceptDbgpThread(session);
        } else {
            session.requestTermination();
        }
    }
}

