/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public abstract class AbstractInterpreterInstallType
implements IInterpreterInstallType,
IExecutableExtension {
    private static final int NOT_WORK_COUNT = -2;
    private static final String DLTK_TOTAL_WORK_START = "%DLTK_TOTAL_WORK_START%:";
    private static final String DLTK_TOTAL_WORK_END = "%DLTK_TOTAL_WORK_END%";
    private static final String DLTK_TOTAL_WORK_INC = "%DLTK_TOTAL_WORK_INCREMENT%";
    public static final String DLTK_PATH_PREFIX = "DLTK:";
    private List fInterpreters = new ArrayList();
    private String fId;
    private static HashMap fCachedLocations = new HashMap();
    static /* synthetic */ Class class$0;

    protected AbstractInterpreterInstallType() {
    }

    public IInterpreterInstall[] getInterpreterInstalls() {
        return this.fInterpreters.toArray(new IInterpreterInstall[this.fInterpreters.size()]);
    }

    public void disposeInterpreterInstall(String id) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getId().equals(id)) continue;
            it.remove();
            ScriptRuntime.fireInterpreterRemoved(install);
            return;
        }
    }

    public IInterpreterInstall findInterpreterInstall(String id) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getId().equals(id)) continue;
            return install;
        }
        return null;
    }

    public IInterpreterInstall createInterpreterInstall(String id) throws IllegalArgumentException {
        if (this.findInterpreterInstall(id) != null) {
            String format = LaunchingMessages.InterpreterInstallType_duplicateInterpreter;
            throw new IllegalArgumentException(MessageFormat.format(format, id));
        }
        IInterpreterInstall install = this.doCreateInterpreterInstall(id);
        this.fInterpreters.add(install);
        return install;
    }

    protected abstract IInterpreterInstall doCreateInterpreterInstall(String var1);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fId = config.getAttribute("id");
    }

    public String getId() {
        return this.fId;
    }

    public IInterpreterInstall findInterpreterInstallByName(String name) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getName().equals(name)) continue;
            return install;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void storeFile(File dest, URL url) throws IOException {
        OutputStream output;
        block5: {
            BufferedInputStream input = null;
            output = null;
            try {
                input = new BufferedInputStream(url.openStream());
                output = new BufferedOutputStream(new FileOutputStream(dest));
                int ch = -1;
                while ((ch = ((InputStream)input).read()) != -1) {
                    output.write(ch);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (input == null) break block5;
            }
            ((InputStream)input).close();
        }
        if (output == null) return;
        output.close();
    }

    protected String[] extractEnvironment(IExecutionEnvironment exeEnv, EnvironmentVariable[] variables) {
        Map env = exeEnv.getEnvironmentVariables(false);
        this.filterEnvironment(env);
        ArrayList<String> list = new ArrayList<String>();
        EnvironmentVariable[] vars = EnvironmentResolver.resolve(env, variables);
        if (variables != null) {
            int i = 0;
            while (i < vars.length) {
                env.put(vars[i].getName(), vars[i].getValue());
                ++i;
            }
        }
        Iterator it = env.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            list.add(entry.getKey() + "=" + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected void filterEnvironment(Map environment) {
    }

    protected String[] readPathsFromProcess(final IProgressMonitor monitor, final Process process) {
        ArrayList result;
        block2: {
            final BufferedReader dataIn = new BufferedReader(new InputStreamReader(process.getInputStream()));
            result = new ArrayList();
            Thread tReading = new Thread(new Runnable(){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 225->229)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            tReading.start();
            try {
                tReading.join(10000L);
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean detectWorkInc(String line) {
        return line.indexOf(DLTK_TOTAL_WORK_INC) != -1;
    }

    private int extractWorkFromLine(String line) {
        int pos1 = line.indexOf(DLTK_TOTAL_WORK_START);
        int pos2 = line.indexOf(DLTK_TOTAL_WORK_END);
        if (pos1 != -1 && pos2 != -1) {
            String totalWork = line.substring(pos1 + DLTK_TOTAL_WORK_START.length(), pos2);
            int intValue = new Integer(totalWork);
            if (intValue == -1) {
                return -1;
            }
            return intValue;
        }
        return -2;
    }

    public static LibraryLocation[] correctLocations(List locs) {
        return AbstractInterpreterInstallType.correctLocations(locs, null);
    }

    public static LibraryLocation[] correctLocations(List locs, IProgressMonitor monitor) {
        ArrayList<LibraryLocation> resolvedLocs = new ArrayList<LibraryLocation>();
        if (monitor != null) {
            monitor.beginTask(LaunchingMessages.AbstractInterpreterInstallType_correctingLocations, locs.size());
        }
        Iterator iter = locs.iterator();
        while (iter.hasNext()) {
            LibraryLocation n = (LibraryLocation)iter.next();
            if (!resolvedLocs.contains(n)) {
                resolvedLocs.add(n);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        LibraryLocation[] libs = resolvedLocs.toArray(new LibraryLocation[resolvedLocs.size()]);
        if (monitor != null) {
            monitor.done();
        }
        return libs;
    }

    protected void fillLocationsExceptOne(IEnvironment env, List locs, String[] paths, IPath path) {
        String sPath = path.toOSString();
        int i = 0;
        while (i < paths.length) {
            LibraryLocation l;
            IFileHandle f;
            if (!paths[i].equals(sPath) && (f = env.getFile((IPath)new Path(paths[i]))).exists() && !locs.contains(l = new LibraryLocation(EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)f.getPath())))) {
                locs.add(l);
            }
            ++i;
        }
    }

    protected void runLibraryLookup(ILookupRunnable runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnable.run(monitor);
    }

    protected abstract String getPluginId();

    protected abstract String[] getPossibleInterpreterNames();

    protected abstract ILog getLog();

    protected abstract IPath createPathFile(IDeployment var1) throws IOException;

    protected String[] buildCommandLine(IFileHandle installLocation, IFileHandle pathFile) {
        String interpreterPath = installLocation.getCanonicalPath();
        String scriptPath = pathFile.getCanonicalPath();
        return new String[]{interpreterPath, scriptPath};
    }

    protected String getBuildPathDelimeter() {
        return " ";
    }

    protected String[] parsePaths(String result) {
        String res = result;
        if (res.startsWith(DLTK_PATH_PREFIX)) {
            res = res.substring(DLTK_PATH_PREFIX.length());
        }
        String[] paths = res.split(this.getBuildPathDelimeter());
        ArrayList<String> filtered = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            if (!paths[i].equals(".")) {
                filtered.add(paths[i].trim());
            }
            ++i;
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    protected String[] parsePaths(String[] result) {
        ArrayList<String> filtered = new ArrayList<String>();
        int k = 0;
        while (k < result.length) {
            String res = result[k];
            if (res.startsWith(DLTK_PATH_PREFIX)) {
                res = res.substring(DLTK_PATH_PREFIX.length());
                String[] paths = this.parsePaths(res);
                int i = 0;
                while (i < paths.length) {
                    if (!paths[i].equals(".")) {
                        filtered.add(paths[i].trim());
                    }
                    ++i;
                }
            }
            ++k;
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    public IStatus validateInstallLocation(IFileHandle installLocation) {
        IExecutionEnvironment execEnv;
        if (!installLocation.exists() || !installLocation.isFile()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        String[] possibleNames = this.getPossibleInterpreterNames();
        boolean matchFound = false;
        String name = installLocation.getName();
        Path nPath = new Path(name);
        IEnvironment iEnvironment = installLocation.getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((execEnv = (IExecutionEnvironment)iEnvironment.getAdapter((Class)clazz)) != null) {
            int i = 0;
            while (i < possibleNames.length) {
                String possibleName = possibleNames[i].toLowerCase();
                if (execEnv.isValidExecutableAndEquals(possibleName, (IPath)nPath)) {
                    matchFound = true;
                    break;
                }
                ++i;
            }
        }
        if (matchFound) {
            return this.createStatus(0, "", null);
        }
        return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String retrivePaths(IExecutionEnvironment exeEnv, IFileHandle installLocation, List locations, IProgressMonitor monitor, IFileHandle locator, EnvironmentVariable[] variables) {
        Process process = null;
        try {
            block17: {
                try {
                    String string;
                    if (monitor != null && monitor.isCanceled()) {
                        Object var15_8 = null;
                        if (process != null) {
                            process.destroy();
                        }
                        if (monitor == null) return null;
                        monitor.done();
                        return null;
                    }
                    String[] env = this.extractEnvironment(exeEnv, variables);
                    String[] cmdLine = this.buildCommandLine(installLocation, locator);
                    try {
                        if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
                            this.traceExecution(LaunchingMessages.AbstractInterpreterInstallType_libraryDiscoveryScript, cmdLine, env);
                        }
                        if ((process = exeEnv.exec(cmdLine, null, env)) == null) break block17;
                        String[] result = this.readPathsFromProcess(monitor, process);
                        if (result == null) {
                            throw new IOException(LaunchingMessages.AbstractInterpreterInstallType_nullResultFromProcess);
                        }
                        if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
                            this.traceDiscoveryOutput(result);
                        }
                        String[] paths = null;
                        paths = result.length == 1 ? this.parsePaths(result[0]) : this.parsePaths(result);
                        IPath path = new Path(locator.getCanonicalPath()).removeLastSegments(1);
                        this.fillLocationsExceptOne(exeEnv.getEnvironment(), locations, paths, path);
                        if (result == null) break block17;
                        StringBuffer resultBuffer = new StringBuffer();
                        int i = 0;
                        while (i < result.length) {
                            resultBuffer.append(result[i]).append("\n");
                            ++i;
                        }
                        string = resultBuffer.toString();
                    }
                    catch (CoreException e) {
                        DLTKLaunchingPlugin.log(e);
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    Object var15_9 = null;
                    if (process != null) {
                        process.destroy();
                    }
                    if (monitor == null) return string;
                    monitor.done();
                    return string;
                }
                catch (IOException iOException) {}
            }
            Object var15_11 = null;
            if (process != null) {
                process.destroy();
            }
            if (monitor == null) return null;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            if (process != null) {
                process.destroy();
            }
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return null;
    }

    private void traceDiscoveryOutput(String[] result) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Discovery script output:").append('\n');
        sb.append("Output Result:");
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                sb.append(" " + result[i]);
                ++i;
            }
        } else {
            sb.append("Null");
        }
        sb.append("\n-----------------------------------------------\n");
        System.out.println(sb);
    }

    private void traceExecution(String processLabel, String[] cmdLineLabel, String[] environment) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Running ").append(processLabel).append('\n');
        sb.append("Command line: ");
        int i = 0;
        while (i < cmdLineLabel.length) {
            sb.append(" " + cmdLineLabel[i]);
            ++i;
        }
        sb.append("\n");
        sb.append("Environment:\n");
        i = 0;
        while (i < environment.length) {
            sb.append('\t').append(environment[i]).append('\n');
            ++i;
        }
        sb.append("-----------------------------------------------\n");
        System.out.println(sb);
    }

    protected ILookupRunnable createLookupRunnable(final IFileHandle installLocation, final List locations, final EnvironmentVariable[] variables) {
        return new ILookupRunnable(){

            /*
             * Exception decompiling
             */
            public void run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 225->231)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation) {
        return this.getDefaultLibraryLocations(installLocation, null);
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables) {
        return this.getDefaultLibraryLocations(installLocation, variables, null);
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables, IProgressMonitor monitor) {
        Object cacheKey;
        if (monitor != null) {
            monitor.beginTask(MessageFormat.format(LaunchingMessages.AbstractInterpreterInstallType_resolvingLibraryPaths, this.getName()), 100);
        }
        if (fCachedLocations.containsKey(cacheKey = AbstractInterpreterInstallType.makeKey(installLocation, variables))) {
            return (LibraryLocation[])fCachedLocations.get(cacheKey);
        }
        ArrayList locations = new ArrayList();
        ILookupRunnable runnable = this.createLookupRunnable(installLocation, locations, variables);
        try {
            this.runLibraryLookup(runnable, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 95) : null));
        }
        catch (InvocationTargetException e) {
            this.getLog().log(this.createStatus(4, LaunchingMessages.AbstractInterpreterInstallType_errorResolvingDefaultLibraries, e));
        }
        catch (InterruptedException e) {
            this.getLog().log(this.createStatus(4, LaunchingMessages.AbstractInterpreterInstallType_errorResolvingDefaultLibraries, e));
        }
        LibraryLocation[] libs = AbstractInterpreterInstallType.correctLocations(locations, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 5) : null));
        if (libs.length != 0) {
            fCachedLocations.put(cacheKey, libs);
        }
        if (monitor != null) {
            monitor.done();
        }
        return libs;
    }

    public static Object makeKey(IFileHandle installLocation, EnvironmentVariable[] variables) {
        String key = installLocation.toURI().toString();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                key = String.valueOf(key) + "|" + variables[i].getName() + ":" + variables[i].getValue();
                ++i;
            }
        }
        return key;
    }

    protected IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getPluginId(), 0, message, throwable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInterpreterInstallType other = (AbstractInterpreterInstallType)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }

    static /* synthetic */ int access$0(AbstractInterpreterInstallType abstractInterpreterInstallType, String string) {
        return abstractInterpreterInstallType.extractWorkFromLine(string);
    }

    static /* synthetic */ boolean access$1(AbstractInterpreterInstallType abstractInterpreterInstallType, String string) {
        return abstractInterpreterInstallType.detectWorkInc(string);
    }

    public static interface ILookupRunnable {
        public void run(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;
    }
}

