/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;

class TaskLazyChainWrapper {
    private final TaskExecutionContext parent;
    private final TaskChain child;

    public TaskLazyChainWrapper(TaskExecutionContext parent, TaskChain child) {
        this.parent = parent;
        this.child = child;
    }

    @Execute
    public IStatus execute(TaskingLog log) {
        IEclipseContext ec = this.parent.getContext().createChild(this.toString());
        try {
            TaskingEngine engine = (TaskingEngine)ContextInjectionFactory.make(TaskingEngine.class, (IEclipseContext)ec);
            TaskExecutionContext ctx = TaskingInjectionHelper.createNewChainContext(ec.createChild(TaskingModel.getTaskChainName(this.child)), this.child, (IProgressMonitor)this.parent.getContext().get(IProgressMonitor.class));
            IStatus iStatus = engine.runTaskChain(ctx);
            return iStatus;
        }
        finally {
            ec.dispose();
        }
    }

    public String toString() {
        return "Lazy: " + TaskingModel.getTaskChainName(this.child);
    }
}

