/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.AbstractProductBuild;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.util.StringHelper;

public class SimpleProductBuild
extends AbstractProductBuild {
    private final SimpleProductBuildDescription desc;

    public SimpleProductBuild(SimpleProductBuildDescription desc) {
        super(desc.featureBundle, desc.productBundle, desc.productFileName, desc.needProperties);
        this.desc = desc;
    }

    @Override
    public String getOfficialName() {
        return this.desc.name;
    }

    @Override
    public String getDescription() {
        return this.desc.description;
    }

    @Override
    public PlatformTriple[] getPlatformsToBuild() {
        return this.desc.platforms.toArray(new PlatformTriple[this.desc.platforms.size()]);
    }

    public static final class SimpleProductBuildDescription {
        public String name;
        public String description;
        public String featureBundle;
        public String productBundle;
        public String productFileName;
        public boolean needProperties = false;
        public List<PlatformTriple> platforms = new ArrayList<PlatformTriple>();

        public SimpleProductBuildDescription(FeatureBuild prodFeature, Properties props) {
            this.name = props.getProperty("alias");
            this.description = props.getProperty("description", this.name);
            this.featureBundle = props.getProperty("featureBundle");
            this.productBundle = prodFeature.getFeatureName();
            this.productFileName = this.findProductFile(prodFeature).getName();
            this.needProperties = Boolean.valueOf(props.getProperty("needProperties", "false"));
            this.applyPlatforms(props.getProperty("platforms"));
            if (this.name.isEmpty() || this.featureBundle.isEmpty()) {
                throw new IllegalStateException("'name' and 'featureBundle' must be set in " + prodFeature);
            }
        }

        private void applyPlatforms(String raw) {
            if (StringHelper.isNullOrEmpty((String)raw)) {
                this.platforms.add(PlatformTriple.LINUX64);
                this.platforms.add(PlatformTriple.WIN64);
                return;
            }
            Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)raw).stream().map(this::toTriple).forEach(this.platforms::add);
        }

        private PlatformTriple toTriple(String platform) {
            switch (platform.toLowerCase()) {
                case "win32": {
                    return PlatformTriple.WIN32;
                }
                case "win64": {
                    return PlatformTriple.WIN64;
                }
                case "linux32": {
                    return PlatformTriple.LINUX32;
                }
                case "linux64": {
                    return PlatformTriple.LINUX64;
                }
            }
            throw new IllegalStateException("unsupported platform: " + platform);
        }

        private File findProductFile(FeatureBuild prodFeature) {
            File root = ((FeatureData)prodFeature.getData()).getBundleDir();
            File[] candidates = root.listFiles((dir, name) -> name.endsWith(".product"));
            if (candidates == null || candidates.length != 1) {
                throw new IllegalStateException("Cannot find .product file in " + prodFeature);
            }
            return candidates[0];
        }
    }
}

