/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.stats;

import com.google.common.base.Strings;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.internal.listeners.TaskingStatusTracker;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.stats.TaskingStatConfig;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.services.TaskingStatisticsContribution;
import org.osgi.service.component.annotations.Component;

@Component
public class TaskingStatListener
implements TaskingLifeCycleListener {
    @FinishTaskChain
    public void postStats(TaskingLog log, TaskingStatConfig config, TaskExecutionContext context, @Named(value="org.eclipse.tea.core.prepared_tasks") @Named(value="org.eclipse.tea.core.prepared_tasks") List<Object> allTasks, TaskingStatusTracker tracker, @Service List<TaskingStatisticsContribution> contributions) {
        if (!config.statDebugMode && (Strings.isNullOrEmpty((String)config.statServer) || tracker.getStatus(context).getSeverity() >= 4)) {
            return;
        }
        StatDTO dto = new StatDTO();
        dto.timestamp = System.currentTimeMillis();
        dto.duration = tracker.getDuration(context);
        dto.taskChainClass = context.getUnderlyingChain().getClass().getName();
        dto.taskChainName = TaskingModel.getTaskChainName(context.getUnderlyingChain());
        try {
            dto.sysInfo = this.gatherSystemInfo();
        }
        catch (Exception e) {
            log.error("cannot gather system information", e);
        }
        this.gatherTasks(dto, allTasks, context, tracker);
        for (TaskingStatisticsContribution c : contributions) {
            Object contribution = ContextInjectionFactory.invoke((Object)c, TaskingStatisticsContribution.TaskingStatisticProvider.class, (IEclipseContext)context.getContext());
            if (contribution == null) continue;
            dto.contributions.put(this.getContributionQualifier(c), contribution);
        }
        try {
            this.post(log, config, dto);
        }
        catch (Exception e) {
            log.warn("failed to post statistics: " + e.toString());
        }
    }

    private String getContributionQualifier(TaskingStatisticsContribution c) {
        Method[] methodArray = c.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            TaskingStatisticsContribution.TaskingStatisticProvider p = m.getAnnotation(TaskingStatisticsContribution.TaskingStatisticProvider.class);
            if (p != null) {
                if (Strings.isNullOrEmpty((String)p.qualifier())) break;
                return p.qualifier();
            }
            ++n2;
        }
        return c.getClass().getSimpleName();
    }

    private StatusDTO convertStatus(IStatus status) {
        StatusDTO result = new StatusDTO();
        if (status == null) {
            result.message = "Skipped";
            return result;
        }
        result.severity = status.getSeverity();
        result.message = status.getMessage();
        if (status.getException() != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    status.getException().printStackTrace(new PrintStream(bos));
                    result.exception = bos.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                result.exception = "<unknown exception>";
            }
        }
        return result;
    }

    private void gatherTasks(StatDTO dto, List<Object> allTasks, TaskExecutionContext context, TaskingStatusTracker tracker) {
        for (Object o : allTasks) {
            TaskDTO t = new TaskDTO();
            t.taskClass = o.getClass().getName();
            t.taskName = TaskingModel.getTaskName(o);
            t.duration = tracker.getDuration(context, o);
            t.status = this.convertStatus(tracker.getStatus(context, o));
            dto.tasks.add(t);
        }
    }

    private SysDTO gatherSystemInfo() {
        SysDTO dto = new SysDTO();
        OperatingSystemMXBean osb = ManagementFactory.getOperatingSystemMXBean();
        dto.processors = osb.getAvailableProcessors();
        dto.os = String.valueOf(osb.getName()) + ":" + osb.getArch() + ":" + osb.getVersion();
        dto.loadavg = osb.getSystemLoadAverage();
        dto.totalMem = this.tryGet(osb, "getTotalPhysicalMemorySize", 0L);
        dto.freeMem = this.tryGet(osb, "getFreePhysicalMemorySize", 0L);
        dto.totalSwap = this.tryGet(osb, "getTotalSwapSpaceSize", 0L);
        dto.freeSwap = this.tryGet(osb, "getFreeSwapSpaceSize", 0L);
        dto.processLoad = this.tryGet(osb, "getProcessCpuLoad", 0.0);
        dto.systemLoad = this.tryGet(osb, "getSystemCpuLoad", 0.0);
        dto.processCpuTime = this.tryGet(osb, "getProcessCpuTime", 0L);
        return dto;
    }

    private <T> T tryGet(Object o, String methodName, T defaultValue) {
        try {
            Method m = o.getClass().getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            Object rv = m.invoke(o, new Object[0]);
            if (rv == null) {
                return defaultValue;
            }
            return (T)rv;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void post(TaskingLog log, TaskingStatConfig config, StatDTO dto) throws Exception {
        String content = new GsonBuilder().setPrettyPrinting().create().toJson((Object)dto);
        if (config.statDebugMode) {
            log.debug("will post to server (debug mode enabled): ");
            log.debug(content);
        }
        HttpURLConnection connection = null;
        try {
            String charset = Charset.defaultCharset().name();
            connection = (HttpURLConnection)new URL(config.statServer).openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept-Charset", charset);
            connection.setRequestProperty("Content-Type", "application/json");
            Throwable throwable = null;
            Object var8_9 = null;
            try (OutputStream output = connection.getOutputStream();){
                output.write(content.getBytes(charset));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            connection.getResponseCode();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        log.debug("posted statistics to " + config.statServer);
    }

    private static final class StatDTO {
        public long timestamp;
        public String taskChainClass;
        public String taskChainName;
        public long duration;
        public List<TaskDTO> tasks = new ArrayList<TaskDTO>();
        public SysDTO sysInfo = new SysDTO();
        public Map<String, Object> contributions = new TreeMap<String, Object>();

        private StatDTO() {
        }
    }

    private static class StatusDTO {
        public int severity = 0;
        public String message;
        public String exception;

        private StatusDTO() {
        }
    }

    private static class SysDTO {
        public String os = "<Unkown>";
        public long processCpuTime = 0L;
        public double systemLoad = 0.0;
        public double processLoad = 0.0;
        public long totalSwap = 0L;
        public long freeSwap = 0L;
        public long freeMem = 0L;
        public long totalMem = 0L;
        public double loadavg = 0.0;
        public int processors = 0;

        private SysDTO() {
        }
    }

    private static class TaskDTO {
        public String taskClass;
        public String taskName;
        public StatusDTO status;
        public long duration;

        private TaskDTO() {
        }
    }
}

