/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.p2.UpdateSite;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.StringHelper;

public final class UpdateSiteManager {
    private static final String ALL_SITES = "all";
    private final Map<String, UpdateSite> sites = new TreeMap<String, UpdateSite>();
    private final JarManager jarManager;
    private final File out;

    public UpdateSiteManager(File out, JarManager jarManager) {
        this.out = out;
        this.jarManager = jarManager;
    }

    public UpdateSite getSite(String guid) {
        UpdateSite site = this.sites.get(guid = this.safeGuid(guid));
        if (site == null) {
            site = new UpdateSite(this.out, guid, this.jarManager);
            this.sites.put(guid, site);
        }
        return site;
    }

    private String safeGuid(String guid) {
        if (StringHelper.isNullOrEmpty(guid)) {
            return ALL_SITES;
        }
        return guid;
    }

    public void createUpdateSiteZips(TaskingLog console) {
        ZipExecFactory zef = this.jarManager.getZipExecFactory();
        for (UpdateSite site : this.sites.values()) {
            site.createUpdateSiteZip(zef, console);
        }
    }

    public void clearSites() {
        try {
            for (UpdateSite site : this.sites.values()) {
                FileUtils.deleteDirectory(site.directory);
            }
        }
        finally {
            this.sites.clear();
        }
    }
}

