/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.OverlayPreferenceStore;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStorePreference;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class OverlayStoreConfigurationBlock
extends ConfigurationBlock {
    private IPreferenceStore fOriginalStore;
    protected OverlayPreferenceStore fOverlayStore;
    private boolean fIsDirty;
    private boolean fInLoading;

    @Override
    public void createContents(Composite pageComposite, IWorkbenchPreferenceContainer container, IPreferenceStore preferenceStore) {
        this.fOriginalStore = preferenceStore;
        super.createContents(pageComposite, container, preferenceStore);
    }

    protected void setupOverlayStore(OverlayStorePreference[] keys) {
        this.fOverlayStore = new OverlayPreferenceStore(this.fOriginalStore, keys);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!OverlayStoreConfigurationBlock.this.fInLoading) {
                    OverlayStoreConfigurationBlock.this.fIsDirty = true;
                    OverlayStoreConfigurationBlock.this.handlePropertyChange();
                }
            }
        });
        this.fIsDirty = false;
    }

    protected abstract Set<String> getChangedGroups();

    protected void handlePropertyChange() {
    }

    @Override
    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    @Override
    public boolean performOk(int flags) {
        if (this.fOverlayStore != null && this.fIsDirty) {
            this.fOverlayStore.propagate();
            this.fIsDirty = false;
            this.scheduleChangeNotification(this.getChangedGroups(), (flags & 0x10) != 0);
            return true;
        }
        return true;
    }

    @Override
    public void performDefaults() {
        if (this.fOverlayStore != null) {
            this.fInLoading = true;
            this.fOverlayStore.loadDefaults();
            this.fInLoading = false;
            this.fIsDirty = true;
            this.handlePropertyChange();
            this.updateControls();
        }
    }

    protected void updateControls() {
    }
}

