/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.tool;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class TmpUtils {
    private static final String CREATE_ITEM = "rj:::tmp.createItem";
    private static final String REMOVE_ITEM = "rj:::tmp.removeItem";
    private static final String SET = "rj:::tmp.set";
    private static final String REMOVE = "rj:::tmp.remove";
    private static final String PREFIX_PAR = "prefix";
    private static final String ID_PAR = "id";
    private static final String NAME_PAR = "name";
    private static final String VALUE_PAR = "value";
    private static final RElementName PKG_ELEMENT_NAME = RElementName.create(33, "rj");
    private static final RElementName ENV_ELEMENT_NAME = RElementName.create(17, ".rj.tmp");
    public static final RElementName ENV_FQ_ELEMENT_NAME = RElementName.create((List<RElementName>)ImCollections.newList((Object[])new RElementName[]{PKG_ELEMENT_NAME, ENV_ELEMENT_NAME}));
    public static final String ENV_FQ_NAME = "rj::.rj.tmp";

    public static boolean isTmp(RElementName elementName) {
        return PKG_ELEMENT_NAME.equals(elementName.getScope()) && ENV_ELEMENT_NAME.getSegmentName().equals(elementName.getSegmentName());
    }

    public static RElementName createFQElementName(RElementName name) {
        return RElementName.create((List<RElementName>)ImCollections.newList((Object[])new RElementName[]{PKG_ELEMENT_NAME, ENV_ELEMENT_NAME, name}));
    }

    public static Item newItem(String prefix, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall call = r.createFunctionCall(CREATE_ITEM);
        call.addChar(PREFIX_PAR, prefix);
        String id = RDataUtils.checkSingleCharValue((RObject)call.evalData(m));
        return new Item(id, r);
    }

    public static class Item {
        private final String id;
        private final RService r;

        Item(String id, RService r) {
            this.id = id;
            this.r = r;
        }

        public String getId() {
            return this.id;
        }

        public void dispose(ProgressMonitor m) throws StatusException {
            FunctionCall call = this.r.createFunctionCall(TmpUtils.REMOVE_ITEM);
            call.addChar(TmpUtils.ID_PAR, this.id);
            call.evalVoid(m);
        }

        public void disposeChecked(ProgressMonitor m) {
            try {
                this.dispose(m);
            }
            catch (StatusException e) {
                RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when cleaning up temporary objects.", (Throwable)e));
            }
        }

        public String createSub(String sub) {
            return String.valueOf(this.getId()) + sub;
        }

        public void set(String sub, RObject value, ProgressMonitor m) throws StatusException {
            FunctionCall call = this.r.createFunctionCall(TmpUtils.SET);
            call.addChar(TmpUtils.NAME_PAR, sub);
            call.add(TmpUtils.VALUE_PAR, value);
            call.evalVoid(m);
        }

        public void set(String sub, String expression, ProgressMonitor m) throws StatusException {
            FunctionCall call = this.r.createFunctionCall(TmpUtils.SET);
            call.addChar(TmpUtils.NAME_PAR, sub);
            call.add(TmpUtils.VALUE_PAR, expression);
            call.evalVoid(m);
        }

        public void remove(String sub, ProgressMonitor m) throws StatusException {
            FunctionCall call = this.r.createFunctionCall(TmpUtils.REMOVE);
            call.addChar(TmpUtils.NAME_PAR, sub);
            call.evalVoid(m);
        }
    }
}

