/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.sourcemodel.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.StatusDetail;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.rsource.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Arithmetic;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.CForLoop;
import org.eclipse.statet.r.core.rsource.ast.CIfElse;
import org.eclipse.statet.r.core.rsource.ast.CLoopCommand;
import org.eclipse.statet.r.core.rsource.ast.CRepeatLoop;
import org.eclipse.statet.r.core.rsource.ast.CWhileLoop;
import org.eclipse.statet.r.core.rsource.ast.Dummy;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.Group;
import org.eclipse.statet.r.core.rsource.ast.Help;
import org.eclipse.statet.r.core.rsource.ast.Logical;
import org.eclipse.statet.r.core.rsource.ast.Model;
import org.eclipse.statet.r.core.rsource.ast.NSGet;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.NullConst;
import org.eclipse.statet.r.core.rsource.ast.NumberConst;
import org.eclipse.statet.r.core.rsource.ast.Pipe;
import org.eclipse.statet.r.core.rsource.ast.Power;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Relational;
import org.eclipse.statet.r.core.rsource.ast.Seq;
import org.eclipse.statet.r.core.rsource.ast.Sign;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.Special;
import org.eclipse.statet.r.core.rsource.ast.StringConst;
import org.eclipse.statet.r.core.rsource.ast.SubIndexed;
import org.eclipse.statet.r.core.rsource.ast.SubNamed;
import org.eclipse.statet.r.core.rsource.ast.Symbol;
import org.eclipse.statet.r.core.rsource.util.RSourceMessageUtil;

@NonNullByDefault
public class SyntaxProblemReporter
extends RAstVisitor {
    private static final int BUFFER_SIZE = 100;
    private static final int FULL_TEXT_LIMIT = 100;
    private static final int START_TEXT_LIMIT = 25;
    private static final int MASK = 0xFFFFFF;
    private final boolean reportSubsequent = false;
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private SourceContent sourceContent = (SourceContent)ObjectUtils.nonNullLateInit();
    private ProblemRequestor currentRequestor = (ProblemRequestor)ObjectUtils.nonNullLateInit();
    private final RSourceMessageUtil messageUtil = new RSourceMessageUtil();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);
    private final RValueFormatter valueFormatter = new RValueFormatter();

    public void run(RSourceUnit su, SourceContent content, RAstNode node, ProblemRequestor problemRequestor) {
        try {
            try {
                this.sourceUnit = su;
                this.sourceContent = content;
                this.messageUtil.setSourceContent(content);
                this.currentRequestor = problemRequestor;
                node.acceptInR(this);
                if (this.problemBuffer.size() > 0) {
                    this.currentRequestor.acceptProblems("R", this.problemBuffer);
                }
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.problemBuffer.clear();
                this.sourceUnit = null;
                this.currentRequestor = null;
            }
        }
        finally {
            this.problemBuffer.clear();
            this.sourceUnit = null;
            this.currentRequestor = null;
        }
    }

    private boolean requiredCheck(int code) {
        return code != 0 && (code & 0x100000) == 0;
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        } else if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        this.problemBuffer.add((Problem)new BasicProblem("R", severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.currentRequestor.acceptProblems("R", this.problemBuffer);
            this.problemBuffer.clear();
        }
    }

    private void handleCommonCodes(RAstNode node, int code) throws BadLocationException, InvocationTargetException {
        block0 : switch (code & 0xFFFF0) {
            case 61440: {
                throw new InvocationTargetException(new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "Error occurred when parsing source code. Please submit a bug report with a code snippet.", null)));
            }
            case 70048: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_TokenUnexpected_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                break;
            }
            case 70064: {
                switch (code & 0xF) {
                    case 8: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprUnexpected_FCallAfterPipeExpected_message, node.getStartOffset(), node.getEndOffset());
                        break block0;
                    }
                }
                this.handleUnknownCodes(node);
                break;
            }
            default: {
                this.handleUnknownCodes(node);
            }
        }
    }

    protected void handleUnknownCodes(RAstNode node) {
        int code = node.getStatusCode() & 0xFFFFFF;
        StringBuilder sb = new StringBuilder();
        sb.append("Unhandled/Unknown code of R AST node:");
        sb.append('\n');
        sb.append("  Code: 0x").append(Integer.toHexString(code));
        sb.append('\n');
        sb.append("  Node: ").append((Object)node);
        sb.append(" (").append(node.getStartOffset()).append(", ").append(node.getLength()).append(')');
        sb.append('\n');
        if (this.sourceContent != null) {
            TextLineInformation lines = this.sourceContent.getStringLines();
            int line = lines.getLineOfOffset(node.getStartOffset() - this.sourceContent.getStartOffset());
            sb.append("  Line ").append(line + 1);
            sb.append('\n');
            int firstLine = Math.max(0, line - 2);
            int lastLine = Math.min(lines.getNumberOfLines() - 1, lines.getLineOfOffset(node.getEndOffset() - this.sourceContent.getStartOffset()) + 2);
            sb.append("  Source (line ").append(firstLine + 1).append('-').append(lastLine + 1).append("): \n");
            sb.append(this.sourceContent.getString(), lines.getStartOffset(firstLine), lines.getEndOffset(lastLine));
        }
        RCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.core", sb.toString()));
    }

    private int extStartOffset(int offset) {
        switch (this.sourceContent.contains(offset - 1) ? (int)this.sourceContent.getChar(offset - 1) : -1) {
            case 9: 
            case 32: {
                return offset - 1;
            }
        }
        return offset;
    }

    private int extEndOffset(int offset) {
        switch (this.sourceContent.contains(offset) ? (int)this.sourceContent.getChar(offset) : -1) {
            case 9: 
            case 32: {
                return offset + 1;
            }
        }
        return offset;
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Block node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70928: {
                        this.addProblem(2, code, ProblemMessages.Syntax_BlockNotClosed_message, node.getEndOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Group node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70928: {
                        this.addProblem(2, code, ProblemMessages.Syntax_GroupNotClosed_message, node.getEndOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70960: {
                        this.addProblem(2, code, ProblemMessages.Syntax_IfOfElseMissing_message, node.getStartOffset(), node.getStartOffset() + 1);
                        break;
                    }
                    case 70976: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_If_message, node.getStartOffset() + 1, node.getStartOffset() + 3);
                        break;
                    }
                    case 71008: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_If_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70976: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_For_message, node.getStartOffset() + 2, node.getStartOffset() + 4);
                        break;
                    }
                    case 71008: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_For_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                        break;
                    }
                    case 70992: {
                        this.addProblem(2, code, ProblemMessages.Syntax_InOfForConditionMissing_message, node.getVarChild().getEndOffset() - 1, node.getVarChild().getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70976: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionMissing_While_message, node.getStartOffset() + 4, node.getStartOffset() + 6);
                        break;
                    }
                    case 71008: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ConditionNotClosed_While_message, node.getCondChild().getEndOffset() - 1, node.getCondChild().getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(CLoopCommand node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70688: {
                        this.addProblem(2, code, ProblemMessages.Syntax_FcallArgsNotClosed_message, node.getArgsChild().getEndOffset() - 1, node.getArgsChild().getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FCall.Args node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FCall.Arg node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFFF) {
                    case 71446: {
                        int offset = node.getArgsCloseOffset();
                        this.addProblem(2, code, ProblemMessages.Syntax_FdefShorthandUnsupported_message, node.getStartOffset(), offset != Integer.MIN_VALUE ? offset + 1 : node.getArgsChild().getEndOffset());
                        break;
                    }
                    case 71184: {
                        int offset = node.getStartOffset() + node.getOperator((int)0).text.length();
                        this.addProblem(2, code, ProblemMessages.Syntax_FdefArgsMissing_message, offset - 1, offset + 1);
                        break;
                    }
                    case 71200: {
                        int offset = node.getArgsChild().getEndOffset();
                        this.addProblem(2, code, ProblemMessages.Syntax_FdefArgsNotClosed_message, offset - 1, offset + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FDef.Args node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(FDef.Arg node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Pipe node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFFF) {
                    case 71448: {
                        this.addProblem(2, code, ProblemMessages.Syntax_PipeRightUnsupported_message, node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                if ((code & 0xFFFFF) == 70049) {
                    this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_TokenUnexpected_SeqRel_message, (Object)node.getOperator((int)0).text), node.getStartOffset(), node.getEndOffset());
                } else {
                    this.handleCommonCodes(node, code);
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 69920: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_SpecialNotClosed_message, (Object)this.valueFormatter.escapeString(this.messageUtil.getStartText(node, 1))), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70704: {
                        if (node.getNodeType() == NodeType.SUB_INDEXED_S) {
                            this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_SubindexedNotClosed_S_message, (Object)this.messageUtil.getStartText(node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        if (node.getSublistCloseOffset() != Integer.MIN_VALUE) {
                            this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_SubindexedNotClosed_Done_message, (Object)this.messageUtil.getStartText(node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_SubindexedNotClosed_Dboth_message, (Object)this.messageUtil.getStartText(node, 0)), node.getEndOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(SubIndexed.Args node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(SubIndexed.Arg node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    private void handleTextInvalid(RAstNode node, int code) throws BadLocationException {
        StatusDetail detail = StatusDetail.getStatusDetail((AstNode)node);
        switch (code & 0xFFFFF) {
            case 69969: {
                this.addProblem(2, code, ProblemMessages.Syntax_Text_NullCharNotAllowed_message, detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 69973: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Text_EscapeSeqHexDigitMissing_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 69972: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Text_EscapeSeqNotClosed_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 69971: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Text_QuotedSymbol_EscapeSeqUnexpected_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 69977: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Text_EscapeSeqUnknown_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
            case 69979: {
                this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Text_CodePointInvalid_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                return;
            }
        }
        this.handleUnknownCodes(node);
    }

    @Override
    public void visit(StringConst node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 69904: {
                        this.addProblem(2, code, ProblemMessages.Syntax_StringROpeningIncomplete_message, node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 69920: {
                        this.addProblem(2, code, node.getOperator(0) == RTerminal.STRING_R ? this.messageBuilder.bind(ProblemMessages.Syntax_StringRNotClosed_message, (Object)this.valueFormatter.escapeString(this.messageUtil.getStartText(node, 1)), (Object)StatusDetail.getStatusDetail((AstNode)node).getText()) : this.messageBuilder.bind(ProblemMessages.Syntax_StringNotClosed_message, (Object)this.valueFormatter.escapeString(this.messageUtil.getStartText(node, 1)), (Object)node.getOperator((int)0).text), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 69968: {
                        this.handleTextInvalid(node, code);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    @Override
    public void visit(NumberConst node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFFF) {
                    case 69941: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Number_HexDigitMissing_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 69942: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Number_HexFloatExpMissing_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 69943: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_Number_ExpDigitMissing_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 4417: {
                        this.addProblem(1, code, this.messageBuilder.bind(ProblemMessages.Syntax_Number_NonIntWithLLiteral_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 4418: {
                        this.addProblem(1, code, this.messageBuilder.bind(ProblemMessages.Syntax_Number_IntWithDecPoint_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    @Override
    public void visit(NullConst node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Symbol node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                switch (code & 0xFFFF0) {
                    case 70640: {
                        this.addProblem(2, code, ProblemMessages.Syntax_SymbolMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 70544: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ElementnameMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 69920: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_QuotedSymbolNotClosed_message, (Object)this.valueFormatter.escapeString(this.messageUtil.getStartText(node, 1))), node.getEndOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 69968: {
                        this.handleTextInvalid(node, code);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                this.handleCommonCodes(node, code);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        int code = node.getStatusCode() & 0xFFFFFF;
        if (this.requiredCheck(code)) {
            try {
                block1 : switch (code & 0xFFFF0) {
                    case 70032: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_TokenUnknown_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset(), node.getEndOffset());
                        break;
                    }
                    case 70432: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprBeforeOpMissing_message, this.extStartOffset(node.getStartOffset()), node.getEndOffset() + 1);
                        break;
                    }
                    case 70448: {
                        this.addProblem(2, code, this.messageBuilder.bind(ProblemMessages.Syntax_ExprAfterOpMissing_message, (Object)this.messageUtil.getFullText(node)), node.getStartOffset() - 1, this.extEndOffset(node.getEndOffset()));
                        break;
                    }
                    case 70576: {
                        switch (code & 0xF) {
                            case 8: {
                                this.addProblem(2, code, ProblemMessages.Syntax_FCallAfterPipeMissing_message, node.getStartOffset() - 1, this.extEndOffset(node.getEndOffset()));
                                break block1;
                            }
                        }
                        this.handleUnknownCodes(node);
                        break;
                    }
                    case 70464: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprAsConditionMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 70480: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprAsForSequenceMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 70496: {
                        String message;
                        switch (code & 0xF) {
                            case 1: {
                                message = ProblemMessages.Syntax_ExprAsThenBodyMissing_message;
                                break;
                            }
                            case 2: {
                                message = ProblemMessages.Syntax_ExprAsElseBodyMissing_message;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                message = ProblemMessages.Syntax_ExprAsLoopBodyMissing_message;
                                break;
                            }
                            case 6: {
                                message = ProblemMessages.Syntax_ExprAsFdefBodyMissing_message;
                                break;
                            }
                            default: {
                                this.handleUnknownCodes(node);
                                break block1;
                            }
                        }
                        if (node.getLength() > 0) {
                            this.addProblem(2, code, message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        this.addProblem(2, code, message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 70512: {
                        this.addProblem(2, code, ProblemMessages.Syntax_ExprInGroupMissing_message, node.getStartOffset() - 1, node.getEndOffset() + 1);
                        break;
                    }
                    case 70528: {
                        if ((code & 0xF) == 6) {
                            this.addProblem(2, code, ProblemMessages.Syntax_ExprAsFdefArgDefaultMissing_message, node.getStartOffset() - 1, node.getEndOffset());
                            break;
                        }
                        this.handleUnknownCodes(node);
                        break;
                    }
                    case 70672: {
                        if (node.getChildCount() == 2) {
                            this.addProblem(2, code, ProblemMessages.Syntax_OperatorMissing_message, node.getChild(0).getEndOffset() - 1, node.getChild(1).getStartOffset() + 1);
                            break;
                        }
                        this.handleUnknownCodes(node);
                        break;
                    }
                    default: {
                        this.handleCommonCodes(node, code);
                        break;
                    }
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
        node.acceptInRChildren(this);
    }
}

