/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateCategoryConfiguration;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateContribution;
import org.eclipse.text.templates.ContextTypeRegistry;

public class TemplateCategory {
    private final String id;
    private final ImageDescriptor image;
    private final String label;
    private final ImageDescriptor itemImage;
    private ITemplateCategoryConfiguration configuration;
    private ITemplateContribution templateContribution;
    private ContextTypeRegistry contextTypeRegistry;
    private boolean defaultPrefCheck;
    private @Nullable Set<String> templateNames;

    public TemplateCategory(String id, ImageDescriptor image, String label, ImageDescriptor itemImage, ITemplateCategoryConfiguration configuration) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.id = id;
        this.image = image;
        this.label = label;
        this.itemImage = itemImage;
        this.configuration = configuration;
    }

    TemplateCategory(String id, ImageDescriptor image, String label, ImageDescriptor itemImage) {
        this.id = id;
        this.image = image;
        this.label = label;
        this.itemImage = itemImage;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public @Nullable ImageDescriptor getImage() {
        return this.image;
    }

    public @Nullable ImageDescriptor getItemImage() {
        return this.itemImage;
    }

    void setConfiguration(ITemplateCategoryConfiguration configuration) {
        this.configuration = configuration;
    }

    ITemplateCategoryConfiguration getConfiguration() {
        return this.configuration;
    }

    boolean isTemplateLoaded() {
        return this.templateContribution != null;
    }

    ITemplateContribution getTemplateContrib(boolean activate) {
        if (activate && this.templateContribution == null) {
            this.templateContribution = this.getConfiguration().getTemplates();
        }
        return this.templateContribution;
    }

    Preference<String> getDefaultPref() {
        return this.getConfiguration().getDefaultPref();
    }

    ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = this.getConfiguration().getContextTypeRegistry();
        }
        return this.contextTypeRegistry;
    }

    boolean initNames() {
        if (this.templateNames == null) {
            this.templateNames = new HashSet<String>();
            return true;
        }
        return false;
    }

    void clearNames() {
        this.templateNames = null;
    }

    void addName(String name) {
        this.templateNames.add(name);
    }

    boolean hasName(String name) {
        return this.templateNames.contains(name);
    }

    public String toString() {
        return this.id;
    }
}

