/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.util.TextLineInformationCreator;

@NonNullByDefault
public class SourceContent
extends BasicTextRegion
implements TextRegion {
    private static final TextLineInformationCreator LINES_CREATOR = new TextLineInformationCreator();
    private final long stamp;
    private final String string;
    private volatile @Nullable TextLineInformation stringLines;

    public SourceContent(long stamp, String text, int startOffset) {
        super(startOffset, startOffset + text.length());
        this.stamp = stamp;
        this.string = text;
    }

    public SourceContent(long stamp, String text) {
        this(stamp, text, 0);
    }

    public final long getStamp() {
        return this.stamp;
    }

    public final String getString() {
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextLineInformation getStringLines() {
        TextLineInformation lines = this.stringLines;
        if (lines == null) {
            TextLineInformationCreator textLineInformationCreator = LINES_CREATOR;
            synchronized (textLineInformationCreator) {
                lines = this.stringLines;
                if (lines == null) {
                    lines = LINES_CREATOR.create(this.string);
                }
            }
        }
        return lines;
    }

    public final String getString(int startOffset, int endOffset) {
        int textStartOffset = this.getStartOffset();
        return this.string.substring(startOffset - textStartOffset, endOffset - textStartOffset);
    }

    public final String getString(TextRegion region) {
        int textStartOffset = this.getStartOffset();
        return this.string.substring(region.getStartOffset() - textStartOffset, region.getEndOffset() - textStartOffset);
    }

    public final void appendStringTo(StringBuilder sb, int startOffset, int endOffset) {
        int textStartOffset = this.getStartOffset();
        sb.append(this.string, startOffset - textStartOffset, endOffset - textStartOffset);
    }

    public final void appendStringTo(StringBuilder sb, TextRegion region) {
        int textStartOffset = this.getStartOffset();
        sb.append(this.string, region.getStartOffset() - textStartOffset, region.getEndOffset() - textStartOffset);
    }

    public final char getChar(int offset) {
        return this.string.charAt(offset - this.getStartOffset());
    }

    public String toString() {
        return this.getString();
    }
}

