/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.docmlet.base.ui.processing.DocumentRule;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IProgressConstants;

@NonNullByDefault
public class DocProcessingToolJob
extends Job {
    private final DocProcessingToolProcess toolProcess;

    public DocProcessingToolJob(DocProcessingToolProcess toolProcess) {
        super(toolProcess.getLabel());
        this.setUser(false);
        this.setPriority(40);
        this.setRule(new DocumentRule(toolProcess.getConfig().getSourceFile()));
        this.toolProcess = toolProcess;
        Image image = toolProcess.getImage();
        if (image != null) {
            this.setProperty(IProgressConstants.ICON_PROPERTY, ImageDescriptor.createFromImage((Image)image));
        }
    }

    protected IStatus run(final IProgressMonitor monitor) {
        Thread thread = new Thread("DocProcessingWorker-" + this.toolProcess.getLabel()){

            @Override
            public void run() {
                DocProcessingToolJob.this.toolProcess.run(monitor);
            }
        };
        thread.setDaemon(true);
        thread.start();
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return this.toolProcess.getStatus();
    }

    protected void canceling() {
        try {
            this.toolProcess.terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }
}

