/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRExceptionBreakpoint;

public class RExceptionBreakpoint
extends RBreakpoint
implements IRExceptionBreakpoint {
    public static final String R_EXCEPTION_BREAKPOINT_MARKER_TYPE = "org.eclipse.statet.r.resourceMarkers.RExceptionBreakpoint";
    public static final String EXCEPTION_ID_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ExceptionIdAttribute";

    public RExceptionBreakpoint(final IResource resource, String exceptionId, final boolean temporary) throws DebugException {
        final HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.id", this.getModelIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
        attributes.put(EXCEPTION_ID_MARKER_ATTR, exceptionId);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RExceptionBreakpoint.this.setMarker(resource.createMarker(RExceptionBreakpoint.R_EXCEPTION_BREAKPOINT_MARKER_TYPE));
                RExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                RExceptionBreakpoint.this.register(!temporary);
                if (temporary) {
                    RExceptionBreakpoint.this.setPersisted(false);
                }
            }
        };
        this.run(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), wr);
    }

    public RExceptionBreakpoint() {
    }

    @Override
    public String getBreakpointType() {
        return "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint";
    }

    @Override
    public String getExceptionId() throws DebugException {
        return this.ensureMarker().getAttribute(EXCEPTION_ID_MARKER_ATTR, null);
    }
}

