/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi.server;

import java.io.File;
import java.io.PrintStream;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.internal.rj.servi.server.RServiBackend;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.MainCmdC2SList;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCmdS2CList;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.srv.RMIServerControl;
import org.eclipse.statet.rj.server.srv.engine.SrvEngine;
import org.eclipse.statet.rj.server.srv.engine.SrvEngineServer;
import org.eclipse.statet.rj.server.srvext.Client;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.srvext.ServerRuntimePlugin;
import org.eclipse.statet.rj.server.srvext.auth.NoAuthMethod;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.servi.node.RServiNode;

public class NodeServer
extends SrvEngineServer {
    private boolean isConsoleEnabled;
    private final ServerAuthMethod rserviAuthMethod;
    private final Client consoleMockupClient;
    private @Nullable ConsoleMockup consoleMockup;
    private String currentClientLabel;
    private Backend currentClientBackend;
    private RServiBackend currentClientExp;
    private final Object serviRunLock = new Object();
    private String resetCommand;

    public NodeServer(RMIServerControl control) {
        super(control, (ServerAuthMethod)new NoAuthMethod("<internal>"));
        this.rserviAuthMethod = new NoAuthMethod("<internal>");
        this.consoleMockupClient = new Client("-", "dummy", 0);
    }

    public boolean getConfigUnbindOnStartup() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ServerRuntimePlugin runtimePlugin) throws Exception {
        super.start(runtimePlugin);
        this.resetCommand = "{rm(list= ls(all.names= TRUE));gc();.rj.getTmp<-function(o){x<-get(o,pos=.GlobalEnv);rm(list=o,pos=.GlobalEnv);x};.rj.wd<-\"" + this.workingDirectory.replace("\\", "\\\\") + "\";" + "setwd(.rj.wd);" + "graphics.off();" + "}";
        RjsComConfig.setServerPathResolver((RjsComConfig.PathResolver)this);
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        properties.put("args", new String[0]);
        this.srvEngine.start(this.consoleMockupClient, properties);
        try {
            Object object = this.serviRunLock;
            synchronized (object) {
                LOGGER.log(Level.FINE, "Initializing R node: Loading R package 'rj'...");
                this.runServerLoopCommand(null, new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, "library(rj)", null, null, null));
                LOGGER.log(Level.FINE, "Initializing R node: Preparing R workspace for first client...");
                this.runServerLoopCommand(null, new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, this.resetCommand, null, null, null));
            }
        }
        catch (Exception e) {
            throw new RjException("An error occurred while preparing initially the workspace.", (Throwable)e);
        }
        LOGGER.log(Level.FINE, "Initializing R node: R engine started and initialized.");
    }

    protected ServerAuthMethod getAuthMethod(String command) {
        if (command.startsWith("rservi")) {
            return this.rserviAuthMethod;
        }
        return super.getAuthMethod(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String command, Map<String, ? extends Object> properties, ServerLogin login) throws RemoteException, LoginException {
        if (command.equals("console.start")) {
            throw new UnsupportedOperationException();
        }
        if (command.equals("console.connect")) {
            SrvEngine srvEngine = this.srvEngine;
            synchronized (srvEngine) {
                if (!this.isConsoleEnabled) {
                    throw new RemoteException("Console is not enabled.");
                }
                Client client = this.connectClient(command, login);
                return this.srvEngine.connect(client, properties);
            }
        }
        if (command.equals("rservi.nodecontrol")) {
            Client client = this.connectClient(command, login);
            Node node = new Node();
            RServiNode exported = (RServiNode)this.control.exportObject((Remote)node);
            return exported;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RServiBackend bindClient(String client) throws RemoteException {
        Client client2 = this.serverClient;
        synchronized (client2) {
            if (this.currentClientBackend != null) {
                throw new IllegalStateException();
            }
            Backend backend = new Backend();
            RServiBackend export = (RServiBackend)this.control.exportObject((Remote)backend);
            this.currentClientLabel = client;
            this.currentClientBackend = backend;
            this.currentClientExp = export;
            SrvEngineServer.addClient((Remote)export);
            return export;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindClient() throws RemoteException {
        Client client = this.serverClient;
        synchronized (client) {
            Backend previous = this.currentClientBackend;
            if (previous != null) {
                SrvEngineServer.removeClient((Remote)this.currentClientExp);
                this.currentClientLabel = null;
                this.currentClientBackend = null;
                this.currentClientExp = null;
                UnicastRemoteObject.unexportObject(previous, true);
                try {
                    Object object = this.serviRunLock;
                    synchronized (object) {
                        this.runServerLoopCommand(null, new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, this.resetCommand, null, null, null));
                        ServerUtils.cleanDir((File)new File(this.workingDirectory), (String)"out.log");
                    }
                }
                catch (Exception e) {
                    throw new RemoteException("An error occurred while resetting the workspace.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.control.checkCleanup();
        try {
            LOGGER.log(Level.FINE, "Shutting down R node: Unbind client...");
            this.unbindClient();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "An error occurred when unbinding the client for shutdown.", e);
        }
        ConsoleMockup consoleMockup = this.consoleMockup;
        if (consoleMockup != null) {
            consoleMockup.aboutToStop();
        }
        try {
            LOGGER.log(Level.FINE, "Shutting down R node: Exit R engine...");
            Object object = this.serviRunLock;
            synchronized (object) {
                this.runServerLoopCommand(null, new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, "base::q(\"no\")", null, null, null));
            }
        }
        catch (SrvEngineServer.RjExitException rjExitException) {
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "An error occurred when exiting the R engine for shutdown.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Map<String, ? extends Object> properties, Object caller) throws RemoteException {
        Object object = this.serviRunLock;
        synchronized (object) {
            if (caller != null && this.currentClientBackend != caller) {
                throw new IllegalAccessError();
            }
            this.srvEngine.setProperties(this.serverClient, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RjsComObject runMainLoop(RjsComObject com, Object caller) throws RemoteException {
        Object object = this.serviRunLock;
        synchronized (object) {
            if (caller != null && this.currentClientBackend != caller) {
                throw new IllegalAccessError();
            }
        }
        return super.runMainLoop(com, caller);
    }

    private RjsComObject runAsync(RjsComObject com, Backend backend) throws RemoteException {
        if (backend != null && this.currentClientBackend != backend) {
            throw new IllegalAccessError();
        }
        return this.srvEngine.runAsync(this.serverClient, com);
    }

    class Backend
    implements RServiBackend {
        Backend() {
        }

        public Server getPublic() throws RemoteException {
            return null;
        }

        public Map<String, Object> getPlatformData() {
            return NodeServer.this.srvEngine.getPlatformData();
        }

        public void setProperties(Map<String, ? extends Object> properties) throws RemoteException {
            NodeServer.this.setProperties(properties, this);
        }

        public boolean interrupt() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public void disconnect() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public RjsComObject runMainLoop(RjsComObject com) throws RemoteException {
            return NodeServer.this.runMainLoop(com, this);
        }

        public RjsComObject runAsync(RjsComObject com) throws RemoteException {
            return NodeServer.this.runAsync(com, this);
        }

        public boolean isClosed() throws RemoteException {
            return NodeServer.this.currentClientBackend != this;
        }
    }

    class ConsoleMockup
    extends Thread {
        private final Client client;
        private final PrintStream out;
        private final MainCmdC2SList c2sList = new MainCmdC2SList();
        private int waitMillis = 5000;

        ConsoleMockup() {
            this.setName("R Console");
            this.setDaemon(true);
            this.setPriority(4);
            this.client = NodeServer.this.consoleMockupClient;
            this.out = System.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SrvEngine srvEngine = NodeServer.this.srvEngine;
                synchronized (srvEngine) {
                    if (NodeServer.this.isConsoleEnabled || NodeServer.this.consoleMockup != null) {
                        return;
                    }
                    NodeServer.this.consoleMockup = this;
                    NodeServer.this.srvEngine.connect(this.client, new HashMap());
                }
                MainCmdC2SList sendCom = null;
                boolean error = false;
                while (true) {
                    block37: {
                        try {
                            if (sendCom == null) {
                                this.c2sList.setObjects(null);
                                sendCom = this.c2sList;
                            }
                            RjsComObject receivedCom = NodeServer.this.srvEngine.runMainLoop(this.client, (RjsComObject)sendCom);
                            sendCom = null;
                            error = false;
                            if (receivedCom == null) break block37;
                            switch (receivedCom.getComType()) {
                                case 2: {
                                    sendCom = RjsStatus.OK_STATUS;
                                    break;
                                }
                                case 3: {
                                    MainCmdItem item = ((MainCmdS2CList)receivedCom).getItems();
                                    while (item != null) {
                                        switch (item.getCmdType()) {
                                            case 2: {
                                                this.out.println("R-OUT (" + item.getOp() + "): " + item.getDataText());
                                                break;
                                            }
                                            case 1: {
                                                this.out.println("R-PROMPT: " + item.getDataText());
                                            }
                                        }
                                        MainCmdItem tmp = item;
                                        item = item.next;
                                        tmp.next = null;
                                    }
                                    break;
                                }
                                case 1: {
                                    switch (((RjsStatus)receivedCom).getCode()) {
                                        case 24: {
                                            throw new ConnectException("");
                                        }
                                        case 17: 
                                        case 25: 
                                        case 26: {
                                            SrvEngine srvEngine2 = NodeServer.this.srvEngine;
                                            synchronized (srvEngine2) {
                                                if (NodeServer.this.consoleMockup == this) {
                                                    NodeServer.this.consoleMockup = null;
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                        catch (ConnectException e) {
                            SrvEngine srvEngine3 = NodeServer.this.srvEngine;
                            synchronized (srvEngine3) {
                                if (NodeServer.this.isConsoleEnabled) {
                                    if (NodeServer.this.consoleMockup == this) {
                                        NodeServer.this.consoleMockup = null;
                                    }
                                    return;
                                }
                                NodeServer.this.srvEngine.connect(this.client, new HashMap());
                            }
                        }
                        catch (Exception e) {
                            if (error) {
                                throw e;
                            }
                            LOGGER.log(Level.SEVERE, "An error occurred when running dummy R REPL. Trying to continue REPL.", e);
                            error = true;
                        }
                    }
                    if (sendCom != null) continue;
                    try {
                        ConsoleMockup.sleep(this.waitMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred when running dummy R REPL. Stopping REPL.", e);
                return;
            }
        }

        public void aboutToStop() {
            this.waitMillis = 100;
            this.interrupt();
        }
    }

    class Node
    implements RServiNode {
        Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setConsole(String authConfig) throws RemoteException, RjException {
            boolean enabled;
            SrvEngine srvEngine = NodeServer.this.srvEngine;
            synchronized (srvEngine) {
                Client currentClient = NodeServer.this.srvEngine.getCurrentClient();
                if (currentClient != null) {
                    NodeServer.this.srvEngine.disconnect(currentClient);
                }
                if (authConfig != null) {
                    NodeServer.this.authMethod = NodeServer.this.control.createServerAuth(authConfig);
                    NodeServer.this.isConsoleEnabled = true;
                    enabled = true;
                } else {
                    NodeServer.this.authMethod = (ServerAuthMethod)new NoAuthMethod("<internal>");
                    NodeServer.this.isConsoleEnabled = false;
                    enabled = false;
                    if (NodeServer.this.consoleMockup == null) {
                        new ConsoleMockup().start();
                    }
                }
            }
            return enabled;
        }

        @Override
        public int getEvalTime() throws RemoteException {
            return 0;
        }

        @Override
        public void ping() throws RemoteException {
        }

        @Override
        public String getPoolHost() throws RemoteException {
            try {
                return RemoteServer.getClientHost();
            }
            catch (ServerNotActiveException e) {
                return "<internal>";
            }
        }

        @Override
        public void runSnippet(String code) throws RemoteException, RjException {
            NodeServer.this.runServerLoopCommand(null, new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, code, null, null, null));
        }

        @Override
        public RServiBackend bindClient(String client) throws RemoteException {
            return NodeServer.this.bindClient(client);
        }

        @Override
        public void unbindClient() throws RemoteException {
            NodeServer.this.unbindClient();
        }

        @Override
        public void shutdown() throws RemoteException {
            NodeServer.this.shutdown();
        }
    }
}

