/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.util.List;
import org.eclipse.statet.internal.rj.eclient.graphics.CircleElement;
import org.eclipse.statet.internal.rj.eclient.graphics.ClipSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.ColorSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.FillSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.FontSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.GraphicInitialization;
import org.eclipse.statet.internal.rj.eclient.graphics.LineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.LineSetting;
import org.eclipse.statet.internal.rj.eclient.graphics.PathElement;
import org.eclipse.statet.internal.rj.eclient.graphics.PolygonElement;
import org.eclipse.statet.internal.rj.eclient.graphics.PolylineElement;
import org.eclipse.statet.internal.rj.eclient.graphics.RasterElement;
import org.eclipse.statet.internal.rj.eclient.graphics.RectElement;
import org.eclipse.statet.internal.rj.eclient.graphics.TextElement;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicInstruction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class DefaultGCRenderer {
    private double scale = 1.0;
    private final LineAttributes lineAttributes = new LineAttributes(1.0f);
    private Color lineColor;
    private int lineAlpha;
    private Color fillColor;
    private int fillAlpha;
    private final double[] fontProperties = new double[1];

    private static int swtLineJoin2Cap(int join) {
        return join == 2 ? 2 : 1;
    }

    public void clear(double scale) {
        this.scale = scale;
        this.lineColor = null;
        this.lineAlpha = 255;
        this.fillColor = null;
        this.fillAlpha = 255;
        this.lineAttributes.style = 1;
        this.lineAttributes.width = (float)scale;
        this.lineAttributes.cap = 2;
        this.lineAttributes.join = 2;
        this.lineAttributes.miterLimit = (float)(10.0 * scale);
    }

    public void paint(GC gc, List<? extends ERGraphicInstruction> instructions) {
        Transform defaultTransform = null;
        Transform tempTransform = new Transform(gc.getDevice());
        Rectangle tempRect = new Rectangle(0, 0, 0, 0);
        double scale = this.scale;
        int currentAlpha = -1;
        int currentInterpolation = -1;
        int currentFillRule = -1;
        Color lineColor = this.lineColor;
        int lineAlpha = this.lineAlpha;
        Color fillColor = this.fillColor;
        int fillAlpha = this.fillAlpha;
        try {
            Rectangle bounds = gc.getClipping();
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            gc.setLineAttributes(this.lineAttributes);
            gc.setTransform(defaultTransform);
            gc.setAlpha(currentAlpha);
            if (this.lineColor != null) {
                gc.setForeground(this.lineColor);
            }
            if (this.fillColor != null) {
                gc.setBackground(this.fillColor);
            }
            block23: for (ERGraphicInstruction eRGraphicInstruction : instructions) {
                block1 : switch (eRGraphicInstruction.getInstructionType()) {
                    case 0: {
                        GraphicInitialization init = (GraphicInitialization)eRGraphicInstruction;
                        gc.setBackground(init.swtCanvasColor);
                        currentAlpha = 255;
                        gc.setAlpha(255);
                        tempRect.x = 0;
                        tempRect.y = 0;
                        tempRect.width = (int)(init.width * scale + 0.5);
                        tempRect.height = (int)(init.height * scale + 0.5);
                        tempRect.intersect(bounds);
                        gc.setClipping(tempRect);
                        gc.fillRectangle(tempRect);
                        break;
                    }
                    case 1: {
                        ERGraphicInstruction setting = (ClipSetting)eRGraphicInstruction;
                        tempRect.x = (int)(((ClipSetting)setting).x0 * scale + 1.5);
                        tempRect.y = (int)(((ClipSetting)setting).y0 * scale + 1.5);
                        tempRect.width = (int)(((ClipSetting)setting).x1 * scale + 0.5) - tempRect.x;
                        tempRect.height = (int)(((ClipSetting)setting).y1 * scale + 0.5) - tempRect.y;
                        tempRect.intersect(bounds);
                        gc.setClipping(tempRect);
                        break;
                    }
                    case 2: {
                        ERGraphicInstruction setting = (ColorSetting)eRGraphicInstruction;
                        lineAlpha = setting.getAlpha();
                        lineColor = ((ColorSetting)setting).swtColor;
                        gc.setForeground(lineColor);
                        break;
                    }
                    case 3: {
                        ERGraphicInstruction setting = (FillSetting)eRGraphicInstruction;
                        fillAlpha = setting.getAlpha();
                        fillColor = ((FillSetting)setting).swtColor;
                        gc.setBackground(fillColor);
                        break;
                    }
                    case 4: {
                        ERGraphicInstruction setting = (LineSetting)eRGraphicInstruction;
                        this.lineAttributes.cap = ((LineSetting)setting).swtCap();
                        this.lineAttributes.join = ((LineSetting)setting).swtJoin();
                        this.lineAttributes.miterLimit = (float)((double)((LineSetting)setting).joinMiterLimit * scale);
                        switch (((LineSetting)setting).type) {
                            case 0: {
                                this.lineAttributes.style = 1;
                                this.lineAttributes.width = (float)((double)((LineSetting)setting).width * scale);
                                gc.setLineAttributes(this.lineAttributes);
                                break block1;
                            }
                            case -1: {
                                this.lineAttributes.style = 1;
                                this.lineAttributes.width = 0.0f;
                                gc.setLineAttributes(this.lineAttributes);
                                break block1;
                            }
                        }
                        this.lineAttributes.style = 1;
                        this.lineAttributes.width = (float)((double)((LineSetting)setting).width * scale);
                        gc.setLineAttributes(this.lineAttributes);
                        gc.setLineDash(((LineSetting)setting).swtDashes());
                        break;
                    }
                    case 5: {
                        ERGraphicInstruction setting = (FontSetting)eRGraphicInstruction;
                        gc.setFont(((FontSetting)setting).swtFont);
                        this.fontProperties[0] = ((FontSetting)setting).swtProperties[0];
                        break;
                    }
                    case 6: {
                        ERGraphicInstruction element = (LineElement)eRGraphicInstruction;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawLine((int)(element.x0 * scale + 0.5), (int)(element.y0 * scale + 0.5), (int)(element.x1 * scale + 0.5), (int)(element.y1 * scale + 0.5));
                        break;
                    }
                    case 7: {
                        int iy0;
                        int ih;
                        int ix0;
                        int iw;
                        ERGraphicInstruction element = (RectElement)eRGraphicInstruction;
                        if (((RectElement)element).x1 - ((RectElement)element).x0 < 5.1111 && ((RectElement)element).y1 - ((RectElement)element).y0 < 5.1111) {
                            iw = (int)((((RectElement)element).x1 - ((RectElement)element).x0) * scale + 0.5);
                            ix0 = lineAlpha == 0 ? (int)(((((RectElement)element).x0 + ((RectElement)element).x1) * scale - (double)iw) / 2.0 + 0.5) : (int)(((((RectElement)element).x0 + ((RectElement)element).x1) * scale - (double)(iw + 1)) / 2.0 + 0.5);
                            ih = (int)((((RectElement)element).y1 - ((RectElement)element).y0) * scale + 0.5);
                            iy0 = lineAlpha == 0 ? (int)(((((RectElement)element).y0 + ((RectElement)element).y1) * scale - (double)ih) / 2.0 + 0.5) : (int)(((((RectElement)element).y0 + ((RectElement)element).y1) * scale - (double)(ih + 1)) / 2.0 + 0.5);
                        } else {
                            ix0 = (int)(((RectElement)element).x0 * scale + 0.5);
                            iw = lineAlpha == 0 ? (int)(((RectElement)element).x1 * scale + 0.5) - ix0 + 1 : (int)(((RectElement)element).x1 * scale + 0.5) - ix0;
                            iy0 = (int)(((RectElement)element).y0 * scale + 0.5);
                            ih = lineAlpha == 0 ? (int)(((RectElement)element).y1 * scale + 0.5) - iy0 + 1 : (int)(((RectElement)element).y1 * scale + 0.5) - iy0;
                        }
                        if (iw == 0 || ih == 0) {
                            if (lineAlpha == 0) continue block23;
                            if (lineAlpha != currentAlpha) {
                                currentAlpha = lineAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.setLineCap(DefaultGCRenderer.swtLineJoin2Cap(this.lineAttributes.join));
                            gc.drawLine(ix0, iy0, ix0 + iw, iy0 + ih);
                            gc.setLineCap(this.lineAttributes.cap);
                            break;
                        }
                        if (fillAlpha != 0) {
                            if (lineAlpha == 0) {
                                if (fillAlpha != currentAlpha) {
                                    currentAlpha = fillAlpha;
                                    gc.setAlpha(currentAlpha);
                                }
                                gc.fillRectangle(ix0, iy0, iw, ih);
                                break;
                            }
                            if (iw > 1 && ih > 1) {
                                if (fillAlpha != currentAlpha) {
                                    currentAlpha = fillAlpha;
                                    gc.setAlpha(currentAlpha);
                                }
                                gc.fillRectangle(ix0 + 1, iy0 + 1, iw - 1, ih - 1);
                            }
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawRectangle(ix0, iy0, iw, ih);
                        break;
                    }
                    case 8: {
                        ERGraphicInstruction element = (PolylineElement)eRGraphicInstruction;
                        int n = ((PolylineElement)element).x.length;
                        int[] icoord = new int[n * 2];
                        int i = 0;
                        int j = 0;
                        while (j < n) {
                            icoord[i++] = (int)(((PolylineElement)element).x[j] * scale + 0.5);
                            icoord[i++] = (int)(((PolylineElement)element).y[j] * scale + 0.5);
                            ++j;
                        }
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawPolyline(icoord);
                        break;
                    }
                    case 9: {
                        ERGraphicInstruction element = (PolygonElement)eRGraphicInstruction;
                        int n = ((PolygonElement)element).x.length;
                        int[] icoord = new int[n * 2];
                        int i = 0;
                        int j = 0;
                        while (j < n) {
                            icoord[i++] = (int)(((PolygonElement)element).x[j] * scale + 0.5);
                            icoord[i++] = (int)(((PolygonElement)element).y[j] * scale + 0.5);
                            ++j;
                        }
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            if (1 != currentFillRule) {
                                currentFillRule = 1;
                                gc.setFillRule(1);
                            }
                            gc.fillPolygon(icoord);
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawPolygon(icoord);
                        break;
                    }
                    case 13: {
                        int fillRule;
                        ERGraphicInstruction element = (PathElement)eRGraphicInstruction;
                        int n = fillRule = (((PathElement)element).mode & 3) == 1 ? 2 : 1;
                        if (fillRule != currentFillRule) {
                            currentFillRule = fillRule;
                            gc.setFillRule(currentFillRule);
                        }
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.fillPath(((PathElement)element).swtPath);
                        }
                        if (lineAlpha == 0) break;
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawPath(((PathElement)element).swtPath);
                        break;
                    }
                    case 10: {
                        ERGraphicInstruction element = (CircleElement)eRGraphicInstruction;
                        int id = (int)(((CircleElement)element).r * 2.0 + 0.5);
                        tempTransform.setElements(1.0f, 0.0f, 0.0f, 1.0f, (float)(((CircleElement)element).x - (double)id / 2.0), (float)(((CircleElement)element).y - (double)id / 2.0));
                        gc.setTransform(tempTransform);
                        if (fillAlpha != 0) {
                            if (fillAlpha != currentAlpha) {
                                currentAlpha = fillAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.fillOval(1, 1, id - 1, id - 1);
                        }
                        if (lineAlpha != 0) {
                            if (lineAlpha != currentAlpha) {
                                currentAlpha = lineAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.drawOval(0, 0, id, id);
                        }
                        gc.setTransform(defaultTransform);
                        break;
                    }
                    case 11: {
                        ERGraphicInstruction element = (TextElement)eRGraphicInstruction;
                        double hShift = ((TextElement)element).horizontalAdjust != 0.0 ? ((TextElement)element).horizontalAdjust * ((TextElement)element).swtStrWidth : 0.0;
                        if (((TextElement)element).rotateDegree != 0.0) {
                            tempTransform.setElements(1.0f, 0.0f, 0.0f, 1.0f, (float)(((TextElement)element).x * scale), (float)(((TextElement)element).y * scale));
                            tempTransform.rotate((float)(-((TextElement)element).rotateDegree));
                            tempTransform.translate((float)Math.floor(1.1111 - hShift), (float)Math.floor(0.0511 - this.fontProperties[0]));
                            gc.setTransform(tempTransform);
                            if (lineAlpha != currentAlpha) {
                                currentAlpha = lineAlpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.drawString(((TextElement)element).text, 0, 0, true);
                            gc.setTransform(defaultTransform);
                            break;
                        }
                        if (lineAlpha != currentAlpha) {
                            currentAlpha = lineAlpha;
                            gc.setAlpha(currentAlpha);
                        }
                        gc.drawString(((TextElement)element).text, (int)Math.floor(1.1111 + ((TextElement)element).x - hShift), (int)Math.floor(0.6111 + ((TextElement)element).y - this.fontProperties[0]), true);
                        break;
                    }
                    case 12: {
                        int ih;
                        int iy;
                        int iw;
                        int ix;
                        int interpolation;
                        ERGraphicInstruction element = (RasterElement)eRGraphicInstruction;
                        if (255 != currentAlpha) {
                            currentAlpha = 255;
                            gc.setAlpha(255);
                        }
                        int n = interpolation = ((RasterElement)element).interpolate ? 1 : 0;
                        if (interpolation != currentInterpolation) {
                            currentInterpolation = interpolation;
                            gc.setInterpolation(currentInterpolation);
                        }
                        if (((RasterElement)element).width >= 0.0) {
                            ix = (int)Math.floor(((RasterElement)element).x * scale + 0.5);
                            iw = (int)(((RasterElement)element).width * scale + 0.5);
                        } else {
                            ix = (int)Math.floor((((RasterElement)element).x + ((RasterElement)element).height) * scale + 0.5);
                            iw = (int)(-((RasterElement)element).width * scale + 0.5);
                        }
                        if (((RasterElement)element).height >= 0.0) {
                            iy = (int)Math.floor(((RasterElement)element).y * scale + 0.5);
                            ih = (int)(((RasterElement)element).height * scale + 0.5);
                        } else {
                            iy = (int)Math.floor((((RasterElement)element).y + ((RasterElement)element).height) * scale + 0.5);
                            ih = (int)(-((RasterElement)element).height * scale + 0.5);
                        }
                        if (((RasterElement)element).rotateDegree != 0.0) {
                            tempTransform.setElements(1.0f, 0.0f, 0.0f, 1.0f, (float)(((RasterElement)element).x * scale), (float)(((RasterElement)element).y * scale));
                            tempTransform.rotate(-((float)((RasterElement)element).rotateDegree));
                            if (((RasterElement)element).width < 0.0 || ((RasterElement)element).height < 0.0) {
                                tempTransform.translate((float)(((RasterElement)element).width < 0.0 ? -iw : 0), (float)(((RasterElement)element).height < 0.0 ? -ih : 0));
                            }
                            gc.setTransform(tempTransform);
                            gc.drawImage(((RasterElement)element).swtImage, 0, 0, ((RasterElement)element).imgWidth, ((RasterElement)element).imgHeight, 0, 0, iw, ih);
                            gc.setTransform(defaultTransform);
                            break;
                        }
                        gc.drawImage(((RasterElement)element).swtImage, 0, 0, ((RasterElement)element).imgWidth, ((RasterElement)element).imgHeight, ix, iy, iw, ih);
                    }
                }
            }
            this.lineColor = lineColor;
            this.lineAlpha = lineAlpha;
            this.fillColor = fillColor;
            this.fillAlpha = fillAlpha;
        }
        finally {
            tempTransform.dispose();
        }
    }
}

