/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class XMIURIChangeDetectorDelegate
implements IURIChangeDetectorDelegate {
    @Override
    public List<URIChangeNotification> detectChangedURIs(Notification notification) {
        ArrayList<URIChangeNotification> uriChangeNotifications = new ArrayList<URIChangeNotification>();
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            uriChangeNotifications.add(new URIChangeNotification(eObject, EcoreResourceUtil.getURI((EObject)eObject)));
        }
        return uriChangeNotifications;
    }

    @Override
    public List<URIChangeNotification> detectChangedURIs(IFile oldFile, IFile newFile) {
        TransactionalEditingDomain editingDomain;
        Resource resource;
        if (!oldFile.getFullPath().equals((Object)newFile.getFullPath()) && (resource = EcorePlatformUtil.getResource((IFile)oldFile)) != null && (editingDomain = TransactionUtil.getEditingDomain((Resource)resource)) != null) {
            try {
                return (List)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<List<URIChangeNotification>>(){

                    public void run() {
                        ArrayList<URIChangeNotification> uriChangeNotifications = new ArrayList<URIChangeNotification>();
                        TreeIterator allContents = resource.getAllContents();
                        while (allContents.hasNext()) {
                            EObject eObject = (EObject)allContents.next();
                            uriChangeNotifications.add(new URIChangeNotification(eObject, EcoreResourceUtil.getURI((EObject)eObject)));
                        }
                        this.setResult(uriChangeNotifications);
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        return Collections.emptyList();
    }
}

