/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.stress;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.options.StressOptions;
import org.eclipse.elk.core.math.KVector;

public class StressMajorization {
    private FGraph graph;
    private double[][] apsp;
    private double[][] w;
    private double desiredEdgeLength;
    private Dimension dim;
    private double epsilon;
    private int iterationLimit;
    private Multimap<FNode, FEdge> connectedEdges = LinkedListMultimap.create();

    public void initialize(FGraph fgraph) {
        if (fgraph.getNodes().size() <= 1) {
            return;
        }
        this.graph = fgraph;
        this.dim = (Dimension)((Object)this.graph.getProperty(StressOptions.DIMENSION));
        this.iterationLimit = (Integer)this.graph.getProperty(StressOptions.ITERATION_LIMIT);
        this.epsilon = (Double)this.graph.getProperty(StressOptions.EPSILON);
        this.desiredEdgeLength = (Double)this.graph.getProperty(StressOptions.DESIRED_EDGE_LENGTH);
        this.connectedEdges.clear();
        for (FEdge edge : this.graph.getEdges()) {
            this.connectedEdges.put((Object)edge.getSource(), (Object)edge);
            this.connectedEdges.put((Object)edge.getTarget(), (Object)edge);
        }
        int n = this.graph.getNodes().size();
        this.apsp = new double[n][n];
        for (FNode source : this.graph.getNodes()) {
            this.dijkstra(source, this.apsp[source.id]);
        }
        this.w = new double[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double wij;
                double dij = this.apsp[i][j];
                this.w[i][j] = wij = 1.0 / (dij * dij);
                ++j;
            }
            ++i;
        }
    }

    public void execute() {
        if (this.graph.getNodes().size() <= 1) {
            return;
        }
        int count = 0;
        double prevStress = this.computeStress();
        double curStress = Double.POSITIVE_INFINITY;
        do {
            if (count > 0) {
                prevStress = curStress;
            }
            for (FNode u : this.graph.getNodes()) {
                if (((Boolean)u.getProperty(StressOptions.FIXED)).booleanValue()) continue;
                KVector newPos = this.computeNewPosition(u);
                u.getPosition().reset().add(newPos);
            }
        } while (!this.done(count++, prevStress, curStress = this.computeStress()));
    }

    private void dijkstra(FNode source, double[] dist) {
        PriorityQueue<FNode> nodes = new PriorityQueue<FNode>((n1, n2) -> Double.compare(dist[n1.id], dist[n2.id]));
        boolean[] mark = new boolean[this.graph.getNodes().size()];
        Arrays.fill(mark, false);
        dist[source.id] = 0.0;
        for (FNode n : this.graph.getNodes()) {
            if (n.id != source.id) {
                dist[n.id] = 2.147483647E9;
            }
            nodes.add(n);
        }
        while (!nodes.isEmpty()) {
            FNode u = (FNode)((Object)nodes.poll());
            mark[u.id] = true;
            for (FEdge e : this.connectedEdges.get((Object)u)) {
                double el;
                double d;
                FNode v = this.getOther(e, u);
                if (mark[v.id] || !((d = dist[u.id] + (el = e.hasProperty(StressOptions.DESIRED_EDGE_LENGTH) ? (Double)e.getProperty(StressOptions.DESIRED_EDGE_LENGTH) : this.desiredEdgeLength)) < dist[v.id])) continue;
                dist[v.id] = d;
                nodes.remove((Object)v);
                nodes.add(v);
            }
        }
    }

    private boolean done(int count, double prevStress, double curStress) {
        return prevStress == 0.0 || (prevStress - curStress) / prevStress < this.epsilon || count >= this.iterationLimit;
    }

    private double computeStress() {
        double stress = 0.0;
        List<FNode> nodes = this.graph.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            FNode u = nodes.get(i);
            int j = i + 1;
            while (j < nodes.size()) {
                FNode v = nodes.get(j);
                double eucDist = u.getPosition().distance(v.getPosition());
                double eucDisplacement = eucDist - this.apsp[u.id][v.id];
                stress += this.w[u.id][v.id] * eucDisplacement * eucDisplacement;
                ++j;
            }
            ++i;
        }
        return stress;
    }

    private KVector computeNewPosition(FNode u) {
        double weightSum = 0.0;
        double xDisp = 0.0;
        double yDisp = 0.0;
        assert (this.graph.getNodes().size() > 1);
        for (FNode v : this.graph.getNodes()) {
            if (u == v) continue;
            double wij = this.w[u.id][v.id];
            weightSum += wij;
            double eucDist = u.getPosition().distance(v.getPosition());
            if (eucDist > 0.0 && this.dim != Dimension.Y) {
                xDisp += wij * (v.getPosition().x + this.apsp[u.id][v.id] * (u.getPosition().x - v.getPosition().x) / eucDist);
            }
            if (!(eucDist > 0.0) || this.dim == Dimension.X) continue;
            yDisp += wij * (v.getPosition().y + this.apsp[u.id][v.id] * (u.getPosition().y - v.getPosition().y) / eucDist);
        }
        switch (this.dim) {
            case X: {
                return new KVector(xDisp / weightSum, u.getPosition().y);
            }
            case Y: {
                return new KVector(u.getPosition().x, yDisp / weightSum);
            }
        }
        return new KVector(xDisp / weightSum, yDisp / weightSum);
    }

    private FNode getOther(FEdge edge, FNode one) {
        if (edge.getSource() == one) {
            return edge.getTarget();
        }
        if (edge.getTarget() == one) {
            return edge.getSource();
        }
        throw new IllegalArgumentException("Node 'one' must be either source or target of edge 'edge'.");
    }

    public static enum Dimension {
        XY,
        X,
        Y;

    }
}

