/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.CompositeLayout;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;

public class DiagramLayoutCustomization {
    private static final int BORDER_NODE_ROUTING_SPACE = 10;
    private int padding = 30;

    public Insets getNodePadding(GraphicalEditPart ep) {
        Insets inSetPadding = new Insets(this.padding);
        if (ep instanceof CompartmentEditPart || ep instanceof AbstractDiagramElementContainerEditPart && ((AbstractDiagramElementContainerEditPart)ep).isRegion()) {
            inSetPadding = new Insets(0);
        } else if (ep instanceof AbstractBorderedShapeEditPart) {
            int maxWidth = -1;
            int maxHeight = -1;
            for (AbstractDiagramBorderNodeEditPart borderNode : Iterables.filter((Iterable)ep.getChildren(), AbstractDiagramBorderNodeEditPart.class)) {
                int figTopMargin = borderNode.getFigure().getBounds().width / 4;
                int figLeftMargin = borderNode.getFigure().getBounds().height / 4;
                int nbConnections = borderNode.getSourceConnections().size() + ep.getTargetConnections().size();
                if (nbConnections > 0) {
                    figLeftMargin += figLeftMargin + 10;
                    figTopMargin += figTopMargin + 10;
                }
                if (figTopMargin > maxWidth) {
                    maxWidth = figTopMargin;
                }
                if (figLeftMargin <= maxHeight) continue;
                maxHeight = figLeftMargin;
            }
            inSetPadding = new Insets(Math.max(inSetPadding.top, maxWidth), Math.max(inSetPadding.left, maxHeight), Math.max(inSetPadding.bottom, maxWidth), Math.max(inSetPadding.right, maxHeight));
        }
        return inSetPadding;
    }

    public void initializePaddingWithEditParts(Collection selectedObjects) {
        this.padding = this.findPaddingFromSelection(selectedObjects);
    }

    public void initializePaddingWithViews(Collection<View> views) {
        this.padding = this.findPaddingFromViews(views);
    }

    private int findPaddingFromViews(Collection<View> views) {
        int foundPadding = 30;
        for (View obj : views) {
            foundPadding = this.getPadding(obj);
            if (foundPadding != 30) break;
        }
        return foundPadding;
    }

    private int findPaddingFromSelection(Collection selectedObjects) {
        int foundPadding = 30;
        Collection filteredSelection = Collections2.filter((Collection)selectedObjects, (Predicate)Predicates.instanceOf(GraphicalEditPart.class));
        for (IGraphicalEditPart obj : filteredSelection) {
            foundPadding = this.getEditPartPadding(obj);
            if (foundPadding != 30) break;
        }
        return foundPadding;
    }

    private int getEditPartPadding(IGraphicalEditPart container) {
        return this.getPadding(container.getNotationView());
    }

    private int getPadding(View gmfView) {
        Layout foundLayout = DiagramLayoutCustomization.findLayoutSettings(gmfView);
        if (foundLayout instanceof CompositeLayout) {
            return ((CompositeLayout)foundLayout).getPadding();
        }
        return 30;
    }

    public static Layout findLayoutSettings(View view) {
        EObject modelElement;
        Layout foundLayout = null;
        if (view.getDiagram() != null && (modelElement = view.getDiagram().getElement()) instanceof DDiagram) {
            DDiagram vp = (DDiagram)modelElement;
            DiagramDescription desc = vp.getDescription();
            if (desc != null) {
                foundLayout = desc.getLayout();
            }
            return foundLayout;
        }
        return foundLayout;
    }
}

