/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import java.util.Map;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.tool.ToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ExecutionSemanticEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractMessageCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.CreateMessageCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.DefaultMessageCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.DestroyMessageCreationValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceMessagesRouter;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SequenceSiriusGraphicalNodeEditPolicy
extends SiriusGraphicalNodeEditPolicy {
    protected static final String DRAW2D_EDGE_LOCATION_SOURCE = "edge.absolute.location.source";

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            Point p = request.getLocation();
            this.connectionFeedback = this.createDummyConnection((Request)request);
            this.connectionFeedback.setConnectionRouter((ConnectionRouter)new SequenceMessagesRouter());
            this.connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request));
            this.feedbackHelper.setConnection(this.connectionFeedback);
            this.addFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper.update(null, p);
        }
        return this.feedbackHelper;
    }

    protected IFigure getFeedbackLayer() {
        Layer layer;
        IFigure feedbackLayer = null;
        IFigure scaledLayers = this.getLayer("Scalable Layers");
        if (scaledLayers instanceof LayeredPane && (layer = ((LayeredPane)scaledLayers).getLayer((Object)"Scaled Feedback Layer")) != null) {
            feedbackLayer = layer;
        }
        if (feedbackLayer == null) {
            feedbackLayer = super.getFeedbackLayer();
        }
        return feedbackLayer;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Command connectionCreateCommand = super.getConnectionCreateCommand(request);
        if (new RequestQuery((Request)request).isSequenceMessageCreation() && request.getLocation() != null && "connection start".equals(request.getType())) {
            ISequenceEventEditPart host = (ISequenceEventEditPart)this.getHost();
            ISequenceEvent sequenceEvent = host.getISequenceEvent();
            SequenceDiagram sequenceDiagram = sequenceEvent.getDiagram();
            Point location = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            request.getExtendedData().put(DRAW2D_EDGE_LOCATION_SOURCE, location.getCopy());
            EventEnd startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(sequenceDiagram.getSequenceDDiagram(), location.y);
            if (!sequenceEvent.canChildOccupy(null, new Range(location.y, location.y)) || ToolCommandBuilder.isStartingEventEndOfCombinedFragment((SequenceDiagram)sequenceDiagram, (EventEnd)startingEndPredecessor)) {
                connectionCreateCommand = UnexecutableCommand.INSTANCE;
            }
        }
        return connectionCreateCommand;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (request instanceof CreateConnectionViewRequest) {
            result = super.getConnectionCompleteCommand(request);
        } else {
            RequestQuery requestQuery = new RequestQuery((Request)request);
            if (!requestQuery.isSequenceMessageCreation()) {
                result = super.getConnectionCompleteCommand(request);
            } else {
                ISequenceEventEditPart host = (ISequenceEventEditPart)this.getHost();
                ISequenceEvent sequenceEvent = host.getISequenceEvent();
                SequenceDiagram sequenceDiagram = sequenceEvent.getDiagram();
                EditPart sourceEditPart = request.getSourceEditPart();
                EditPart targetEditPart = request.getTargetEditPart();
                Option sequenceEventSource = ISequenceElementAccessor.getISequenceElement((View)((View)sourceEditPart.getModel()));
                Option sequenceEventTarget = ISequenceElementAccessor.getISequenceElement((View)((View)targetEditPart.getModel()));
                Map extendedData = request.getExtendedData();
                Point firstClickLocation = (Point)extendedData.get(DRAW2D_EDGE_LOCATION_SOURCE);
                Point secondClickLocation = request.getLocation().getCopy();
                GraphicalHelper.screen2logical((Point)secondClickLocation, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                if (firstClickLocation != null && secondClickLocation != null && !ExecutionSemanticEditPolicy.isCombinedFragmentTitleRangeEdgeCreation((ISequenceElement)sequenceEvent, sequenceDiagram, firstClickLocation, secondClickLocation)) {
                    DefaultMessageCreationValidator validator = null;
                    validator = requestQuery.isCreateMessageCreation() ? new CreateMessageCreationValidator() : (requestQuery.isDestroyMessageCreation() ? new DestroyMessageCreationValidator() : new DefaultMessageCreationValidator());
                    validator.setSource((ISequenceElement)sequenceEventSource.get());
                    validator.setTarget((ISequenceElement)sequenceEventTarget.get());
                    validator.setFirstClickLocation(firstClickLocation);
                    validator.setSecondClickLocation(secondClickLocation);
                    if (request.getSourceEditPart() instanceof NoteEditPart || ((AbstractMessageCreationValidator)validator).isValid(request)) {
                        result = super.getConnectionCompleteCommand(request);
                    }
                }
            }
        }
        return result;
    }

    protected Command buildCreateEdgeCommand(CreateConnectionRequest request, EdgeTarget source, EdgeTarget target, EdgeCreationDescription edgeCreationDescription, IDiagramCommandFactoryProvider cmdFactoryProvider, EdgeLayoutData edgeLayoutData) {
        CompoundCommand result = new CompoundCommand();
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        SequenceEditPartsOperations.appendFullRefresh(host, result);
        this.addStoreLayoutDataCommand(result, edgeLayoutData);
        SequenceEditPartsOperations.buildCreateEdgeCommand(host, result, request, source, target, edgeCreationDescription, cmdFactoryProvider);
        SequenceEditPartsOperations.appendFullRefresh(host, result);
        return result;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Object result = null;
        result = request.getConnectionEditPart() instanceof SequenceMessageEditPart ? UnexecutableCommand.INSTANCE : super.getReconnectSourceCommand(request);
        return result;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Object result = null;
        result = request.getConnectionEditPart() instanceof SequenceMessageEditPart ? UnexecutableCommand.INSTANCE : super.getReconnectTargetCommand(request);
        return result;
    }

    protected EdgeLayoutData getEdgeLayoutDataWithSnapToGrid(CreateConnectionRequest request, INodeEditPart sourceEditPart, INodeEditPart targetEditPart, Point sourceLocation, Point targetLocation) {
        return super.getEdgeLayoutData(request, sourceEditPart, targetEditPart, sourceLocation, targetLocation);
    }
}

