/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.logger.InterpretationContext;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.helper.TableVariablesHelper;
import org.eclipse.sirius.table.business.api.refresh.DTableSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DLineCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;

public abstract class AbstractTableSynchronizer<D extends TableDescription, C extends ColumnMapping>
implements DTableSynchronizer {
    protected final D description;
    protected final RuntimeLoggerInterpreter interpreter;
    protected final ModelAccessor accessor;
    protected final DTableElementSynchronizer sync;
    protected DTable table;
    protected ECrossReferenceAdapter xref;
    protected RefreshIdsHolder ids;

    protected AbstractTableSynchronizer(D description, DTableElementSynchronizer sync) {
        this.sync = sync;
        this.accessor = sync.getAccessor();
        this.description = description;
        this.interpreter = sync.getInterpreter();
    }

    protected abstract void initRefreshMonitor(IProgressMonitor var1);

    @Override
    public void refresh(IProgressMonitor monitor) {
        try {
            this.initRefreshMonitor(monitor);
            KeyCache.DEFAULT.clear();
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_TABLE_KEY);
            HashMap<TableMapping, Collection<DTableElement>> mappingToElements = new HashMap<TableMapping, Collection<DTableElement>>();
            if (!this.table.eIsSet((EStructuralFeature)TablePackage.Literals.DTABLE__HEADER_COLUMN_WIDTH)) {
                this.table.setHeaderColumnWidth(this.description.getInitialHeaderColumnWidth());
            }
            this.refreshLines((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements);
            KeyCache.DEFAULT.clear();
            this.refreshColumns((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements);
            KeyCache.DEFAULT.clear();
            this.refreshCells((IProgressMonitor)new SubProgressMonitor(monitor, 1), mappingToElements);
            KeyCache.DEFAULT.clear();
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_TABLE_KEY);
        }
        finally {
            monitor.done();
        }
    }

    private void refreshLines(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        try {
            EList lMappings = new ArrayList();
            if (this.description != null) {
                lMappings = this.description.getAllLineMappings();
            }
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshLineMapping, lMappings.size());
            int currentLineIndex = 0;
            for (LineMapping lMapping : lMappings) {
                currentLineIndex = this.refreshLineMapping((LineContainer)this.table, lMapping, mappingToElements, currentLineIndex);
                monitor.worked(1);
            }
            if (lMappings.isEmpty()) {
                for (DLine lineToDelete : new ArrayList(this.table.getLines())) {
                    this.doDeleteLine(lineToDelete);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshColumns(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        try {
            List<C> cMappings = this.getColumnMappings();
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshColumnMapping, cMappings.size());
            int currentColumnIndex = 0;
            for (ColumnMapping cMapping : cMappings) {
                currentColumnIndex = this.refreshColumnMapping(cMapping, mappingToElements, currentColumnIndex);
                monitor.worked(1);
            }
            if (cMappings.isEmpty()) {
                for (DColumn columnToDelete : new ArrayList(this.table.getColumns())) {
                    this.doDeleteColumn(columnToDelete);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract List<C> getColumnMappings();

    protected abstract void refreshCells(IProgressMonitor var1, Map<TableMapping, Collection<DTableElement>> var2);

    protected DCell createCell(DLine line, DColumn column, EObject semantic, C mapping) {
        DCell newCell = TableFactory.eINSTANCE.createDCell();
        newCell.setTarget(semantic);
        newCell.setLine(line);
        newCell.setColumn(column);
        return newCell;
    }

    protected abstract int refreshColumnMapping(C var1, Map<TableMapping, Collection<DTableElement>> var2, int var3);

    private int refreshLineMapping(LineContainer container, LineMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex) {
        int currentIndex = previousCurrentIndex;
        SetIntersection<DLineCandidate> status = this.computeCurrentStatus(container, mapping);
        ArrayList<DLine> possibleContainers = new ArrayList<DLine>();
        ArrayList<DTableElement> elementsToKeep = new ArrayList<DTableElement>();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
            for (DLineCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteLine(toDelete.getOriginalElement());
            }
        }
        for (DLineCandidate lineCandidate : status.getAllElements()) {
            DLine toRefresh = this.detectLineToRefresh(lineCandidate, container, currentIndex, elementsToKeep);
            if (toRefresh != null) {
                possibleContainers.add(toRefresh);
            }
            ++currentIndex;
        }
        this.putOrAdd(mappingToElements, (TableMapping)mapping, elementsToKeep);
        this.refreshLineCandidates(possibleContainers, mappingToElements);
        return currentIndex;
    }

    private DLine detectLineToRefresh(DLineCandidate lineCandidate, LineContainer container, int currentIndex, Collection<DTableElement> elementsToKeep) {
        DLine result = null;
        if (lineCandidate.getOriginalElement() == null) {
            if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
                DLine newL = this.createNewLine(lineCandidate.getMapping(), lineCandidate.getSemantic());
                container.getLines().add(currentIndex, (Object)newL);
                this.sync.refresh(newL);
                this.sync.refreshSemanticElements((DTableElement)newL, (TableMapping)lineCandidate.getMapping());
                result = newL;
                elementsToKeep.add((DTableElement)newL);
            }
        } else {
            if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineCandidate.getOriginalElement())) {
                this.sync.refresh(lineCandidate.getOriginalElement());
                this.sync.refreshSemanticElements((DTableElement)lineCandidate.getOriginalElement(), (TableMapping)lineCandidate.getMapping());
                LineContainer lineContainer = (LineContainer)lineCandidate.getOriginalElement().eContainer();
                if (lineContainer.getLines().size() >= currentIndex) {
                    if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineContainer) && !lineCandidate.getOriginalElement().equals(lineContainer.getLines().get(currentIndex))) {
                        lineContainer.getLines().move(currentIndex, (Object)lineCandidate.getOriginalElement());
                    }
                } else if (this.accessor.getPermissionAuthority().canEditInstance((EObject)lineContainer)) {
                    lineContainer.getLines().move(lineContainer.getLines().size() - 1, (Object)lineCandidate.getOriginalElement());
                }
                result = lineCandidate.getOriginalElement();
            }
            elementsToKeep.add((DTableElement)lineCandidate.getOriginalElement());
        }
        return result;
    }

    private void refreshLineCandidates(Collection<DLine> possibleContainers, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        for (DLine newContainer : possibleContainers) {
            int currentSubIndex = 0;
            EList allSubLines = newContainer.getOriginMapping().getAllSubLines();
            for (LineMapping subMapping : allSubLines) {
                currentSubIndex = this.refreshLineMapping((LineContainer)newContainer, subMapping, mappingToElements, currentSubIndex);
            }
            if (!allSubLines.isEmpty() || newContainer.getLines().isEmpty() || !this.accessor.getPermissionAuthority().canEditInstance((EObject)newContainer)) continue;
            for (DLine lineToDelete : new ArrayList(newContainer.getLines())) {
                this.doDeleteLine(lineToDelete);
            }
        }
    }

    protected void putOrAdd(Map<TableMapping, Collection<DTableElement>> map, TableMapping mapping, Collection<DTableElement> elements) {
        MultipleCollection existing = map.get(mapping);
        if (existing == null) {
            existing = new MultipleCollection();
            existing.addAll(elements);
            map.put(mapping, (Collection<DTableElement>)existing);
        } else {
            existing.addAll(elements);
        }
    }

    protected DLine createNewLine(LineMapping mapping, EObject semantic) {
        DLine line = TableFactory.eINSTANCE.createDLine();
        line.setOriginMapping(mapping);
        line.setTarget(semantic);
        return line;
    }

    protected void doDeleteLine(DLine lineToDelete) {
        for (DLine line : Sets.newLinkedHashSet((Iterable)lineToDelete.getLines())) {
            this.doDeleteLine(line);
        }
        for (DCell cell : Sets.newLinkedHashSet((Iterable)lineToDelete.getCells())) {
            this.sync.removeUneededCell(cell);
        }
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)lineToDelete)) {
            this.accessor.eDelete((EObject)lineToDelete, this.xref);
        }
    }

    protected void doDeleteColumn(DColumn columnToDelete) {
        for (DCell cell : Sets.newLinkedHashSet((Iterable)columnToDelete.getCells())) {
            this.sync.removeUneededCell(cell);
        }
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)columnToDelete)) {
            this.accessor.eDelete((EObject)columnToDelete, this.xref);
        }
    }

    private SetIntersection<DLineCandidate> computeCurrentStatus(LineContainer container, LineMapping mapping) {
        SetIntersection status = new SetIntersection();
        this.removeTargetLessLines(container);
        this.setOldlineCandidates(container, mapping, (SetIntersection<DLineCandidate>)status);
        MultipleCollection semantics = new MultipleCollection();
        if (TableHelper.hasSemanticCandidatesExpression(mapping)) {
            InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, ctx -> {
                ctx.setVariables(TableVariablesHelper.getVariablesForCandidates(container));
                ctx.setVariable("viewpoint", (Object)this.table);
                Collection candidates = this.interpreter.evaluateCollection(container.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getLineMapping_SemanticCandidatesExpression());
                semantics.addAll(candidates);
            });
        } else {
            semantics.addAll(this.accessor.eAllContents(container.getTarget(), mapping.getDomainClass()));
        }
        for (EObject semantic : semantics) {
            if (!this.accessor.eInstanceOf(semantic, mapping.getDomainClass())) continue;
            status.addInNew((Object)new DLineCandidate(mapping, semantic, container, this.ids));
        }
        return status;
    }

    private void setOldlineCandidates(LineContainer container, LineMapping mapping, SetIntersection<DLineCandidate> status) {
        for (DLine line : container.getLines()) {
            LineMapping originMapping = line.getOriginMapping();
            if (originMapping != mapping && originMapping.eResource() != null) continue;
            status.addInOld((Object)new DLineCandidate(line, this.ids));
        }
    }

    private void removeTargetLessLines(LineContainer container) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)container)) {
            ArrayList<DLine> linesWithoutTarget = new ArrayList<DLine>();
            for (DLine line : container.getLines()) {
                if (line.getTarget() != null) continue;
                linesWithoutTarget.add(line);
            }
            for (DLine lineWithoutTarget : linesWithoutTarget) {
                this.doDeleteLine(lineWithoutTarget);
            }
        }
    }

    @Override
    public void setTable(DTable newTable) {
        this.table = newTable;
        this.ids = RefreshIdsHolder.getOrCreateHolder((EObject)this.table);
        this.xref = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.table.getTarget());
    }

    @Override
    public DTable getTable() {
        return this.table;
    }
}

