/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlinePageDescriptor;

public class QuickOutlineDescriptor {
    private List<QuickOutlinePageDescriptor> pages = new ArrayList<QuickOutlinePageDescriptor>();

    public void addPage(QuickOutlinePageDescriptor page) {
        Preconditions.checkArgument((page != null ? 1 : 0) != 0);
        this.pages.add(page);
    }

    public List<QuickOutlinePageDescriptor> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public Optional<QuickOutlinePageDescriptor> getFirstPage() {
        QuickOutlinePageDescriptor firstPage = null;
        if (!this.pages.isEmpty()) {
            firstPage = this.pages.get(0);
        }
        return Optional.ofNullable(firstPage);
    }

    public Optional<QuickOutlinePageDescriptor> getNextPage(QuickOutlinePageDescriptor page) {
        Optional<QuickOutlinePageDescriptor> result;
        if (page == null) {
            result = this.getFirstPage();
        } else {
            int indexNextPage = (this.pages.indexOf(page) + 1) % this.pages.size();
            result = Optional.ofNullable(this.pages.get(indexNextPage));
        }
        return result;
    }
}

