/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api.matcher;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ImageFigureEx;
import org.eclipse.sirius.tests.support.api.ImageEquality;
import org.eclipse.swt.graphics.Image;
import org.hamcrest.BaseMatcher;

public abstract class AbstractDecoratorMatcher
extends BaseMatcher<EditPart> {
    protected abstract Image getImage();

    public boolean matches(Object item) {
        if (item instanceof EditPart) {
            EditPart part = (EditPart)item;
            EditPartViewer viewer = part.getViewer();
            Map mapDecorator = viewer.getVisualPartMap();
            for (Map.Entry entry : mapDecorator.entrySet()) {
                EditPart currentPart = (EditPart)entry.getValue();
                IFigure visual = (IFigure)entry.getKey();
                if (!currentPart.equals(part) || !(visual instanceof IDecoration)) continue;
                return this.findFigureWithImage(visual, this.getImage());
            }
        }
        return false;
    }

    private boolean findFigureWithImage(IFigure figure, Image image) {
        if (figure instanceof ImageFigureEx && ImageEquality.areEqualImages(((ImageFigureEx)figure).getImage(), image)) {
            return true;
        }
        boolean imageFigureExFound = false;
        Iterator it = figure.getChildren().iterator();
        while (it.hasNext() && !imageFigureExFound) {
            IFigure innerFigure = (IFigure)it.next();
            imageFigureExFound = this.findFigureWithImage(innerFigure, image);
        }
        return imageFigureExFound;
    }
}

