/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.tools.PopupBarTool;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.swt.graphics.Image;

public class SiriusPopupBarEditPolicy
extends PopupBarEditPolicy {
    public SiriusPopupBarEditPolicy() {
        this.imagesToBeDisposed = new ArrayList(3);
    }

    protected void fillPopupBarDescriptors() {
        if (this.popupEnabledForDiagram() && this.getPopupBarDescriptors().isEmpty()) {
            this.fillBasedOnOpenPaletteDrawer();
        }
    }

    private boolean popupEnabledForDiagram() {
        DDiagram diagram = this.getCurrentDiagram();
        if (diagram != null && diagram.getDescription() != null) {
            return diagram.getDescription().isEnablePopupBars();
        }
        return (Boolean)DescriptionPackage.eINSTANCE.getDiagramDescription_EnablePopupBars().getDefaultValue();
    }

    private DDiagram getCurrentDiagram() {
        Object model = this.getHost().getModel();
        DDiagram result = null;
        if (model instanceof View) {
            EObject element = ((View)model).getElement();
            if (element instanceof DDiagram) {
                result = (DDiagram)element;
            } else if (element instanceof DDiagramElement) {
                result = ((DDiagramElement)element).getParentDiagram();
            }
        }
        return result;
    }

    private void fillBasedOnOpenPaletteDrawer() {
        PaletteViewer paletteViewer = this.getHost().getViewer().getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            for (Object child : paletteViewer.getPaletteRoot().getChildren()) {
                PaletteDrawer drawer;
                if (!(child instanceof PaletteDrawer) || !(drawer = (PaletteDrawer)child).isVisible()) continue;
                this.fillWithPaletteToolsInContainer((PaletteContainer)drawer);
            }
        }
    }

    private void fillWithPaletteToolsInContainer(PaletteContainer palContainer) {
        List theEntries = palContainer.getChildren();
        int i = 0;
        while (i < theEntries.size()) {
            PaletteEntry theEntry = (PaletteEntry)theEntries.get(i);
            if (theEntry instanceof CreationToolEntry) {
                this.addPopupBarEntryFor((CreationToolEntry)theEntry);
            } else if (theEntry instanceof PaletteStack) {
                this.fillWithPaletteToolsInContainer((PaletteContainer)((PaletteStack)theEntry));
            }
            ++i;
        }
    }

    private void addPopupBarEntryFor(CreationToolEntry tool) {
        AbstractToolDescription desc;
        IElementType elementType;
        CreationFactory factory = (CreationFactory)tool.getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY);
        if (factory != null && (elementType = this.getElementType(desc = (AbstractToolDescription)factory.getNewObject())) != null) {
            String tip = tool.getLabel();
            Image icon = tool.getSmallIcon() != null ? DiagramUIPlugin.getPlugin().getImage(tool.getSmallIcon()) : null;
            CreateRequest req = new CreateRequest();
            req.setFactory(factory);
            PopupBarTool popupBarTool = new PopupBarTool(this.getHost(), req);
            if (popupBarTool.isCommandEnabled()) {
                this.addPopupBarDescriptor(elementType, icon, (DragTracker)popupBarTool, tip);
            }
        }
    }

    private IElementType getElementType(AbstractToolDescription desc) {
        EClass klass = null;
        if (desc instanceof NodeCreationDescription) {
            klass = DiagramPackage.eINSTANCE.getDNode();
        } else if (desc instanceof ContainerCreationDescription) {
            klass = DiagramPackage.eINSTANCE.getDDiagramElementContainer();
        } else if (desc instanceof SelectionWizardDescription || desc instanceof PaneBasedSelectionWizardDescription) {
            klass = DiagramPackage.eINSTANCE.getDNode();
        } else if (desc instanceof ToolDescription) {
            klass = DiagramPackage.eINSTANCE.getDNode();
        }
        if (klass != null) {
            return ElementTypeRegistry.getInstance().getElementType(klass);
        }
        return null;
    }
}

