/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SimpleNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHY_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        KVector layerSize;
        monitor.begin("Simple node placement", 1.0f);
        Spacings spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        double maxHeight = 0.0;
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            layerSize.y = 0.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    layerSize.y += spacings.getVerticalSpacing(node, lastNode);
                }
                layerSize.y += node.getMargin().top + node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
            maxHeight = Math.max(maxHeight, layerSize.y);
        }
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            double pos = (maxHeight - layerSize.y) / 2.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    pos += spacings.getVerticalSpacing(node, lastNode);
                }
                node.getPosition().y = pos += node.getMargin().top;
                pos += node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
        }
        monitor.done();
    }
}

