/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class EditPartQuery {
    private final IGraphicalEditPart part;

    public EditPartQuery(IGraphicalEditPart part) {
        this.part = Objects.requireNonNull(part);
    }

    public <T> T getFirstAncestorOfType(Class<T> type) {
        if (this.part == null) {
            return null;
        }
        EditPart current = this.part.getParent();
        while (current != null && !type.isInstance(current)) {
            current = current.getParent();
        }
        return type.cast(current);
    }

    public <T> List<T> getAllAncestorsOfType(Class<T> type) {
        if (this.part == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        EditPart current = this.part.getParent();
        while (current != null) {
            if (type.isInstance(current)) {
                result.add(type.cast(current));
            }
            current = current.getParent();
        }
        return result;
    }

    public List<Node> getBorderedNodes(int expectedSide) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (IBorderItemEditPart borderItemEditPart : this.getBorderNodeEditParts(expectedSide)) {
            result.add((Node)borderItemEditPart.getModel());
        }
        return result;
    }

    public List<IBorderItemEditPart> getBorderNodeEditParts(final int expectedSide) {
        if (this.part instanceof IBorderedShapeEditPart) {
            Iterable bordersItemPart = Iterables.filter((Iterable)this.part.getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IBorderItemEditPart.class), (Predicate)new Predicate<IBorderItemEditPart>(){

                public boolean apply(IBorderItemEditPart input) {
                    int currentSide = input.getBorderItemLocator().getCurrentSideOfParent();
                    return expectedSide == currentSide;
                }
            }));
            return Lists.newArrayList((Iterable)bordersItemPart);
        }
        return new ArrayList<IBorderItemEditPart>();
    }

    public Map<Node, Dimension> getBorderedNodesToMoveWithDelta(int expectedSide, int resizedSide, int parentResizeSize) {
        List<IBorderItemEditPart> expectedSideEditParts;
        Map<Node, Dimension> result = new HashMap<Node, Dimension>();
        if (parentResizeSize < 0 && this.part instanceof IBorderedShapeEditPart && (expectedSideEditParts = this.getBorderNodeEditParts(expectedSide)).size() > 0) {
            BorderedNodeFigure parentFigure = ((IBorderedShapeEditPart)this.part).getBorderedFigure();
            Rectangle parentBounds = parentFigure.getBounds();
            if (parentFigure instanceof NodeFigure) {
                parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
            }
            Set<IBorderItemEditPart> sortedEditParts = this.sortEditParts(expectedSideEditParts, resizedSide);
            if (expectedSide == 16 || expectedSide == 8) {
                result = this.getBorderedNodesToMoveVerticallyWithDelta(sortedEditParts, parentBounds, resizedSide, parentResizeSize);
            } else if (expectedSide == 1 || expectedSide == 4) {
                result = this.getBorderedNodesToMoveHorizontallyWithDelta(sortedEditParts, parentBounds, resizedSide, parentResizeSize);
            }
        }
        return result;
    }

    public boolean isVisibleOnViewport() {
        IFigure figure;
        Viewport nearestEnclosingViewport;
        Viewport topViewport = ((FigureCanvas)this.part.getViewer().getControl()).getViewport();
        List enclosingViewportsPath = topViewport.equals(nearestEnclosingViewport = ViewportUtilities.getNearestEnclosingViewport((IFigure)(figure = this.part.getFigure()))) ? Lists.newArrayList((Object[])new Viewport[]{topViewport}) : ViewportUtilities.getViewportsPath((Viewport)nearestEnclosingViewport, (Viewport)topViewport, (boolean)true);
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(figure);
        this.clipAtViewports(clipRect, enclosingViewportsPath);
        return !clipRect.isEmpty();
    }

    protected void clipAtViewports(Rectangle clipRect, List<Viewport> enclosingViewportsPath) {
        for (Viewport viewport : enclosingViewportsPath) {
            clipRect.intersect(this.getAbsoluteViewportAreaAsCopy(viewport));
        }
    }

    protected Rectangle getAbsoluteViewportAreaAsCopy(Viewport viewport) {
        return this.getAbsoluteClientAreaAsCopy((IFigure)viewport);
    }

    protected Rectangle getAbsoluteClientAreaAsCopy(IFigure figure) {
        Rectangle absoluteClientArea = figure.getClientArea();
        figure.translateToParent((Translatable)absoluteClientArea);
        figure.translateToAbsolute((Translatable)absoluteClientArea);
        return absoluteClientArea;
    }

    protected Rectangle getAbsoluteBoundsAsCopy(IFigure figure) {
        Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)absoluteFigureBounds);
        return absoluteFigureBounds;
    }

    public boolean isFreeFormContainerChildrenPresentation() {
        boolean isFreeForm = true;
        EObject semElt = this.part.resolveSemanticElement();
        if (semElt == null) {
            isFreeForm = false;
        } else {
            DNodeContainer container;
            ContainerLayout childrenPresentation;
            EObject eContainer = semElt.eContainer();
            if (eContainer instanceof DNodeList) {
                isFreeForm = false;
            } else if (eContainer instanceof DNodeContainer && !(childrenPresentation = (container = (DNodeContainer)eContainer).getChildrenPresentation()).equals((Object)ContainerLayout.FREE_FORM)) {
                isFreeForm = false;
            }
        }
        return isFreeForm;
    }

    private Map<Node, Dimension> getBorderedNodesToMoveVerticallyWithDelta(Set<IBorderItemEditPart> editParts, Rectangle parentBounds, int resizedSide, int parentResizeSize) {
        LinkedHashMap<IBorderItemEditPart, Dimension> defaultComputedShifting = new LinkedHashMap<IBorderItemEditPart, Dimension>();
        LinkedHashMap<Node, Dimension> shiftingAccordingToBorderItemLocator = new LinkedHashMap<Node, Dimension>();
        for (IBorderItemEditPart editPart : editParts) {
            Node node = (Node)editPart.getModel();
            if (!(node.getLayoutConstraint() instanceof Bounds)) continue;
            Bounds borderedNodeBounds = (Bounds)node.getLayoutConstraint();
            if (1 == resizedSide) {
                if (borderedNodeBounds.getY() >= -parentResizeSize) continue;
                defaultComputedShifting.put(editPart, new Dimension(0, -borderedNodeBounds.getY()));
                continue;
            }
            int distanceFromBottom = parentBounds.height - IBorderItemOffsets.DEFAULT_OFFSET.height - (borderedNodeBounds.getY() + borderedNodeBounds.getHeight());
            if (distanceFromBottom >= -parentResizeSize) continue;
            defaultComputedShifting.put(editPart, new Dimension(0, distanceFromBottom + parentResizeSize));
        }
        HashMap<IBorderItemEditPart, IFigure> partToFigureToIgnore = new HashMap<IBorderItemEditPart, IFigure>();
        for (IBorderItemEditPart editPart : defaultComputedShifting.keySet()) {
            partToFigureToIgnore.put(editPart, editPart.getFigure());
        }
        for (IBorderItemEditPart borderItemEditPart : defaultComputedShifting.keySet()) {
            Rectangle currentBounds = borderItemEditPart.getFigure().getBounds();
            Rectangle expectedNewBounds = currentBounds.getCopy();
            expectedNewBounds.setX(expectedNewBounds.x + ((Dimension)defaultComputedShifting.get((Object)borderItemEditPart)).width);
            expectedNewBounds.setY(expectedNewBounds.y + ((Dimension)defaultComputedShifting.get((Object)borderItemEditPart)).height);
            IBorderItemLocator borderItemLocator = borderItemEditPart.getBorderItemLocator();
            if (borderItemLocator instanceof DBorderItemLocator) {
                Rectangle borderItemLocatorParentBounds = ((DBorderItemLocator)borderItemLocator).getParentFigure().getBounds();
                if (1 == resizedSide) {
                    borderItemLocatorParentBounds.setY(borderItemLocatorParentBounds.y - parentResizeSize);
                    expectedNewBounds.setY(expectedNewBounds.y - parentResizeSize);
                }
                borderItemLocatorParentBounds.setHeight(borderItemLocatorParentBounds.height + parentResizeSize);
                expectedNewBounds = ((DBorderItemLocator)borderItemLocator).getValidLocation(expectedNewBounds, borderItemEditPart.getFigure(), partToFigureToIgnore.values(), new ArrayList<IFigure>());
                if (1 == resizedSide) {
                    borderItemLocatorParentBounds.setY(borderItemLocatorParentBounds.y + parentResizeSize);
                }
                borderItemLocatorParentBounds.setHeight(borderItemLocatorParentBounds.height - parentResizeSize);
            } else {
                expectedNewBounds = borderItemLocator.getValidLocation(expectedNewBounds, borderItemEditPart.getFigure());
            }
            if (1 == resizedSide) {
                shiftingAccordingToBorderItemLocator.put((Node)borderItemEditPart.getModel(), new Dimension(expectedNewBounds.x - currentBounds.x, expectedNewBounds.y - currentBounds.y + parentResizeSize));
            } else {
                shiftingAccordingToBorderItemLocator.put((Node)borderItemEditPart.getModel(), new Dimension(expectedNewBounds.x - currentBounds.x, expectedNewBounds.y - currentBounds.y));
            }
            borderItemEditPart.getFigure().getBounds().setX(expectedNewBounds.x);
            borderItemEditPart.getFigure().getBounds().setY(expectedNewBounds.y);
            partToFigureToIgnore.remove(borderItemEditPart);
        }
        return shiftingAccordingToBorderItemLocator;
    }

    private Map<Node, Dimension> getBorderedNodesToMoveHorizontallyWithDelta(Set<IBorderItemEditPart> editParts, Rectangle parentBounds, int resizedSide, int parentResizeSize) {
        LinkedHashMap<IBorderItemEditPart, Dimension> defaultComputedShifting = new LinkedHashMap<IBorderItemEditPart, Dimension>();
        LinkedHashMap<Node, Dimension> shiftingAccordingToBorderItemLocator = new LinkedHashMap<Node, Dimension>();
        for (IBorderItemEditPart editPart : editParts) {
            Node node = (Node)editPart.getModel();
            if (!(node.getLayoutConstraint() instanceof Bounds)) continue;
            Bounds borderedNodeBounds = (Bounds)node.getLayoutConstraint();
            if (8 == resizedSide) {
                if (borderedNodeBounds.getX() >= -parentResizeSize) continue;
                defaultComputedShifting.put(editPart, new Dimension(-borderedNodeBounds.getX(), 0));
                continue;
            }
            int distanceFromRight = parentBounds.width - IBorderItemOffsets.DEFAULT_OFFSET.height - (borderedNodeBounds.getX() + borderedNodeBounds.getWidth());
            if (distanceFromRight >= -parentResizeSize) continue;
            defaultComputedShifting.put(editPart, new Dimension(distanceFromRight + parentResizeSize, 0));
        }
        HashMap<IBorderItemEditPart, IFigure> partToFigureToIgnore = new HashMap<IBorderItemEditPart, IFigure>();
        for (IBorderItemEditPart editPart : defaultComputedShifting.keySet()) {
            partToFigureToIgnore.put(editPart, editPart.getFigure());
        }
        for (IBorderItemEditPart borderItemEditPart : defaultComputedShifting.keySet()) {
            Rectangle currentBounds = borderItemEditPart.getFigure().getBounds();
            Rectangle expectedNewBounds = currentBounds.getCopy();
            expectedNewBounds.setX(expectedNewBounds.x + ((Dimension)defaultComputedShifting.get((Object)borderItemEditPart)).width);
            expectedNewBounds.setY(expectedNewBounds.y + ((Dimension)defaultComputedShifting.get((Object)borderItemEditPart)).height);
            IBorderItemLocator borderItemLocator = borderItemEditPart.getBorderItemLocator();
            if (borderItemLocator instanceof DBorderItemLocator) {
                Rectangle borderItemLocatorParentBounds = ((DBorderItemLocator)borderItemLocator).getParentFigure().getBounds();
                if (8 == resizedSide) {
                    borderItemLocatorParentBounds.setX(borderItemLocatorParentBounds.x - parentResizeSize);
                    expectedNewBounds.setX(expectedNewBounds.x - parentResizeSize);
                }
                borderItemLocatorParentBounds.setWidth(borderItemLocatorParentBounds.width + parentResizeSize);
                expectedNewBounds = ((DBorderItemLocator)borderItemLocator).getValidLocation(expectedNewBounds, borderItemEditPart.getFigure(), partToFigureToIgnore.values(), new ArrayList<IFigure>());
                if (8 == resizedSide) {
                    borderItemLocatorParentBounds.setX(borderItemLocatorParentBounds.x + parentResizeSize);
                }
                borderItemLocatorParentBounds.setWidth(borderItemLocatorParentBounds.width - parentResizeSize);
            } else {
                expectedNewBounds = borderItemLocator.getValidLocation(expectedNewBounds, borderItemEditPart.getFigure());
            }
            if (8 == resizedSide) {
                shiftingAccordingToBorderItemLocator.put((Node)borderItemEditPart.getModel(), new Dimension(expectedNewBounds.x - currentBounds.x + parentResizeSize, expectedNewBounds.y - currentBounds.y));
            } else {
                shiftingAccordingToBorderItemLocator.put((Node)borderItemEditPart.getModel(), new Dimension(expectedNewBounds.x - currentBounds.x, expectedNewBounds.y - currentBounds.y));
            }
            borderItemEditPart.getFigure().getBounds().setX(expectedNewBounds.x);
            borderItemEditPart.getFigure().getBounds().setY(expectedNewBounds.y);
            partToFigureToIgnore.remove(borderItemEditPart);
        }
        return shiftingAccordingToBorderItemLocator;
    }

    private Set<IBorderItemEditPart> sortEditParts(List<IBorderItemEditPart> nodes, int resizedSide) {
        Object getValueToCompareFunction = 1 == resizedSide ? new Function<IBorderItemEditPart, Integer>(){

            public Integer apply(IBorderItemEditPart from) {
                Node node = (Node)from.getModel();
                if (node.getLayoutConstraint() instanceof Bounds) {
                    Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
                    return nodeBounds.getY();
                }
                return 0;
            }
        } : (4 == resizedSide ? new Function<IBorderItemEditPart, Integer>(){

            public Integer apply(IBorderItemEditPart from) {
                Node node = (Node)from.getModel();
                if (node.getLayoutConstraint() instanceof Bounds) {
                    Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
                    return -(nodeBounds.getY() + nodeBounds.getHeight());
                }
                return 0;
            }
        } : (16 == resizedSide ? new Function<IBorderItemEditPart, Integer>(){

            public Integer apply(IBorderItemEditPart from) {
                Node node = (Node)from.getModel();
                if (node.getLayoutConstraint() instanceof Bounds) {
                    Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
                    return -(nodeBounds.getX() + nodeBounds.getWidth());
                }
                return 0;
            }
        } : new Function<IBorderItemEditPart, Integer>(){

            public Integer apply(IBorderItemEditPart from) {
                Node node = (Node)from.getModel();
                if (node.getLayoutConstraint() instanceof Bounds) {
                    Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
                    return nodeBounds.getX();
                }
                return 0;
            }
        }));
        Ordering ordering = Ordering.natural().onResultOf((Function)getValueToCompareFunction);
        return ImmutableSortedSet.orderedBy((Comparator)ordering).addAll(nodes).build();
    }

    public boolean isCollapsed() {
        DrawerStyle drawerStyle = this.getDrawerStyle();
        return drawerStyle != null && drawerStyle.isCollapsed();
    }

    public DrawerStyle getDrawerStyle() {
        if (this.part instanceof AbstractDiagramElementContainerEditPart && this.part.getNotationView() != null && ((AbstractDiagramElementContainerEditPart)this.part).isRegion()) {
            for (Node child : Iterables.filter((Iterable)this.part.getNotationView().getChildren(), Node.class)) {
                DrawerStyle drawerStyle = (DrawerStyle)child.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
                if (drawerStyle == null) continue;
                return drawerStyle;
            }
        }
        return null;
    }

    public boolean isInLayoutingMode() {
        Diagram diagram;
        View notationView = this.part.getNotationView();
        if (notationView != null && (diagram = notationView.getDiagram()) != null) {
            EObject element = diagram.getElement();
            return element instanceof DDiagram && ((DDiagram)element).isIsInLayoutingMode();
        }
        return false;
    }

    public boolean isInShowingMode() {
        Diagram diagram;
        View notationView = this.part.getNotationView();
        if (notationView != null && (diagram = notationView.getDiagram()) != null) {
            EObject element = diagram.getElement();
            return element instanceof DDiagram && ((DDiagram)element).isIsInShowingMode();
        }
        return false;
    }

    public Point getSnapLocation(Request request, Point proposedLocation) {
        Object helper;
        if (this.isSnapToGridEnabled() && (helper = this.part.getAdapter(SnapToHelper.class)) instanceof SnapToHelper) {
            PrecisionPoint preciseLocation = new PrecisionPoint(proposedLocation);
            PrecisionPoint result = new PrecisionPoint(proposedLocation);
            ((SnapToHelper)helper).snapPoint(request, 192, preciseLocation, result);
            return result.getCopy();
        }
        return proposedLocation;
    }

    public boolean isSnapToGridEnabled() {
        IPreferenceStore preferenceStore;
        EditPartViewer editPartViewer = this.part.getViewer();
        if (editPartViewer instanceof DiagramGraphicalViewer && (preferenceStore = ((DiagramGraphicalViewer)editPartViewer).getWorkspaceViewerPreferenceStore()) != null) {
            return preferenceStore.getBoolean("rulergrid.snaptogrid");
        }
        return false;
    }

    public int getSideOfLocation(Point point) {
        Rectangle bounds = this.part.getFigure().getBounds();
        int side = bounds.getTop().y == point.y ? 1 : (bounds.getRight().x == point.x ? 16 : (bounds.getBottom().y == point.y ? 4 : (bounds.getLeft().x == point.x ? 8 : 0)));
        return side;
    }

    public Point getCenterOfSide(int positionConstant) {
        Point center;
        Rectangle bounds = this.part.getFigure().getBounds();
        switch (positionConstant) {
            case 1: {
                center = bounds.getTop();
                break;
            }
            case 16: {
                center = bounds.getRight();
                break;
            }
            case 4: {
                center = bounds.getBottom();
                break;
            }
            case 8: {
                center = bounds.getLeft();
                break;
            }
            default: {
                center = bounds.getCenter();
            }
        }
        return center;
    }

    public boolean isAutoSized(boolean checkWidth, boolean checkHeight) {
        boolean isAutoSized = false;
        if (this.part instanceof AbstractDiagramContainerEditPart && ((AbstractDiagramContainerEditPart)this.part).isRegionContainer()) {
            isAutoSized = ((AbstractDiagramContainerEditPart)this.part).getResizableCompartments().stream().allMatch(resizableCompartment -> new EditPartQuery((IGraphicalEditPart)resizableCompartment).isAutoSized(checkWidth, checkHeight));
        } else if (this.part instanceof ResizableCompartmentEditPart && this.part.getParent() instanceof AbstractDiagramContainerEditPart && ((AbstractDiagramContainerEditPart)this.part.getParent()).isRegionContainer()) {
            isAutoSized = this.isAutoSized((ResizableCompartmentEditPart)this.part, checkWidth, checkHeight);
        } else {
            Integer width = (Integer)this.part.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)this.part.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            isAutoSized = !(checkWidth && width != -1 || checkHeight && height != -1);
        }
        return isAutoSized;
    }

    private boolean isAutoSized(ResizableCompartmentEditPart resizableCompartmentEditPart, boolean checkWidth, boolean checkHeight) {
        return resizableCompartmentEditPart.getChildren().stream().filter(AbstractDiagramElementContainerEditPart.class::isInstance).allMatch(el -> {
            Integer containerWidth = (Integer)((AbstractDiagramElementContainerEditPart)el).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer containerHeight = (Integer)((AbstractDiagramElementContainerEditPart)el).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            return !(checkWidth && containerWidth != -1 || checkHeight && containerHeight != -1);
        });
    }

    public boolean isAutoSized() {
        return this.isAutoSized(true, true);
    }

    public int getVisualID() {
        try {
            Field visualIDfield = this.part.getClass().getField("VISUAL_ID");
            return (Integer)visualIDfield.get(this.part);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            DiagramUIPlugin.getPlugin().error(MessageFormat.format(Messages.AbstractDEdgeNameEditPart_VisualID_Error, this.part), e);
            return -1;
        }
    }
}

