/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.project;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.api.SiriusServerPath;
import org.eclipse.sirius.server.api.SiriusServerResponse;
import org.eclipse.sirius.server.backend.internal.SiriusServerBackendPlugin;
import org.eclipse.sirius.server.backend.internal.expressions.SiriusBackendInterpreter;
import org.eclipse.sirius.server.backend.internal.services.project.AbstractSiriusServerRepresentationDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerActivityDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerDiagramDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerPageDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerProjectDescriptionUpdatedDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerProjectDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerSectionDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerSemanticResourceDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerTableDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerTreeDto;
import org.eclipse.sirius.server.backend.internal.services.project.SiriusServerUpdateProjectDescriptionDto;
import org.eclipse.sirius.server.backend.internal.services.workflow.WorkflowHelper;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerUtils;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.workflow.ActivityDescription;
import org.eclipse.sirius.workflow.PageDescription;
import org.eclipse.sirius.workflow.SectionDescription;

@SiriusServerPath(value="/projects/{projectName}")
public class SiriusServerProjectService
implements ISiriusServerService {
    private static final String SELF = "self";
    private static final Object PROJECT_NAME = "projectName";

    public SiriusServerResponse doGet(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        Optional<String> optionalProjectName = Optional.ofNullable(variables.get(PROJECT_NAME));
        Optional<SiriusServerProjectDto> optionalModelingProject = optionalProjectName.flatMap(this::findModelingProjectByName);
        Optional<SiriusServerProjectDto> optionalProject = optionalModelingProject.map(this::getProjectFromModelingProject);
        return optionalProject.map(project -> new SiriusServerResponse(200, project)).orElseGet(() -> new SiriusServerResponse(404));
    }

    private Optional<ModelingProject> findModelingProjectByName(String projectName) {
        Optional<IProject> optionalProject = Optional.ofNullable(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        return optionalProject.filter(ModelingProject::hasModelingProjectNature).filter(IProject::isOpen).map(iProject -> (ModelingProject)ModelingProject.asModelingProject((IProject)iProject).get());
    }

    private SiriusServerProjectDto getProjectFromModelingProject(ModelingProject modelingProject) {
        Session session = SiriusServerUtils.getSession(modelingProject);
        String projectName = modelingProject.getProject().getName();
        String description = SiriusServerUtils.getProjectDescription(modelingProject.getProject());
        List<AbstractSiriusServerRepresentationDto> representations = this.getRepresentations(session);
        List<SiriusServerSemanticResourceDto> semanticResources = this.getSemanticResources(modelingProject.getProject(), session);
        List<SiriusServerPageDto> pages = this.getPages(modelingProject, session);
        List<SiriusServerSectionDto> currentPageSections = this.getFirstPageSections(session);
        return new SiriusServerProjectDto(projectName, description, representations, semanticResources, pages, currentPageSections);
    }

    private List<SiriusServerPageDto> getPages(ModelingProject modelingProject, Session session) {
        return WorkflowHelper.on(session).getPageDescriptions().map(page -> {
            DAnalysis self = ((DAnalysisSession)session).allAnalyses().stream().findFirst().orElse(null);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put(SELF, self);
            IEvaluationResult result = new SiriusBackendInterpreter(session).evaluateExpression(variables, page.getTitleExpression());
            String identifier = page.getName();
            String name = result.asString();
            return new SiriusServerPageDto(identifier, name);
        }).collect(Collectors.toList());
    }

    private List<SiriusServerSectionDto> getFirstPageSections(Session session) {
        Optional<PageDescription> optionalPageDescription = WorkflowHelper.on(session).getPageDescriptions().findFirst();
        List sectionDescriptions = (List)optionalPageDescription.map(PageDescription::getSections).orElseGet(BasicEList::new);
        return sectionDescriptions.stream().map(sectionDescription -> this.convertSection(session, (SectionDescription)sectionDescription)).collect(Collectors.toList());
    }

    private SiriusServerSectionDto convertSection(Session session, SectionDescription sectionDescription) {
        String sectionIdentifier = sectionDescription.getName();
        DAnalysis self = ((DAnalysisSession)session).allAnalyses().stream().findFirst().orElse(null);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(SELF, self);
        IEvaluationResult result = new SiriusBackendInterpreter(session).evaluateExpression(variables, sectionDescription.getTitleExpression());
        String sectionName = result.asString();
        List<SiriusServerActivityDto> activities = sectionDescription.getActivities().stream().map(activityDescription -> this.convertActivity(session, (ActivityDescription)activityDescription)).collect(Collectors.toList());
        return new SiriusServerSectionDto(sectionIdentifier, sectionName, activities);
    }

    private SiriusServerActivityDto convertActivity(Session session, ActivityDescription activityDescription) {
        String activityIdentifier = activityDescription.getName();
        DAnalysis self = ((DAnalysisSession)session).allAnalyses().stream().findFirst().orElse(null);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(SELF, self);
        IEvaluationResult result = new SiriusBackendInterpreter(session).evaluateExpression(variables, activityDescription.getLabelExpression());
        String activityName = result.asString();
        return new SiriusServerActivityDto(activityIdentifier, activityName);
    }

    private List<AbstractSiriusServerRepresentationDto> getRepresentations(Session session) {
        Collection representationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        return representationDescriptors.stream().filter(descriptor -> !descriptor.getDescription().eIsProxy()).map(this::convertToRepresentation).collect(Collectors.toList());
    }

    private AbstractSiriusServerRepresentationDto convertToRepresentation(DRepresentationDescriptor descriptor) {
        String name = descriptor.getName();
        RepresentationDescription description = descriptor.getDescription();
        String descriptionName = description.getName();
        String viewpointName = Optional.of(description.eContainer()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(IdentifiedElement::getName).orElse("");
        AbstractSiriusServerRepresentationDto representation = null;
        if (description instanceof DiagramDescription) {
            representation = new SiriusServerDiagramDto(viewpointName, descriptionName, name);
        } else if (description instanceof TableDescription) {
            representation = new SiriusServerTableDto(viewpointName, descriptionName, name);
        } else if (description instanceof TreeDescription) {
            representation = new SiriusServerTreeDto(viewpointName, descriptionName, name);
        }
        return representation;
    }

    private List<SiriusServerSemanticResourceDto> getSemanticResources(IProject project, Session session) {
        Collection semanticResources = session.getSemanticResources();
        return semanticResources.stream().map(Resource::getURI).filter(URI::isPlatformResource).map(uri -> {
            String platformString = uri.toPlatformString(true);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        }).filter(iFile -> iFile.getProject().equals((Object)project)).map(this::convertToSemanticResource).collect(Collectors.toList());
    }

    private SiriusServerSemanticResourceDto convertToSemanticResource(IFile iFile) {
        String name = iFile.getName();
        String path = iFile.getProjectRelativePath().toString();
        long size = 0L;
        File file = iFile.getLocation().toFile();
        try {
            size = Files.size(file.toPath());
        }
        catch (IOException exception) {
            Status status = new Status(4, "org.eclipse.sirius.server.backend", exception.getMessage(), (Throwable)exception);
            SiriusServerBackendPlugin.getPlugin().log(status);
        }
        String sizeLabel = this.getSizeLabel(size);
        return new SiriusServerSemanticResourceDto(path, name, sizeLabel);
    }

    private String getSizeLabel(long size) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        double kb = 1024.0;
        double mb = kb * 1024.0;
        if ((double)size > mb) {
            return String.valueOf(decimalFormat.format((double)size / mb)) + "MB";
        }
        return String.valueOf(decimalFormat.format((double)size / kb)) + "KB";
    }

    public SiriusServerResponse doPut(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        SiriusServerResponse response = null;
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            SiriusServerUpdateProjectDescriptionDto updateProjectDescription = (SiriusServerUpdateProjectDescriptionDto)new Gson().fromJson((Reader)reader, SiriusServerUpdateProjectDescriptionDto.class);
            String projectName = variables.get(PROJECT_NAME);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                IProjectDescription description = project.getDescription();
                description.setComment(updateProjectDescription.getDescription());
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                response = new SiriusServerResponse(200, (Object)new SiriusServerProjectDescriptionUpdatedDto(description.getComment()));
            } else {
                response = new SiriusServerResponse(404);
            }
        }
        catch (IOException | CoreException throwable) {
            response = new SiriusServerResponse(500);
        }
        return response;
    }
}

