/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.command.MoveRepresentationCommand;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorService;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MoveRepresentationAction
extends Action {
    private final Collection<DRepresentationDescriptor> repDescriptors;
    private final DAnalysis targetAnalysis;
    private final Session session;

    public MoveRepresentationAction(Session session, DAnalysis targetAnalysis, Collection<DRepresentationDescriptor> selection) {
        this.targetAnalysis = targetAnalysis;
        this.session = session;
        this.repDescriptors = selection;
        Assert.isTrue((!this.repDescriptors.isEmpty() ? 1 : 0) != 0);
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif");
        this.setImageDescriptor(descriptor);
        this.setText(MessageFormat.format(Messages.MoveRepresentationAction_text, targetAnalysis.eResource().getURI().toString()));
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public MoveRepresentationAction(Session session, Collection<DRepresentationDescriptor> selection) {
        this.targetAnalysis = null;
        this.session = session;
        this.repDescriptors = selection;
        Assert.isTrue((!this.repDescriptors.isEmpty() ? 1 : 0) != 0);
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif");
        this.setImageDescriptor(descriptor);
        this.setText(Messages.MoveRepresentationAction_label);
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.targetAnalysis == null && this.session instanceof DAnalysisSession) {
            DAnalysisSelector dAnalysisSelector = DAnalysisSelectorService.getSelector((DAnalysisSession)((DAnalysisSession)this.session));
            for (DRepresentationDescriptor dRepresentationDescriptor : this.repDescriptors) {
                Option dAnalysisOption = new EObjectQuery((EObject)dRepresentationDescriptor).getFirstAncestorOfType(ViewpointPackage.eINSTANCE.getDAnalysis());
                Collection analysesCandidates = ((DAnalysisSession)this.session).allAnalyses();
                analysesCandidates.remove(dAnalysisOption.get());
                try {
                    DAnalysis selectedDAnalysis = dAnalysisSelector.selectSmartlyAnalysisForAddedRepresentation(dRepresentationDescriptor.getRepresentation(), analysesCandidates);
                    if (selectedDAnalysis == dAnalysisOption.get()) continue;
                    this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new MoveRepresentationCommand(this.session, selectedDAnalysis, Collections.singleton(dRepresentationDescriptor)));
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        } else {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
            if (uiSession != null) {
                for (DRepresentationDescriptor repDescriptor : this.repDescriptors) {
                    DialectEditor editor = uiSession.getEditor(repDescriptor.getRepresentation());
                    if (editor == null) continue;
                    editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
                }
            }
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new MoveRepresentationCommand(this.session, this.targetAnalysis, this.repDescriptors));
        }
    }

    private boolean isValidSelection() {
        if (this.targetAnalysis == null) {
            return this.session.getReferencedSessionResources().size() > 0;
        }
        boolean anyInvalidMove = Iterables.any(this.repDescriptors, (Predicate)new Predicate<DRepresentationDescriptor>(){

            public boolean apply(DRepresentationDescriptor input) {
                IPermissionAuthority permissionAuthority;
                DView targetContainer;
                IPermissionAuthority permissionAuthority2;
                boolean invalid = false;
                EObject container = input.eContainer();
                if (container instanceof DView && (permissionAuthority2 = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority2.canDeleteInstance((EObject)input)) {
                    invalid = true;
                }
                if (!invalid && (targetContainer = DAnalysisSessionHelper.findDViewForAddedRepresentation((DAnalysis)MoveRepresentationAction.this.targetAnalysis, (RepresentationDescription)input.getDescription())) != null && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)targetContainer)) != null && !permissionAuthority.canCreateIn((EObject)targetContainer)) {
                    invalid = true;
                }
                return invalid;
            }
        });
        return !anyInvalidMove;
    }
}

