/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.emf.internal.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EClassInterfaceTypeBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EClassObjectTypeBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.INameProvider;

public class ExtendedEClassTypesBuilder {
    private EClass eClass;
    private HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache;
    private INameProvider nameProvider = (anEClass, nameKind) -> anEClass.getName();
    private Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter;

    public ExtendedEClassTypesBuilder(EClass eClass, HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache) {
        this.eClass = eClass;
        this.eDataTypeToOutputTypeCache = eDataTypeToOutputTypeCache;
    }

    public ExtendedEClassTypesBuilder nameProvider(INameProvider nameProvider) {
        this.nameProvider = nameProvider;
        return this;
    }

    public ExtendedEClassTypesBuilder eStructuralFeatureFilter(Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter) {
        this.eStructuralFeatureFilter = eStructuralFeatureFilter;
        return this;
    }

    public Set<GraphQLType> getTypes() {
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        GraphQLType interfaceType = new EClassInterfaceTypeBuilder(this.eClass, this.eDataTypeToOutputTypeCache).nameProvider(this.nameProvider).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getType();
        GraphQLObjectType objectType = new EClassObjectTypeBuilder(this.eClass, this.eDataTypeToOutputTypeCache).nameProvider(this.nameProvider).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getType();
        types.add(interfaceType);
        types.add((GraphQLType)objectType);
        return types;
    }
}

