/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableTextEditor {
    private static final int BORDER_WIDTH = 1;
    private static final Point MULTILINE_EDITOR_SIZE = new Point(594, 100);
    private final Text m_text;
    private final Shell m_shell;

    public TableTextEditor(Control parent, int style) {
        this.m_shell = new Shell(parent.getShell(), 4);
        this.m_shell.setBounds(TableTextEditor.computeBounds(parent, style));
        this.setErrorStatus(null);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.m_shell.setLayout((Layout)layout);
        this.m_text = new Text((Composite)this.m_shell, style);
        this.m_text.setBackground(this.m_text.getDisplay().getSystemColor(25));
    }

    private static Rectangle computeBounds(Control cursor, int style) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        Point size = (style & 2) != 0 ? new Point(TableTextEditor.MULTILINE_EDITOR_SIZE.x, TableTextEditor.MULTILINE_EDITOR_SIZE.y) : new Point(cursor.getBounds().width, cursor.getBounds().height);
        Rectangle displayBounds = cursor.getDisplay().getBounds();
        size.x = Math.min(displayBounds.width, size.x);
        size.y = Math.min(displayBounds.height, size.y);
        bounds.width = size.x;
        bounds.height = size.y;
        Point shellPosition = cursor.toDisplay(new Point(0, 0));
        bounds.x = shellPosition.x;
        bounds.y = shellPosition.y;
        if (bounds.x + bounds.width > displayBounds.x + displayBounds.width) {
            bounds.x = displayBounds.x + displayBounds.width - bounds.width;
        }
        if (bounds.y + bounds.height > displayBounds.y + displayBounds.height) {
            bounds.x = displayBounds.y + displayBounds.height - bounds.height;
        }
        return bounds;
    }

    public void setFocus() {
        this.m_shell.setFocus();
    }

    public void open() {
        this.m_shell.open();
    }

    public void dispose() {
        this.m_shell.dispose();
    }

    public Display getDisplay() {
        return this.m_shell.getDisplay();
    }

    public boolean isDisposed() {
        return this.m_shell.isDisposed();
    }

    public void setErrorStatus(IStatus status) {
        boolean isError;
        boolean bl = isError = status != null && TranslationValidator.isForbidden((int)status.getCode());
        if (isError) {
            this.m_shell.setBackground(this.m_shell.getDisplay().getSystemColor(3));
        } else {
            this.m_shell.setBackground(this.m_shell.getDisplay().getSystemColor(5));
        }
    }

    public void setText(String input) {
        this.m_text.setText(input);
    }

    public void insertText(String text) {
        this.m_text.insert(text);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setSelection(int start) {
        this.m_text.setSelection(start);
    }

    public void setSelection(int start, int end) {
        this.m_text.setSelection(start, end);
    }

    public Point getSelection() {
        return this.m_text.getSelection();
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.m_text.addKeyListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_text.addModifyListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.m_text.addVerifyListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.m_text.removeKeyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_text.removeModifyListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.m_text.removeVerifyListener(listener);
    }

    public Color getBackground() {
        return this.m_text.getBackground();
    }

    public Color getForeground() {
        return this.m_text.getForeground();
    }

    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    public void setForeground(Color color) {
        this.m_text.setForeground(color);
    }
}

