/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.EmptyHttpFields;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpDateTime;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldsMap;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MutableHttpFields;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedQualityCSV;

public interface HttpFields
extends Iterable<HttpField>,
Supplier<HttpFields> {
    public static final HttpField EXPIRES_01JAN1970 = new PreEncodedHttpField(HttpHeader.EXPIRES, DateGenerator.__01Jan1970);
    public static final HttpField CONNECTION_CLOSE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
    public static final HttpField CONNECTION_KEEPALIVE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
    public static final HttpField CONTENT_LENGTH_0 = new PreEncodedHttpField(HttpHeader.CONTENT_LENGTH, 0L);
    public static final HttpFields EMPTY = new EmptyHttpFields();

    public static Mutable build() {
        return new org.eclipse.jetty.http.MutableHttpFields();
    }

    public static Mutable build(int capacity) {
        return new org.eclipse.jetty.http.MutableHttpFields(capacity);
    }

    public static Mutable build(HttpFields fields) {
        return new org.eclipse.jetty.http.MutableHttpFields(fields);
    }

    public static Mutable build(HttpFields fields, HttpField replaceField) {
        return new org.eclipse.jetty.http.MutableHttpFields(fields, replaceField);
    }

    public static Mutable build(HttpFields fields, EnumSet<HttpHeader> removeFields) {
        return new org.eclipse.jetty.http.MutableHttpFields(fields, removeFields);
    }

    public static Mutable build(HttpCompliance httpCompliance, BiConsumer<ComplianceViolation, String> notifyViolation) {
        return new MutableHttpFields.Compliant(httpCompliance, notifyViolation);
    }

    public static HttpFields from(HttpField ... fields) {
        return new org.eclipse.jetty.http.ImmutableHttpFields(fields);
    }

    @Override
    default public HttpFields get() {
        return this;
    }

    @Override
    default public Iterator<HttpField> iterator() {
        return this.listIterator();
    }

    default public ListIterator<HttpField> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<HttpField> listIterator(int var1);

    default public HttpFields asImmutable() {
        return HttpFields.build(this).asImmutable();
    }

    default public String asString() {
        StringBuilder buffer = new StringBuilder();
        for (HttpField field : this) {
            if (field == null) continue;
            String tmp = field.getName();
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append(": ");
            tmp = field.getValue();
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append("\r\n");
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    default public boolean contains(HttpField field) {
        for (HttpField f : this) {
            if (!f.isSameName(field) || !f.equals(field) && !f.contains(field.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(HttpHeader header, String value) {
        for (HttpField f : this) {
            if (f.getHeader() != header || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsLast(HttpHeader header, String value) {
        ListIterator<HttpField> i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            HttpField f = i.previous();
            if (f.getHeader() != header) continue;
            return f.containsLast(value);
        }
        return false;
    }

    default public boolean contains(String name, String value) {
        for (HttpField f : this) {
            if (!f.is(name) || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(EnumSet<HttpHeader> headers) {
        for (HttpField f : this) {
            if (!headers.contains((Object)f.getHeader())) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(String name) {
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            return true;
        }
        return false;
    }

    default public String get(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return f.getValue();
        }
        return null;
    }

    default public String getLast(HttpHeader header) {
        ListIterator<HttpField> i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            HttpField f = i.previous();
            if (f.getHeader() != header) continue;
            return f.getValue();
        }
        return null;
    }

    default public String get(String name) {
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            return f.getValue();
        }
        return null;
    }

    default public List<String> getCSV(HttpHeader header, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = this.newQuotedCSV(keepQuotes);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public List<String> getCSV(String name, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = this.newQuotedCSV(keepQuotes);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public long getDateField(String name) {
        return HttpFields.parseDateField(this.getField(name));
    }

    default public long getDateField(HttpHeader header) {
        return HttpFields.parseDateField(this.getField(header));
    }

    private static long parseDateField(HttpField field) {
        if (field == null) {
            return -1L;
        }
        String val = HttpField.getValueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        return TimeUnit.SECONDS.toMillis(HttpDateTime.parse(val).toEpochSecond());
    }

    default public HttpField getField(int index) {
        int i = 0;
        for (HttpField f : this) {
            if (i++ != index) continue;
            return f;
        }
        return null;
    }

    default public HttpField getField(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    default public HttpField getField(String name) {
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            return f;
        }
        return null;
    }

    @Deprecated
    default public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    default public Set<String> getFieldNamesCollection() {
        final EnumSet<HttpHeader> seenByHeader = EnumSet.noneOf(HttpHeader.class);
        TreeSet<String> buildByName = null;
        final ArrayList<String> list = new ArrayList<String>(this.size());
        for (HttpField f : this) {
            HttpHeader header = f.getHeader();
            if (header == null) {
                if (buildByName == null) {
                    buildByName = new TreeSet<String>(String::compareToIgnoreCase);
                }
                if (!buildByName.add(f.getName())) continue;
                list.add(f.getName());
                continue;
            }
            if (!seenByHeader.add(header)) continue;
            list.add(f.getName());
        }
        final TreeSet<String> seenByName = buildByName;
        return new AbstractSet<String>(this){
            final /* synthetic */ HttpFields this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<String> iterator() {
                return list.iterator();
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof String) {
                    String s = (String)o;
                    return seenByName != null && seenByName.contains(s) || seenByHeader.contains(HttpHeader.CACHE.get(s));
                }
                return false;
            }
        };
    }

    default public List<HttpField> getFields(HttpHeader header) {
        return this.getFields(header, (f, h) -> f.getHeader() == h);
    }

    default public List<HttpField> getFields(String name) {
        return this.getFields(name, (f, n) -> f.is(name));
    }

    private <T> List<HttpField> getFields(T header, BiPredicate<HttpField, T> predicate) {
        return this.stream().filter(f -> predicate.test((HttpField)f, header)).collect(Collectors.toList());
    }

    default public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    default public long getLongField(HttpHeader header) throws NumberFormatException {
        HttpField field = this.getField(header);
        return field == null ? -1L : field.getLongValue();
    }

    default public List<String> getQualityCSV(HttpHeader header) {
        return this.getQualityCSV(header, null);
    }

    default public List<String> getQualityCSV(HttpHeader header, ToIntFunction<String> secondaryOrdering) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = this.newQuotedQualityCSV(secondaryOrdering);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public List<String> getQualityCSV(String name) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = this.newQuotedQualityCSV(null);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public Enumeration<String> getValues(final String name) {
        final Iterator<HttpField> i = this.iterator();
        return new Enumeration<String>(this){
            HttpField _field;
            final /* synthetic */ HttpFields this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasMoreElements() {
                if (this._field != null) {
                    return true;
                }
                while (i.hasNext()) {
                    HttpField f = (HttpField)i.next();
                    if (!f.is(name) || f.getValue() == null) continue;
                    this._field = f;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this._field.getValue();
                    this._field = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    default public List<String> getValuesList(HttpHeader header) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            list.add(f.getValue());
        }
        return list;
    }

    default public List<String> getValuesList(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            list.add(f.getValue());
        }
        return list;
    }

    default public boolean isEqualTo(HttpFields that) {
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<HttpField> i = that.iterator();
        for (HttpField f : this) {
            if (!i.hasNext()) {
                return false;
            }
            if (f.equals(i.next())) continue;
            return false;
        }
        return !i.hasNext();
    }

    default public int size() {
        int size = 0;
        for (HttpField ignored : this) {
            ++size;
        }
        return size;
    }

    public static Map<String, List<String>> asMap(HttpFields fields) {
        HttpFieldsMap httpFieldsMap;
        if (fields instanceof Mutable) {
            Mutable mutable = (Mutable)fields;
            httpFieldsMap = new HttpFieldsMap.Mutable(mutable);
        } else {
            httpFieldsMap = new HttpFieldsMap.Immutable(fields);
        }
        return httpFieldsMap;
    }

    default public Stream<HttpField> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public QuotedCSV newQuotedCSV(boolean b) {
        return new QuotedCSV(b, new String[0]);
    }

    default public QuotedQualityCSV newQuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
        return new QuotedQualityCSV(secondaryOrdering);
    }

    public static interface Mutable
    extends HttpFields {
        default public Mutable add(String name, String value) {
            Objects.requireNonNull(name);
            if (value == null) {
                return this;
            }
            return this.add(new HttpField(name, value));
        }

        default public Mutable add(String name, long value) {
            Objects.requireNonNull(name);
            return this.add(new HttpField.LongValueHttpField(name, value));
        }

        default public Mutable add(HttpHeader header, HttpHeaderValue value) {
            Objects.requireNonNull(header);
            if (value == null) {
                return this;
            }
            return this.add(header, value.toString());
        }

        default public Mutable add(HttpHeader header, String value) {
            Objects.requireNonNull(header);
            if (value == null) {
                return this;
            }
            return this.add(new HttpField(header, value));
        }

        default public Mutable add(HttpHeader header, long value) {
            Objects.requireNonNull(header);
            return this.add(new HttpField.LongValueHttpField(header, value));
        }

        default public Mutable add(HttpField field) {
            Objects.requireNonNull(field);
            ListIterator<HttpField> i = this.listIterator(this.size());
            i.add(field);
            return this;
        }

        default public Mutable add(HttpFields fields) {
            Objects.requireNonNull(fields);
            for (HttpField field : fields) {
                this.add(field);
            }
            return this;
        }

        default public Mutable add(String name, List<String> list) {
            Objects.requireNonNull(name);
            if (list == null || list.isEmpty()) {
                return this;
            }
            if (list.size() == 1) {
                String v = list.get(0);
                return this.add(name, v == null ? "" : v);
            }
            HttpField.MultiHttpField field = new HttpField.MultiHttpField(name, list);
            return this.add(field);
        }

        default public Mutable addCSV(HttpHeader header, String ... values) {
            Objects.requireNonNull(header);
            QuotedCSV existing = null;
            for (HttpField f : this) {
                if (f.getHeader() != header) continue;
                if (existing == null) {
                    existing = this.newQuotedCSV(false);
                }
                existing.addValue(f.getValue());
            }
            String value = Mutable.formatCsvExcludingExisting(existing, values);
            if (value != null) {
                this.add(header, value);
            }
            return this;
        }

        default public Mutable addCSV(String name, String ... values) {
            Objects.requireNonNull(name);
            QuotedCSV existing = null;
            for (HttpField f : this) {
                if (!f.is(name)) continue;
                if (existing == null) {
                    existing = this.newQuotedCSV(false);
                }
                existing.addValue(f.getValue());
            }
            String value = Mutable.formatCsvExcludingExisting(existing, values);
            if (value != null) {
                this.add(name, value);
            }
            return this;
        }

        default public Mutable addDateField(String name, long date) {
            Objects.requireNonNull(name);
            this.add(name, DateGenerator.formatDate(date));
            return this;
        }

        default public Mutable clear() {
            Iterator<HttpField> i = this.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            return this;
        }

        default public void ensureField(HttpField field) {
            Objects.requireNonNull(field);
            HttpHeader header = field.getHeader();
            if (field.getValue().indexOf(44) < 0) {
                if (header != null) {
                    this.computeField(header, (HttpHeader h, List<HttpField> l) -> Mutable.computeEnsure(field, l));
                } else {
                    this.computeField(field.getName(), (String h, List<HttpField> l) -> Mutable.computeEnsure(field, l));
                }
            } else if (header != null) {
                this.computeField(header, (HttpHeader h, List<HttpField> l) -> Mutable.computeEnsure(field, field.getValues(), l));
            } else {
                this.computeField(field.getName(), (String h, List<HttpField> l) -> Mutable.computeEnsure(field, field.getValues(), l));
            }
        }

        default public Mutable put(HttpField field) {
            Objects.requireNonNull(field);
            boolean put = false;
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (!f.isSameName(field)) continue;
                if (put) {
                    i.remove();
                    continue;
                }
                i.set(field);
                put = true;
            }
            if (!put) {
                this.add(field);
            }
            return this;
        }

        default public Mutable put(String name, String value) {
            Objects.requireNonNull(name);
            if (value == null) {
                return this.remove(name);
            }
            return this.put(new HttpField(name, value));
        }

        default public Mutable put(HttpHeader header, HttpHeaderValue value) {
            Objects.requireNonNull(header);
            if (value == null) {
                return this.remove(header);
            }
            return this.put(new HttpField(header, value.toString()));
        }

        default public Mutable put(HttpHeader header, String value) {
            Objects.requireNonNull(header);
            if (value == null) {
                return this.remove(header);
            }
            return this.put(new HttpField(header, value));
        }

        default public Mutable put(String name, List<String> list) {
            Objects.requireNonNull(name);
            if (list == null || list.isEmpty()) {
                return this.remove(name);
            }
            if (list.size() == 1) {
                String value = list.get(0);
                return this.put(name, value == null ? "" : value);
            }
            HttpField.MultiHttpField field = new HttpField.MultiHttpField(name, list);
            return this.put(field);
        }

        default public Mutable putDate(HttpHeader name, long date) {
            Objects.requireNonNull(name);
            return this.put(name, DateGenerator.formatDate(date));
        }

        default public Mutable putDate(String name, long date) {
            Objects.requireNonNull(name);
            return this.put(name, DateGenerator.formatDate(date));
        }

        default public Mutable put(HttpHeader header, long value) {
            Objects.requireNonNull(header);
            if (value == 0L && header == HttpHeader.CONTENT_LENGTH) {
                return this.put(CONTENT_LENGTH_0);
            }
            return this.put(new HttpField.LongValueHttpField(header, value));
        }

        default public Mutable put(String name, long value) {
            Objects.requireNonNull(name);
            if (value == 0L && HttpHeader.CONTENT_LENGTH.is(name)) {
                return this.put(CONTENT_LENGTH_0);
            }
            return this.put(new HttpField.LongValueHttpField(name, value));
        }

        default public Mutable computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
            Objects.requireNonNull(header);
            HttpField result = computeFn.apply(header, this.stream().filter(f -> f.getHeader() == header).toList());
            return result != null ? this.put(result) : this.remove(header);
        }

        default public Mutable computeField(String name, BiFunction<String, List<HttpField>, HttpField> computeFn) {
            Objects.requireNonNull(name);
            HttpField result = computeFn.apply(name, this.stream().filter(f -> f.is(name)).toList());
            return result != null ? this.put(result) : this.remove(name);
        }

        default public Mutable remove(HttpHeader header) {
            Objects.requireNonNull(header);
            Iterator<HttpField> i = this.iterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (f.getHeader() != header) continue;
                i.remove();
            }
            return this;
        }

        default public Mutable remove(EnumSet<HttpHeader> headers) {
            Iterator<HttpField> i = this.iterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                HttpHeader h = f.getHeader();
                if (h == null || !headers.contains((Object)h)) continue;
                i.remove();
            }
            return this;
        }

        default public Mutable remove(String name) {
            Objects.requireNonNull(name);
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (!f.is(name)) continue;
                i.remove();
            }
            return this;
        }

        private static String formatCsvExcludingExisting(QuotedCSV existing, String ... values) {
            boolean add = true;
            if (existing != null && !existing.isEmpty()) {
                add = false;
                int i = values.length;
                while (i-- > 0) {
                    String unquoted = QuotedCSV.unquote(values[i]);
                    if (existing.getValues().contains(unquoted)) {
                        values[i] = null;
                        continue;
                    }
                    add = true;
                }
            }
            if (add) {
                StringBuilder value = new StringBuilder();
                for (String v : values) {
                    if (v == null) continue;
                    if (!value.isEmpty()) {
                        value.append(", ");
                    }
                    value.append(v);
                }
                if (!value.isEmpty()) {
                    return value.toString();
                }
            }
            return null;
        }

        private static HttpField computeEnsure(HttpField ensure, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return ensure;
            }
            String ensureValue = ensure.getValue();
            if (fields.size() == 1) {
                HttpField f = fields.get(0);
                return f.contains(ensureValue) ? f : new HttpField(ensure.getHeader(), ensure.getName(), f.getValue() + ", " + ensureValue);
            }
            StringBuilder v = new StringBuilder();
            for (HttpField f : fields) {
                if (!v.isEmpty()) {
                    v.append(", ");
                }
                v.append(f.getValue());
                if (ensureValue == null || !f.contains(ensureValue)) continue;
                ensureValue = null;
            }
            if (ensureValue != null) {
                v.append(", ").append(ensureValue);
            }
            return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
        }

        private static HttpField computeEnsure(HttpField ensure, String[] values, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return ensure;
            }
            if (fields.size() == 1) {
                HttpField f = fields.get(0);
                int ensured = values.length;
                for (int i = 0; i < values.length; ++i) {
                    if (!f.contains(values[i])) continue;
                    --ensured;
                    values[i] = null;
                }
                if (ensured == 0) {
                    return f;
                }
                if (ensured == values.length) {
                    return new HttpField(ensure.getHeader(), ensure.getName(), f.getValue() + ", " + ensure.getValue());
                }
                StringBuilder v = new StringBuilder(f.getValue());
                for (String value : values) {
                    if (value == null) continue;
                    v.append(", ").append(value);
                }
                return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
            }
            StringBuilder v = new StringBuilder();
            int ensured = values.length;
            for (HttpField f : fields) {
                if (!v.isEmpty()) {
                    v.append(", ");
                }
                v.append(f.getValue());
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || !f.contains(values[i])) continue;
                    --ensured;
                    values[i] = null;
                }
            }
            if (ensured == values.length) {
                v.append(", ").append(ensure.getValue());
            } else if (ensured > 0) {
                for (String value : values) {
                    if (value == null) continue;
                    v.append(", ").append(value);
                }
            }
            return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
        }

        public static class Wrapper
        implements Mutable {
            private final Mutable _fields;

            public Wrapper(Mutable fields) {
                this._fields = fields;
            }

            public Mutable getWrapped() {
                return this._fields;
            }

            public HttpField onAddField(HttpField field) {
                return field;
            }

            public boolean onRemoveField(HttpField field) {
                return true;
            }

            public HttpField onReplaceField(HttpField oldField, HttpField newField) {
                return newField;
            }

            @Override
            public QuotedCSV newQuotedCSV(boolean b) {
                return this.getWrapped().newQuotedCSV(b);
            }

            @Override
            public QuotedQualityCSV newQuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
                return this.getWrapped().newQuotedQualityCSV(secondaryOrdering);
            }

            @Override
            public int size() {
                return this._fields.size();
            }

            @Override
            public Stream<HttpField> stream() {
                return this._fields.stream();
            }

            @Override
            public Mutable add(HttpField field) {
                if (field != null && (field = this.onAddField(field)) != null) {
                    this._fields.add(field);
                }
                return this;
            }

            @Override
            public Mutable put(HttpField field) {
                Objects.requireNonNull(field);
                int put = -1;
                ListIterator<HttpField> i = this._fields.listIterator();
                while (i.hasNext()) {
                    HttpField f = i.next();
                    if (!f.isSameName(field)) continue;
                    if (put < 0) {
                        put = i.previousIndex();
                        continue;
                    }
                    if (!this.onRemoveField(f)) continue;
                    i.remove();
                }
                if (put < 0) {
                    if ((field = this.onAddField(field)) != null) {
                        this._fields.add(field);
                    }
                } else {
                    i = this._fields.listIterator(put);
                    HttpField old = i.next();
                    field = this.onReplaceField(old, field);
                    if (field == null) {
                        i.remove();
                    } else if (field != old) {
                        i.set(field);
                    }
                }
                return this;
            }

            @Override
            public Mutable clear() {
                this._fields.clear();
                return this;
            }

            @Override
            public ListIterator<HttpField> listIterator(int index) {
                final ListIterator<HttpField> i = this._fields.listIterator(index);
                return new ListIterator<HttpField>(this){
                    HttpField last;
                    final /* synthetic */ Wrapper this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public HttpField next() {
                        this.last = (HttpField)i.next();
                        return this.last;
                    }

                    @Override
                    public boolean hasPrevious() {
                        return i.hasPrevious();
                    }

                    @Override
                    public HttpField previous() {
                        this.last = (HttpField)i.previous();
                        return this.last;
                    }

                    @Override
                    public int nextIndex() {
                        return i.nextIndex();
                    }

                    @Override
                    public int previousIndex() {
                        return i.previousIndex();
                    }

                    @Override
                    public void remove() {
                        if (this.last != null && this.this$0.onRemoveField(this.last)) {
                            this.last = null;
                            i.remove();
                        }
                    }

                    @Override
                    public void set(HttpField field) {
                        if (field == null) {
                            if (this.last != null && this.this$0.onRemoveField(this.last)) {
                                this.last = null;
                                i.remove();
                            }
                        } else if (this.last != null) {
                            if ((field = this.this$0.onReplaceField(this.last, field)) == null) {
                                this.last = null;
                                i.remove();
                            } else if (field != this.last) {
                                this.last = null;
                                i.set(field);
                            }
                        }
                    }

                    @Override
                    public void add(HttpField field) {
                        if (field != null && (field = this.this$0.onAddField(field)) != null) {
                            this.last = null;
                            i.add(field);
                        }
                    }
                };
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static class ImmutableHttpFields
    extends org.eclipse.jetty.http.ImmutableHttpFields {
        protected ImmutableHttpFields(HttpField[] fields, int size) {
            super(fields, size);
        }
    }

    @Deprecated(forRemoval=true)
    public static class MutableHttpFields
    extends org.eclipse.jetty.http.MutableHttpFields {
    }
}

