/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting.internal;

import org.eclipse.rap.clientscripting.internal.ClientFunction;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class ClientListenerBinding {
    private static final String REMOTE_TYPE = "rwt.scripting.EventBinding";
    private final ClientFunction function;
    private final String targetId;
    private final String eventType;
    private final RemoteObject remoteObject;
    private boolean disposed;

    public ClientListenerBinding(ClientFunction function, String targetId, String eventType) {
        this.function = function;
        this.targetId = targetId;
        this.eventType = eventType;
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.set("listener", function.getRemoteId());
        this.remoteObject.set("targetObject", targetId);
        this.remoteObject.set("eventType", eventType);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void dispose() {
        if (!this.disposed) {
            this.remoteObject.destroy();
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            ClientListenerBinding other = (ClientListenerBinding)obj;
            if (this.eventType.equals(other.eventType) && this.targetId.equals(other.targetId) && this.function == other.function) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.eventType.hashCode();
        result = 31 * result + this.targetId.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }
}

