/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart;

import org.eclipse.rap.addons.chart.Chart;
import org.eclipse.rap.addons.chart.internal.ColorUtil;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public abstract class NvChart
extends Chart {
    private static final String PROP_NVD3_JS_URL = "org.eclipse.rap.addons.chart.nvd3JsUrl";
    private static final String PROP_NVD3_CSS_URL = "org.eclipse.rap.addons.chart.nvd3CssUrl";
    private static final String DEF_NVD3_JS_URL = "https://cdnjs.cloudflare.com/ajax/libs/nvd3/1.8.1/nv.d3.min.js";
    private static final String DEF_NVD3_CSS_URL = "https://cdnjs.cloudflare.com/ajax/libs/nvd3/1.8.1/nv.d3.min.css";
    private String noData;
    private boolean showLegend = true;
    private boolean tooltipsEnabled = true;
    private RGB[] colors;
    private BoxDimensions margin;

    protected NvChart(Composite parent, int style, String renderer) {
        super(parent, style, renderer);
        this.requireJs(System.getProperty(PROP_NVD3_JS_URL, DEF_NVD3_JS_URL));
        this.requireCss(System.getProperty(PROP_NVD3_CSS_URL, DEF_NVD3_CSS_URL));
        this.requireCss(this.registerResource("resources/nv-chart.css"));
    }

    public void setNoDataMessage(String text) {
        this.checkWidget();
        if (text != null && !text.equals(this.noData)) {
            this.noData = text;
            this.setOption("noData", text);
        }
    }

    public String getNoDataMessage() {
        this.checkWidget();
        return this.noData;
    }

    public void setShowLegend(boolean show) {
        this.checkWidget();
        if (this.showLegend != show) {
            this.showLegend = show;
            this.setOption("showLegend", show);
        }
    }

    public boolean getShowLegend() {
        this.checkWidget();
        return this.showLegend;
    }

    public void setTooltipsEnabled(boolean enabled) {
        this.checkWidget();
        if (this.tooltipsEnabled != enabled) {
            this.tooltipsEnabled = enabled;
            this.setOption("tooltip.enabled", enabled);
        }
    }

    public boolean isTooltipsEnabled() {
        this.checkWidget();
        return this.tooltipsEnabled;
    }

    public void setColors(RGB[] colors) {
        this.checkWidget();
        if (colors != null && !colors.equals(this.colors)) {
            this.colors = colors;
            this.setOption("colorScale", (JsonValue)ColorUtil.toJson(colors));
        }
    }

    public RGB[] getColors() {
        this.checkWidget();
        return this.colors;
    }

    public void setMargin(BoxDimensions margin) {
        this.checkWidget();
        if (margin != null && !margin.equals((Object)this.margin)) {
            this.margin = margin;
            JsonObject marginJson = new JsonObject().add("top", margin.top).add("right", margin.right).add("bottom", margin.bottom).add("left", margin.left);
            this.setOption("margin", (JsonValue)marginJson);
        }
    }

    public BoxDimensions getMargin() {
        this.checkWidget();
        return this.margin;
    }
}

