/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageUtilities {
    public static Image createRotatedImageOfString(String string, Font font, Color foreground, Color background) {
        Display display = Display.getDefault();
        FontMetrics metrics = FigureUtilities.getFontMetrics(font);
        Dimension strSize = FigureUtilities.getStringExtents(string, font);
        Image srcImage = new Image((Device)display, strSize.width, metrics.getHeight());
        GC gc = new GC((Drawable)srcImage.getDevice());
        gc.setFont(font);
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.fillRectangle(srcImage.getBounds());
        gc.drawString(string, 0, 0);
        Image result = ImageUtilities.createRotatedImage(srcImage);
        gc.dispose();
        srcImage.dispose();
        return result;
    }

    public static Image createRotatedImage(Image srcImage) {
        Display display = Display.getDefault();
        ImageData srcData = srcImage.getImageData();
        ImageData destData = srcData.depth < 8 ? ImageUtilities.rotatePixelByPixel(srcData) : ImageUtilities.rotateOptimized(srcData);
        return new Image((Device)display, destData);
    }

    public static ImageData createShadedImage(Image fromImage, Color shade) {
        Rectangle r = fromImage.getBounds();
        ImageData data = fromImage.getImageData();
        PaletteData palette = data.palette;
        if (!palette.isDirect) {
            RGB[] rgbs = palette.getRGBs();
            int i = 0;
            while (i < rgbs.length) {
                if (data.transparentPixel != i) {
                    RGB color = rgbs[i];
                    color.red = ImageUtilities.determineShading(color.red, shade.getRed());
                    color.blue = ImageUtilities.determineShading(color.blue, shade.getBlue());
                    color.green = ImageUtilities.determineShading(color.green, shade.getGreen());
                }
                ++i;
            }
            data.palette = new PaletteData(rgbs);
        } else {
            int[] scanline = new int[r.width];
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int redShift = palette.redShift;
            int greenShift = palette.greenShift;
            int blueShift = palette.blueShift;
            int y = 0;
            while (y < r.height) {
                data.getPixels(0, y, r.width, scanline, 0);
                int x = 0;
                while (x < r.width) {
                    int pixel = scanline[x];
                    int red = pixel & redMask;
                    red = redShift < 0 ? red >>> -redShift : red << redShift;
                    int green = pixel & greenMask;
                    green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                    int blue = pixel & blueMask;
                    blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                    red = ImageUtilities.determineShading(red, shade.getRed());
                    blue = ImageUtilities.determineShading(blue, shade.getBlue());
                    green = ImageUtilities.determineShading(green, shade.getGreen());
                    red = redShift < 0 ? red << -redShift : red >> redShift;
                    green = greenShift < 0 ? green << -greenShift : green >> greenShift;
                    blue = blueShift < 0 ? blue << -blueShift : blue >> blueShift;
                    scanline[x] = (red &= redMask) | (blue &= blueMask) | (green &= greenMask);
                    ++x;
                }
                data.setPixels(0, y, r.width, scanline, 0);
                ++y;
            }
        }
        return data;
    }

    private static int determineShading(int origColor, int shadeColor) {
        return (origColor + shadeColor) / 2;
    }

    private static ImageData rotateOptimized(ImageData srcData) {
        int bytesPerPixel = Math.max(1, srcData.depth / 8);
        int destBytesPerLine = ((srcData.height * bytesPerPixel - 1) / srcData.scanlinePad + 1) * srcData.scanlinePad;
        byte[] newData = new byte[destBytesPerLine * srcData.width];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = srcY;
                int destY = srcData.width - srcX - 1;
                int destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                int srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette, srcData.scanlinePad, newData);
    }

    private static ImageData rotatePixelByPixel(ImageData srcData) {
        ImageData destData = new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette);
        int y = 0;
        while (y < srcData.height) {
            int x = 0;
            while (x < srcData.width) {
                destData.setPixel(y, srcData.width - x - 1, srcData.getPixel(x, y));
                ++x;
            }
            ++y;
        }
        return destData;
    }
}

