/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.autosuggest;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.addons.autosuggest.ColumnTemplate;
import org.eclipse.rap.addons.autosuggest.DataSource;
import org.eclipse.rap.addons.autosuggest.SuggestionSelectedListener;
import org.eclipse.rap.addons.autosuggest.internal.resources.AutoSuggestListener;
import org.eclipse.rap.addons.autosuggest.internal.resources.EventDelegatorListener;
import org.eclipse.rap.addons.autosuggest.internal.resources.ModelResources;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.scripting.ClientFunction;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.rap.rwt.widgets.DropDown;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AutoSuggest {
    private static final String EVENT_TYPE_SELECTION = "suggestionSelected";
    private static final String REMOTE_TYPE = "rwt.remote.Model";
    private static final String MODEL_ID_KEY = "org.eclipse.rap.addons.autosuggest#Model";
    protected final Text text;
    protected final DropDown dropDown;
    private final List<SuggestionSelectedListener> selectionListeners;
    private ClientListener textClientListener;
    private int[] textClientListenerTypes;
    private boolean isDisposed;
    protected final RemoteObject remoteObject;

    public AutoSuggest(Text text) {
        if (text == null) {
            throw new NullPointerException("Text must not be null");
        }
        if (text.isDisposed()) {
            throw new IllegalArgumentException("Text must not be disposed");
        }
        this.text = text;
        this.dropDown = new DropDown((Control)text);
        ModelResources.ensure();
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler((OperationHandler)new AbstractOperationHandler(){

            public void handleNotify(String event, JsonObject properties) {
                if (AutoSuggest.EVENT_TYPE_SELECTION.equals(event)) {
                    AutoSuggest.this.notifySelectionListeners();
                }
            }
        });
        this.selectionListeners = new ArrayList<SuggestionSelectedListener>(1);
        this.connectClientObjects();
        this.attachClientListeners();
        text.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AutoSuggest.this.dispose();
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        ColumnTemplate template;
        this.checkDisposed();
        if (dataSource != null && dataSource.isDisposed()) {
            throw new IllegalArgumentException("DataSource is disposed");
        }
        this.remoteObject.set("dataSourceId", dataSource != null ? dataSource.getId() : null);
        if (dataSource != null && (template = dataSource.getTemplate()) != null) {
            this.dropDown.setData("columns", (Object)template.getColumnWidths());
        }
    }

    public void setVisibleItemCount(int itemCount) {
        this.checkDisposed();
        this.dropDown.setVisibleItemCount(itemCount);
    }

    public int getVisibleItemCount() {
        this.checkDisposed();
        return this.dropDown.getVisibleItemCount();
    }

    public void setAutoComplete(boolean value) {
        this.checkDisposed();
        this.remoteObject.set("autoComplete", value);
    }

    public void addSelectionListener(SuggestionSelectedListener listener) {
        this.checkDisposed();
        if (listener == null) {
            throw new NullPointerException("Parameter was null: listener");
        }
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
        if (this.selectionListeners.size() == 1) {
            this.remoteObject.listen(EVENT_TYPE_SELECTION, true);
        }
    }

    public void removeSelectionListener(SuggestionSelectedListener listener) {
        this.checkDisposed();
        if (listener == null) {
            throw new NullPointerException("Parameter was null: listener");
        }
        this.selectionListeners.remove(listener);
        if (this.selectionListeners.size() == 0) {
            this.remoteObject.listen(EVENT_TYPE_SELECTION, false);
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.dropDown.dispose();
            this.remoteObject.destroy();
            this.removeTextClientListeners();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    DropDown getDropDown() {
        return this.dropDown;
    }

    protected void notifySelectionListeners() {
        for (SuggestionSelectedListener listener : this.selectionListeners) {
            listener.suggestionSelected();
        }
    }

    private void checkDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("AutoSuggest is disposed");
        }
    }

    private void attachClientListeners() {
        int[] dropDownEventTypes = new int[]{22, 23, 13, 14};
        this.attachClientListenerToDropDown(EventDelegatorListener.getInstance(), dropDownEventTypes);
        this.attachClientListenerToText(EventDelegatorListener.getInstance(), this.getTextEventTypes());
        this.attachClientListenerToModel(this.getAutoSuggestListener(), "change", "accept");
    }

    protected int[] getTextEventTypes() {
        return new int[]{24, 25};
    }

    protected ClientListener getAutoSuggestListener() {
        return AutoSuggestListener.getInstance();
    }

    private void attachClientListenerToText(ClientListener listener, int ... types) {
        this.textClientListenerTypes = types;
        this.textClientListener = listener;
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.text.addListener(type, (Listener)listener);
            ++n2;
        }
    }

    private void attachClientListenerToDropDown(ClientListener listener, int ... types) {
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.dropDown.addListener(type, (Listener)listener);
            ++n2;
        }
    }

    private void attachClientListenerToModel(ClientListener listener, String ... types) {
        String listenerId = ClientListenerUtil.getRemoteId((ClientFunction)listener);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.remoteObject.call("addListener", new JsonObject().add("listener", listenerId).add("type", type));
            ++n2;
        }
        this.remoteObject.set("autoSuggestListenerId", listenerId);
    }

    private void connectClientObjects() {
        WidgetUtil.registerDataKeys((String[])new String[]{MODEL_ID_KEY});
        this.remoteObject.set("textWidgetId", WidgetUtil.getId((Widget)this.text));
        this.remoteObject.set("dropDownWidgetId", WidgetUtil.getId((Widget)this.dropDown));
        this.dropDown.setData(MODEL_ID_KEY, (Object)this.remoteObject.getId());
        this.text.setData(MODEL_ID_KEY, (Object)this.remoteObject.getId());
    }

    private void removeTextClientListeners() {
        int[] nArray = this.textClientListenerTypes;
        int n = this.textClientListenerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.text.removeListener(type, (Listener)this.textClientListener);
            ++n2;
        }
    }
}

