/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.emf.common.notify.Notifier;
import org.osgi.framework.ServiceRegistration;

public class E4Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String INITIAL_WORKBENCH_MODEL_URI = "initialWorkbenchModelURI";
    public static final String INSTANCE_LOCATION = "instanceLocation";
    public static final String RENDERER_FACTORY_URI = "rendererFactoryUri";
    @Deprecated
    public static final String DELTA_RESTORE = "deltaRestore";
    public static final String RTL_MODE = "dir";
    public static final String FORCED_PERSPECTIVE_ID = "forcedPerspetiveId";
    public static final String NO_SAVED_MODEL_FOUND = "NO_SAVED_MODEL_FOUND";
    public static final String FORCED_SHOW_LOCATION = "forcedShowLocation";
    private final String id = this.createId();
    private ServiceRegistration<?> osgiRegistration;
    IEclipseContext appContext;
    IPresentationEngine renderer;
    MApplication appModel = null;
    private UIEventPublisher uiEventPublisher;
    private boolean restart;

    public IEclipseContext getContext() {
        return this.appContext;
    }

    public E4Workbench(MApplicationElement uiRoot, IEclipseContext applicationContext) {
        this.appContext = applicationContext;
        this.appContext.set(IWorkbench.class.getName(), (Object)this);
        if (uiRoot instanceof MApplication) {
            this.appModel = (MApplication)uiRoot;
        }
        if (uiRoot instanceof MApplication) {
            this.init((MApplication)uiRoot);
        }
        this.uiEventPublisher = new UIEventPublisher(this.appContext);
        this.appContext.set(UIEventPublisher.class, (Object)this.uiEventPublisher);
        ((Notifier)uiRoot).eAdapters().add((Object)this.uiEventPublisher);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("id", this.getId());
        this.osgiRegistration = Activator.getDefault().getContext().registerService(IWorkbench.class.getName(), (Object)this, properties);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    protected String createId() {
        return UUID.randomUUID().toString();
    }

    public void createAndRunUI(MApplicationElement uiRoot) {
        this.instantiateRenderer();
        if (this.renderer != null) {
            this.renderer.run(uiRoot, this.appContext);
        }
    }

    public void instantiateRenderer() {
        this.renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        if (this.renderer == null) {
            String presentationURI = (String)this.appContext.get("presentationURI");
            if (presentationURI != null) {
                IContributionFactory factory = (IContributionFactory)this.appContext.get(IContributionFactory.class.getName());
                this.renderer = (IPresentationEngine)factory.create(presentationURI, this.appContext);
                this.appContext.set(IPresentationEngine.class.getName(), (Object)this.renderer);
            }
            if (this.renderer == null) {
                Logger logger = (Logger)this.appContext.get(Logger.class.getName());
                logger.error("Failed to create the presentation engine for URI: " + presentationURI);
            }
        }
    }

    private void init(MApplication appElement) {
        Activator.trace("/trace/workbench", "init() workbench", null);
        IEclipseContext context = appElement.getContext();
        if (context != null) {
            context.set("org.eclipse.e4.core.commands.ExpressionContext.allowActivation", (Object)Boolean.TRUE);
        }
    }

    @Override
    public boolean close() {
        if (this.renderer != null) {
            this.renderer.stop();
        }
        if (this.uiEventPublisher != null && this.appModel != null) {
            ((Notifier)this.appModel).eAdapters().remove((Object)this.uiEventPublisher);
            this.uiEventPublisher = null;
        }
        if (this.osgiRegistration != null) {
            this.osgiRegistration.unregister();
            this.osgiRegistration = null;
        }
        return true;
    }

    @Override
    public boolean restart() {
        this.restart = true;
        return this.close();
    }

    public boolean isRestart() {
        return this.restart;
    }

    @Override
    public MApplication getApplication() {
        return this.appModel;
    }

    public static IEclipseContext initializeContext(IEclipseContext parentContext, MContext contextModel) {
        IEclipseContext context = contextModel.getContext() != null ? contextModel.getContext() : parentContext.createChild("PartContext(" + String.valueOf(contextModel) + ")");
        Activator.trace("/trace/eclipse.context", "initializeContext(" + parentContext.toString() + ", " + String.valueOf(contextModel) + ")", null);
        ContributionsAnalyzer.populateModelInterfaces(contextModel, context, contextModel.getClass().getInterfaces());
        List containedProperties = contextModel.getVariables();
        for (String name : containedProperties) {
            context.declareModifiable(name);
        }
        contextModel.setContext(context);
        return context;
    }
}

