/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.ee10.servlet.ResourceServlet;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends ResourceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    public static final String CONTEXT_INIT = "org.eclipse.jetty.servlet.Default.";
    private final AtomicBoolean warned = new AtomicBoolean(false);

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public void init() throws ServletException {
        if ("true".equalsIgnoreCase(this.getInitParameter("pathInfoOnly"))) {
            LOG.warn("DefaultServlet pathInfoOnly is set to true. Use ResourceServlet instead.");
        }
        super.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(request, response);
        } else {
            super.doPost(request, response);
        }
    }

    @Override
    protected String getEncodedPathInContext(HttpServletRequest request, boolean included) {
        String deprecatedPath = this.getEncodedPathInContext(request, (String)(included ? request.getAttribute("jakarta.servlet.include.servlet_path") : null));
        if (deprecatedPath != null) {
            return deprecatedPath;
        }
        if (request.getHttpServletMapping().getMappingMatch() != MappingMatch.DEFAULT) {
            if (this.warned.compareAndSet(false, true)) {
                LOG.warn("Incorrect mapping for DefaultServlet at %s. Use ResourceServlet".formatted(request.getHttpServletMapping().getPattern()));
            }
            return super.getEncodedPathInContext(request, included);
        }
        if (included) {
            Object object = request.getAttribute("jakarta.servlet.include.servlet_path");
            if (object instanceof String) {
                String servletPath = (String)object;
                return URIUtil.encodePath((String)servletPath);
            }
            return URIUtil.encodePath((String)request.getServletPath());
        }
        if (request instanceof ServletApiRequest) {
            ServletApiRequest apiRequest = (ServletApiRequest)request;
            return Context.getPathInContext((String)request.getContextPath(), (String)apiRequest.getRequest().getHttpURI().getCanonicalPath());
        }
        return URIUtil.encodePath((String)request.getServletPath());
    }

    @Deprecated(forRemoval=true)
    protected String getEncodedPathInContext(HttpServletRequest req, String includedServletPath) {
        return null;
    }
}

